/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _cpinfoexAPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _cpinfoexAPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_cpinfoexA.class)
public class _cpinfoexAPointer extends StructurePointer {

	// NULL
	public static final _cpinfoexAPointer NULL = new _cpinfoexAPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _cpinfoexAPointer(long address) {
		super(address);
	}

	public static _cpinfoexAPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _cpinfoexAPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _cpinfoexAPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _cpinfoexAPointer(address);
	}

	public _cpinfoexAPointer add(long count) {
		return _cpinfoexAPointer.cast(address + (_cpinfoexA.SIZEOF * count));
	}

	public _cpinfoexAPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _cpinfoexAPointer addOffset(long offset) {
		return _cpinfoexAPointer.cast(address + offset);
	}

	public _cpinfoexAPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _cpinfoexAPointer sub(long count) {
		return _cpinfoexAPointer.cast(address - (_cpinfoexA.SIZEOF * count));
	}

	public _cpinfoexAPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _cpinfoexAPointer subOffset(long offset) {
		return _cpinfoexAPointer.cast(address - offset);
	}

	public _cpinfoexAPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _cpinfoexAPointer untag(long mask) {
		return _cpinfoexAPointer.cast(address & ~mask);
	}

	public _cpinfoexAPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _cpinfoexA.SIZEOF;
	}

	// Implementation methods

	// U32 CodePage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CodePageOffset_", declaredType="U32")
	public UDATA CodePage() throws CorruptDataException {
		return new U32(getIntAtOffset(_cpinfoexA._CodePageOffset_));
	}

	// U32 CodePage
	public UDATAPointer CodePageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_cpinfoexA._CodePageOffset_));
	}

	// U8[] CodePageName
	public U8Pointer CodePageNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_cpinfoexA._CodePageNameOffset_));
	}

	// U8[] DefaultChar
	public U8Pointer DefaultCharEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_cpinfoexA._DefaultCharOffset_));
	}

	// U8[] LeadByte
	public U8Pointer LeadByteEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_cpinfoexA._LeadByteOffset_));
	}

	// U32 MaxCharSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MaxCharSizeOffset_", declaredType="U32")
	public UDATA MaxCharSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_cpinfoexA._MaxCharSizeOffset_));
	}

	// U32 MaxCharSize
	public UDATAPointer MaxCharSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_cpinfoexA._MaxCharSizeOffset_));
	}

	// U16 UnicodeDefaultChar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_UnicodeDefaultCharOffset_", declaredType="U16")
	public U16 UnicodeDefaultChar() throws CorruptDataException {
		return new U16(getShortAtOffset(_cpinfoexA._UnicodeDefaultCharOffset_));
	}

	// U16 UnicodeDefaultChar
	public U16Pointer UnicodeDefaultCharEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_cpinfoexA._UnicodeDefaultCharOffset_));
	}

}
