/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _dbg_entrypointsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _dbg_entrypointsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_dbg_entrypoints.class)
public class _dbg_entrypointsPointer extends StructurePointer {

	// NULL
	public static final _dbg_entrypointsPointer NULL = new _dbg_entrypointsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _dbg_entrypointsPointer(long address) {
		super(address);
	}

	public static _dbg_entrypointsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _dbg_entrypointsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _dbg_entrypointsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _dbg_entrypointsPointer(address);
	}

	public _dbg_entrypointsPointer add(long count) {
		return _dbg_entrypointsPointer.cast(address + (_dbg_entrypoints.SIZEOF * count));
	}

	public _dbg_entrypointsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _dbg_entrypointsPointer addOffset(long offset) {
		return _dbg_entrypointsPointer.cast(address + offset);
	}

	public _dbg_entrypointsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _dbg_entrypointsPointer sub(long count) {
		return _dbg_entrypointsPointer.cast(address - (_dbg_entrypoints.SIZEOF * count));
	}

	public _dbg_entrypointsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _dbg_entrypointsPointer subOffset(long offset) {
		return _dbg_entrypointsPointer.cast(address - offset);
	}

	public _dbg_entrypointsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _dbg_entrypointsPointer untag(long mask) {
		return _dbg_entrypointsPointer.cast(address & ~mask);
	}

	public _dbg_entrypointsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _dbg_entrypoints.SIZEOF;
	}

	// Implementation methods

	// void* ImagehlpApiVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ImagehlpApiVersionOffset_", declaredType="void*")
	public VoidPointer ImagehlpApiVersion() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._ImagehlpApiVersionOffset_));
	}

	// void* ImagehlpApiVersion
	public PointerPointer ImagehlpApiVersionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._ImagehlpApiVersionOffset_));
	}

	// void* StackWalk64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StackWalk64Offset_", declaredType="void*")
	public VoidPointer StackWalk64() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._StackWalk64Offset_));
	}

	// void* StackWalk64
	public PointerPointer StackWalk64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._StackWalk64Offset_));
	}

	// void* SymCleanup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymCleanupOffset_", declaredType="void*")
	public VoidPointer SymCleanup() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymCleanupOffset_));
	}

	// void* SymCleanup
	public PointerPointer SymCleanupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymCleanupOffset_));
	}

	// void* SymFromAddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymFromAddrOffset_", declaredType="void*")
	public VoidPointer SymFromAddr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymFromAddrOffset_));
	}

	// void* SymFromAddr
	public PointerPointer SymFromAddrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymFromAddrOffset_));
	}

	// void* SymFunctionTableAccess64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymFunctionTableAccess64Offset_", declaredType="void*")
	public VoidPointer SymFunctionTableAccess64() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymFunctionTableAccess64Offset_));
	}

	// void* SymFunctionTableAccess64
	public PointerPointer SymFunctionTableAccess64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymFunctionTableAccess64Offset_));
	}

	// void* SymGetLineFromAddr64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymGetLineFromAddr64Offset_", declaredType="void*")
	public VoidPointer SymGetLineFromAddr64() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymGetLineFromAddr64Offset_));
	}

	// void* SymGetLineFromAddr64
	public PointerPointer SymGetLineFromAddr64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymGetLineFromAddr64Offset_));
	}

	// void* SymGetModuleBase64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymGetModuleBase64Offset_", declaredType="void*")
	public VoidPointer SymGetModuleBase64() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymGetModuleBase64Offset_));
	}

	// void* SymGetModuleBase64
	public PointerPointer SymGetModuleBase64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymGetModuleBase64Offset_));
	}

	// void* SymGetModuleInfo64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymGetModuleInfo64Offset_", declaredType="void*")
	public VoidPointer SymGetModuleInfo64() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymGetModuleInfo64Offset_));
	}

	// void* SymGetModuleInfo64
	public PointerPointer SymGetModuleInfo64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymGetModuleInfo64Offset_));
	}

	// void* SymGetOptions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymGetOptionsOffset_", declaredType="void*")
	public VoidPointer SymGetOptions() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymGetOptionsOffset_));
	}

	// void* SymGetOptions
	public PointerPointer SymGetOptionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymGetOptionsOffset_));
	}

	// void* SymInitializeW
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymInitializeWOffset_", declaredType="void*")
	public VoidPointer SymInitializeW() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymInitializeWOffset_));
	}

	// void* SymInitializeW
	public PointerPointer SymInitializeWEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymInitializeWOffset_));
	}

	// void* SymSetOptions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SymSetOptionsOffset_", declaredType="void*")
	public VoidPointer SymSetOptions() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dbg_entrypoints._SymSetOptionsOffset_));
	}

	// void* SymSetOptions
	public PointerPointer SymSetOptionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._SymSetOptionsOffset_));
	}

	// HINSTANCE__* hDbgHelpLib
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hDbgHelpLibOffset_", declaredType="HINSTANCE__*")
	public HINSTANCE__Pointer hDbgHelpLib() throws CorruptDataException {
		return HINSTANCE__Pointer.cast(getPointerAtOffset(_dbg_entrypoints._hDbgHelpLibOffset_));
	}

	// HINSTANCE__* hDbgHelpLib
	public PointerPointer hDbgHelpLibEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dbg_entrypoints._hDbgHelpLibOffset_));
	}

}
