/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _stat64i32Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _stat64i32Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_stat64i32.class)
public class _stat64i32Pointer extends StructurePointer {

	// NULL
	public static final _stat64i32Pointer NULL = new _stat64i32Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _stat64i32Pointer(long address) {
		super(address);
	}

	public static _stat64i32Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _stat64i32Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _stat64i32Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _stat64i32Pointer(address);
	}

	public _stat64i32Pointer add(long count) {
		return _stat64i32Pointer.cast(address + (_stat64i32.SIZEOF * count));
	}

	public _stat64i32Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _stat64i32Pointer addOffset(long offset) {
		return _stat64i32Pointer.cast(address + offset);
	}

	public _stat64i32Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _stat64i32Pointer sub(long count) {
		return _stat64i32Pointer.cast(address - (_stat64i32.SIZEOF * count));
	}

	public _stat64i32Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _stat64i32Pointer subOffset(long offset) {
		return _stat64i32Pointer.cast(address - offset);
	}

	public _stat64i32Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _stat64i32Pointer untag(long mask) {
		return _stat64i32Pointer.cast(address & ~mask);
	}

	public _stat64i32Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _stat64i32.SIZEOF;
	}

	// Implementation methods

	// I64 st_atime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_atimeOffset_", declaredType="I64")
	public IDATA st_atime() throws CorruptDataException {
		return new I64(getLongAtOffset(_stat64i32._st_atimeOffset_));
	}

	// I64 st_atime
	public IDATAPointer st_atimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_stat64i32._st_atimeOffset_));
	}

	// I64 st_ctime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_ctimeOffset_", declaredType="I64")
	public IDATA st_ctime() throws CorruptDataException {
		return new I64(getLongAtOffset(_stat64i32._st_ctimeOffset_));
	}

	// I64 st_ctime
	public IDATAPointer st_ctimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_stat64i32._st_ctimeOffset_));
	}

	// U32 st_dev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_devOffset_", declaredType="U32")
	public UDATA st_dev() throws CorruptDataException {
		return new U32(getIntAtOffset(_stat64i32._st_devOffset_));
	}

	// U32 st_dev
	public UDATAPointer st_devEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_stat64i32._st_devOffset_));
	}

	// I16 st_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_gidOffset_", declaredType="I16")
	public I16 st_gid() throws CorruptDataException {
		return new I16(getShortAtOffset(_stat64i32._st_gidOffset_));
	}

	// I16 st_gid
	public I16Pointer st_gidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_stat64i32._st_gidOffset_));
	}

	// U16 st_ino
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_inoOffset_", declaredType="U16")
	public U16 st_ino() throws CorruptDataException {
		return new U16(getShortAtOffset(_stat64i32._st_inoOffset_));
	}

	// U16 st_ino
	public U16Pointer st_inoEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_stat64i32._st_inoOffset_));
	}

	// U16 st_mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_modeOffset_", declaredType="U16")
	public U16 st_mode() throws CorruptDataException {
		return new U16(getShortAtOffset(_stat64i32._st_modeOffset_));
	}

	// U16 st_mode
	public U16Pointer st_modeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_stat64i32._st_modeOffset_));
	}

	// I64 st_mtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_mtimeOffset_", declaredType="I64")
	public IDATA st_mtime() throws CorruptDataException {
		return new I64(getLongAtOffset(_stat64i32._st_mtimeOffset_));
	}

	// I64 st_mtime
	public IDATAPointer st_mtimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_stat64i32._st_mtimeOffset_));
	}

	// I16 st_nlink
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_nlinkOffset_", declaredType="I16")
	public I16 st_nlink() throws CorruptDataException {
		return new I16(getShortAtOffset(_stat64i32._st_nlinkOffset_));
	}

	// I16 st_nlink
	public I16Pointer st_nlinkEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_stat64i32._st_nlinkOffset_));
	}

	// U32 st_rdev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_rdevOffset_", declaredType="U32")
	public UDATA st_rdev() throws CorruptDataException {
		return new U32(getIntAtOffset(_stat64i32._st_rdevOffset_));
	}

	// U32 st_rdev
	public UDATAPointer st_rdevEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_stat64i32._st_rdevOffset_));
	}

	// I32 st_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_sizeOffset_", declaredType="I32")
	public IDATA st_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_stat64i32._st_sizeOffset_));
	}

	// I32 st_size
	public IDATAPointer st_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_stat64i32._st_sizeOffset_));
	}

	// I16 st_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_uidOffset_", declaredType="I16")
	public I16 st_uid() throws CorruptDataException {
		return new I16(getShortAtOffset(_stat64i32._st_uidOffset_));
	}

	// I16 st_uid
	public I16Pointer st_uidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_stat64i32._st_uidOffset_));
	}

}
