/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: group_filterPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the group_filterPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=group_filter.class)
public class group_filterPointer extends StructurePointer {

	// NULL
	public static final group_filterPointer NULL = new group_filterPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected group_filterPointer(long address) {
		super(address);
	}

	public static group_filterPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static group_filterPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static group_filterPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new group_filterPointer(address);
	}

	public group_filterPointer add(long count) {
		return group_filterPointer.cast(address + (group_filter.SIZEOF * count));
	}

	public group_filterPointer add(Scalar count) {
		return add(count.longValue());
	}

	public group_filterPointer addOffset(long offset) {
		return group_filterPointer.cast(address + offset);
	}

	public group_filterPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public group_filterPointer sub(long count) {
		return group_filterPointer.cast(address - (group_filter.SIZEOF * count));
	}

	public group_filterPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public group_filterPointer subOffset(long offset) {
		return group_filterPointer.cast(address - offset);
	}

	public group_filterPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public group_filterPointer untag(long mask) {
		return group_filterPointer.cast(address & ~mask);
	}

	public group_filterPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return group_filter.SIZEOF;
	}

	// Implementation methods

	// MULTICAST_MODE_TYPE gf_fmode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gf_fmodeOffset_", declaredType="MULTICAST_MODE_TYPE")
	public long gf_fmode() throws CorruptDataException {
		if (MULTICAST_MODE_TYPE.SIZEOF == 1) {
			return getByteAtOffset(group_filter._gf_fmodeOffset_);
		} else if (MULTICAST_MODE_TYPE.SIZEOF == 2) {
			return getShortAtOffset(group_filter._gf_fmodeOffset_);
		} else if (MULTICAST_MODE_TYPE.SIZEOF == 4) {
			return getIntAtOffset(group_filter._gf_fmodeOffset_);
		} else if (MULTICAST_MODE_TYPE.SIZEOF == 8) {
			return getLongAtOffset(group_filter._gf_fmodeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MULTICAST_MODE_TYPE gf_fmode
	public EnumPointer gf_fmodeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(group_filter._gf_fmodeOffset_), MULTICAST_MODE_TYPE.class);
	}

	// sockaddr_storage gf_group
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gf_groupOffset_", declaredType="sockaddr_storage")
	public sockaddr_storagePointer gf_group() throws CorruptDataException {
		return sockaddr_storagePointer.cast(nonNullFieldEA(group_filter._gf_groupOffset_));
	}

	// sockaddr_storage gf_group
	public PointerPointer gf_groupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(group_filter._gf_groupOffset_));
	}

	// U32 gf_interface
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gf_interfaceOffset_", declaredType="U32")
	public UDATA gf_interface() throws CorruptDataException {
		return new U32(getIntAtOffset(group_filter._gf_interfaceOffset_));
	}

	// U32 gf_interface
	public UDATAPointer gf_interfaceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(group_filter._gf_interfaceOffset_));
	}

	// U32 gf_numsrc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gf_numsrcOffset_", declaredType="U32")
	public UDATA gf_numsrc() throws CorruptDataException {
		return new U32(getIntAtOffset(group_filter._gf_numsrcOffset_));
	}

	// U32 gf_numsrc
	public UDATAPointer gf_numsrcEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(group_filter._gf_numsrcOffset_));
	}

	// sockaddr_storage[] gf_slist
	public sockaddr_storagePointer gf_slistEA() throws CorruptDataException {
		return sockaddr_storagePointer.cast(nonNullFieldEA(group_filter._gf_slistOffset_));
	}

}
