/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagDECPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagDECPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagDEC.class)
public class tagDECPointer extends StructurePointer {

	// NULL
	public static final tagDECPointer NULL = new tagDECPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagDECPointer(long address) {
		super(address);
	}

	public static tagDECPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagDECPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagDECPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagDECPointer(address);
	}

	public tagDECPointer add(long count) {
		return tagDECPointer.cast(address + (tagDEC.SIZEOF * count));
	}

	public tagDECPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagDECPointer addOffset(long offset) {
		return tagDECPointer.cast(address + offset);
	}

	public tagDECPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagDECPointer sub(long count) {
		return tagDECPointer.cast(address - (tagDEC.SIZEOF * count));
	}

	public tagDECPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagDECPointer subOffset(long offset) {
		return tagDECPointer.cast(address - offset);
	}

	public tagDECPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagDECPointer untag(long mask) {
		return tagDECPointer.cast(address & ~mask);
	}

	public tagDECPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagDEC.SIZEOF;
	}

	// Implementation methods

	// U32 Hi32
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Hi32Offset_", declaredType="U32")
	public UDATA Hi32() throws CorruptDataException {
		return new U32(getIntAtOffset(tagDEC._Hi32Offset_));
	}

	// U32 Hi32
	public UDATAPointer Hi32EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagDEC._Hi32Offset_));
	}

	// U32 Lo32
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Lo32Offset_", declaredType="U32")
	public UDATA Lo32() throws CorruptDataException {
		return new U32(getIntAtOffset(tagDEC._Lo32Offset_));
	}

	// U32 Lo32
	public UDATAPointer Lo32EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagDEC._Lo32Offset_));
	}

	// U64 Lo64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Lo64Offset_", declaredType="U64")
	public UDATA Lo64() throws CorruptDataException {
		return new U64(getLongAtOffset(tagDEC._Lo64Offset_));
	}

	// U64 Lo64
	public UDATAPointer Lo64EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagDEC._Lo64Offset_));
	}

	// U32 Mid32
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Mid32Offset_", declaredType="U32")
	public UDATA Mid32() throws CorruptDataException {
		return new U32(getIntAtOffset(tagDEC._Mid32Offset_));
	}

	// U32 Mid32
	public UDATAPointer Mid32EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagDEC._Mid32Offset_));
	}

	// U8 scale
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scaleOffset_", declaredType="U8")
	public U8 scale() throws CorruptDataException {
		return new U8(getByteAtOffset(tagDEC._scaleOffset_));
	}

	// U8 scale
	public U8Pointer scaleEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tagDEC._scaleOffset_));
	}

	// U8 sign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_signOffset_", declaredType="U8")
	public U8 sign() throws CorruptDataException {
		return new U8(getByteAtOffset(tagDEC._signOffset_));
	}

	// U8 sign
	public U8Pointer signEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tagDEC._signOffset_));
	}

	// U16 signscale
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_signscaleOffset_", declaredType="U16")
	public U16 signscale() throws CorruptDataException {
		return new U16(getShortAtOffset(tagDEC._signscaleOffset_));
	}

	// U16 signscale
	public U16Pointer signscaleEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagDEC._signscaleOffset_));
	}

	// U16 wReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReservedOffset_", declaredType="U16")
	public U16 wReserved() throws CorruptDataException {
		return new U16(getShortAtOffset(tagDEC._wReservedOffset_));
	}

	// U16 wReserved
	public U16Pointer wReservedEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagDEC._wReservedOffset_));
	}

}
