/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagSTATSTGPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagSTATSTGPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagSTATSTG.class)
public class tagSTATSTGPointer extends StructurePointer {

	// NULL
	public static final tagSTATSTGPointer NULL = new tagSTATSTGPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagSTATSTGPointer(long address) {
		super(address);
	}

	public static tagSTATSTGPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagSTATSTGPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagSTATSTGPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagSTATSTGPointer(address);
	}

	public tagSTATSTGPointer add(long count) {
		return tagSTATSTGPointer.cast(address + (tagSTATSTG.SIZEOF * count));
	}

	public tagSTATSTGPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagSTATSTGPointer addOffset(long offset) {
		return tagSTATSTGPointer.cast(address + offset);
	}

	public tagSTATSTGPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagSTATSTGPointer sub(long count) {
		return tagSTATSTGPointer.cast(address - (tagSTATSTG.SIZEOF * count));
	}

	public tagSTATSTGPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagSTATSTGPointer subOffset(long offset) {
		return tagSTATSTGPointer.cast(address - offset);
	}

	public tagSTATSTGPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagSTATSTGPointer untag(long mask) {
		return tagSTATSTGPointer.cast(address & ~mask);
	}

	public tagSTATSTGPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagSTATSTG.SIZEOF;
	}

	// Implementation methods

	// _FILETIME atime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_atimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer atime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(tagSTATSTG._atimeOffset_));
	}

	// _FILETIME atime
	public PointerPointer atimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagSTATSTG._atimeOffset_));
	}

	// _ULARGE_INTEGER cbSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbSizeOffset_", declaredType="_ULARGE_INTEGER")
	public _ULARGE_INTEGERPointer cbSize() throws CorruptDataException {
		return _ULARGE_INTEGERPointer.cast(nonNullFieldEA(tagSTATSTG._cbSizeOffset_));
	}

	// _ULARGE_INTEGER cbSize
	public PointerPointer cbSizeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagSTATSTG._cbSizeOffset_));
	}

	// _GUID clsid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_clsidOffset_", declaredType="_GUID")
	public _GUIDPointer clsid() throws CorruptDataException {
		return _GUIDPointer.cast(nonNullFieldEA(tagSTATSTG._clsidOffset_));
	}

	// _GUID clsid
	public PointerPointer clsidEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagSTATSTG._clsidOffset_));
	}

	// _FILETIME ctime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer ctime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(tagSTATSTG._ctimeOffset_));
	}

	// _FILETIME ctime
	public PointerPointer ctimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagSTATSTG._ctimeOffset_));
	}

	// U32 grfLocksSupported
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_grfLocksSupportedOffset_", declaredType="U32")
	public UDATA grfLocksSupported() throws CorruptDataException {
		return new U32(getIntAtOffset(tagSTATSTG._grfLocksSupportedOffset_));
	}

	// U32 grfLocksSupported
	public UDATAPointer grfLocksSupportedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagSTATSTG._grfLocksSupportedOffset_));
	}

	// U32 grfMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_grfModeOffset_", declaredType="U32")
	public UDATA grfMode() throws CorruptDataException {
		return new U32(getIntAtOffset(tagSTATSTG._grfModeOffset_));
	}

	// U32 grfMode
	public UDATAPointer grfModeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagSTATSTG._grfModeOffset_));
	}

	// U32 grfStateBits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_grfStateBitsOffset_", declaredType="U32")
	public UDATA grfStateBits() throws CorruptDataException {
		return new U32(getIntAtOffset(tagSTATSTG._grfStateBitsOffset_));
	}

	// U32 grfStateBits
	public UDATAPointer grfStateBitsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagSTATSTG._grfStateBitsOffset_));
	}

	// _FILETIME mtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mtimeOffset_", declaredType="_FILETIME")
	public _FILETIMEPointer mtime() throws CorruptDataException {
		return _FILETIMEPointer.cast(nonNullFieldEA(tagSTATSTG._mtimeOffset_));
	}

	// _FILETIME mtime
	public PointerPointer mtimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagSTATSTG._mtimeOffset_));
	}

	// U16* pwcsName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwcsNameOffset_", declaredType="U16*")
	public U16Pointer pwcsName() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagSTATSTG._pwcsNameOffset_));
	}

	// U16* pwcsName
	public PointerPointer pwcsNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagSTATSTG._pwcsNameOffset_));
	}

	// U32 reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedOffset_", declaredType="U32")
	public UDATA reserved() throws CorruptDataException {
		return new U32(getIntAtOffset(tagSTATSTG._reservedOffset_));
	}

	// U32 reserved
	public UDATAPointer reservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagSTATSTG._reservedOffset_));
	}

	// U32 type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="U32")
	public UDATA type() throws CorruptDataException {
		return new U32(getIntAtOffset(tagSTATSTG._typeOffset_));
	}

	// U32 type
	public UDATAPointer typeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagSTATSTG._typeOffset_));
	}

}
