/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: win64_call_framePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the win64_call_framePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=win64_call_frame.class)
public class win64_call_framePointer extends StructurePointer {

	// NULL
	public static final win64_call_framePointer NULL = new win64_call_framePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected win64_call_framePointer(long address) {
		super(address);
	}

	public static win64_call_framePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static win64_call_framePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static win64_call_framePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new win64_call_framePointer(address);
	}

	public win64_call_framePointer add(long count) {
		return win64_call_framePointer.cast(address + (win64_call_frame.SIZEOF * count));
	}

	public win64_call_framePointer add(Scalar count) {
		return add(count.longValue());
	}

	public win64_call_framePointer addOffset(long offset) {
		return win64_call_framePointer.cast(address + offset);
	}

	public win64_call_framePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public win64_call_framePointer sub(long count) {
		return win64_call_framePointer.cast(address - (win64_call_frame.SIZEOF * count));
	}

	public win64_call_framePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public win64_call_framePointer subOffset(long offset) {
		return win64_call_framePointer.cast(address - offset);
	}

	public win64_call_framePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public win64_call_framePointer untag(long mask) {
		return win64_call_framePointer.cast(address & ~mask);
	}

	public win64_call_framePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return win64_call_frame.SIZEOF;
	}

	// Implementation methods

	// U64 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U64")
	public UDATA flags() throws CorruptDataException {
		return new U64(getLongAtOffset(win64_call_frame._flagsOffset_));
	}

	// U64 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(win64_call_frame._flagsOffset_));
	}

	// U64 fn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fnOffset_", declaredType="U64")
	public UDATA fn() throws CorruptDataException {
		return new U64(getLongAtOffset(win64_call_frame._fnOffset_));
	}

	// U64 fn
	public UDATAPointer fnEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(win64_call_frame._fnOffset_));
	}

	// U64 rbp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rbpOffset_", declaredType="U64")
	public UDATA rbp() throws CorruptDataException {
		return new U64(getLongAtOffset(win64_call_frame._rbpOffset_));
	}

	// U64 rbp
	public UDATAPointer rbpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(win64_call_frame._rbpOffset_));
	}

	// U64 retaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_retaddrOffset_", declaredType="U64")
	public UDATA retaddr() throws CorruptDataException {
		return new U64(getLongAtOffset(win64_call_frame._retaddrOffset_));
	}

	// U64 retaddr
	public UDATAPointer retaddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(win64_call_frame._retaddrOffset_));
	}

	// U64 rvalue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rvalueOffset_", declaredType="U64")
	public UDATA rvalue() throws CorruptDataException {
		return new U64(getLongAtOffset(win64_call_frame._rvalueOffset_));
	}

	// U64 rvalue
	public UDATAPointer rvalueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(win64_call_frame._rvalueOffset_));
	}

}
