/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9NPEMessageData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9NPEMessageData {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _bytecodeMapOffset_;
	public static final int _bytecodeMapSizeOffset_;
	public static final int _bytecodeOffsetOffset_;
	public static final int _bytecodeOffsetSizeOffset_;
	public static final int _liveStackOffset_;
	public static final int _liveStackSizeOffset_;
	public static final int _npePCOffset_;
	public static final int _romClassOffset_;
	public static final int _romMethodOffset_;
	public static final int _stackMapsOffset_;
	public static final int _stackMapsCountOffset_;
	public static final int _stackMapsSizeOffset_;
	public static final int _stackSizeOffset_;
	public static final int _unwalkedQueueOffset_;
	public static final int _unwalkedQueueHeadOffset_;
	public static final int _unwalkedQueueSizeOffset_;
	public static final int _unwalkedQueueTailOffset_;
	public static final int _vmThreadOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_bytecodeMapOffset_ = 0;
		_bytecodeMapSizeOffset_ = 0;
		_bytecodeOffsetOffset_ = 0;
		_bytecodeOffsetSizeOffset_ = 0;
		_liveStackOffset_ = 0;
		_liveStackSizeOffset_ = 0;
		_npePCOffset_ = 0;
		_romClassOffset_ = 0;
		_romMethodOffset_ = 0;
		_stackMapsOffset_ = 0;
		_stackMapsCountOffset_ = 0;
		_stackMapsSizeOffset_ = 0;
		_stackSizeOffset_ = 0;
		_unwalkedQueueOffset_ = 0;
		_unwalkedQueueHeadOffset_ = 0;
		_unwalkedQueueSizeOffset_ = 0;
		_unwalkedQueueTailOffset_ = 0;
		_vmThreadOffset_ = 0;
	}

}
