/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: KNOWNFOLDER_DEFINITION
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class KNOWNFOLDER_DEFINITION {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _categoryOffset_;
	public static final int _dwAttributesOffset_;
	public static final int _fidParentOffset_;
	public static final int _ftidTypeOffset_;
	public static final int _kfdFlagsOffset_;
	public static final int _pszDescriptionOffset_;
	public static final int _pszIconOffset_;
	public static final int _pszLocalizedNameOffset_;
	public static final int _pszNameOffset_;
	public static final int _pszParsingNameOffset_;
	public static final int _pszRelativePathOffset_;
	public static final int _pszSecurityOffset_;
	public static final int _pszTooltipOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_categoryOffset_ = 0;
		_dwAttributesOffset_ = 0;
		_fidParentOffset_ = 0;
		_ftidTypeOffset_ = 0;
		_kfdFlagsOffset_ = 0;
		_pszDescriptionOffset_ = 0;
		_pszIconOffset_ = 0;
		_pszLocalizedNameOffset_ = 0;
		_pszNameOffset_ = 0;
		_pszParsingNameOffset_ = 0;
		_pszRelativePathOffset_ = 0;
		_pszSecurityOffset_ = 0;
		_pszTooltipOffset_ = 0;
	}

}
