/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _IMAGE_OPTIONAL_HEADER64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _IMAGE_OPTIONAL_HEADER64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _AddressOfEntryPointOffset_;
	public static final int _BaseOfCodeOffset_;
	public static final int _CheckSumOffset_;
	public static final int _DataDirectoryOffset_;
	public static final int _DllCharacteristicsOffset_;
	public static final int _FileAlignmentOffset_;
	public static final int _ImageBaseOffset_;
	public static final int _LoaderFlagsOffset_;
	public static final int _MagicOffset_;
	public static final int _MajorImageVersionOffset_;
	public static final int _MajorLinkerVersionOffset_;
	public static final int _MajorOperatingSystemVersionOffset_;
	public static final int _MajorSubsystemVersionOffset_;
	public static final int _MinorImageVersionOffset_;
	public static final int _MinorLinkerVersionOffset_;
	public static final int _MinorOperatingSystemVersionOffset_;
	public static final int _MinorSubsystemVersionOffset_;
	public static final int _NumberOfRvaAndSizesOffset_;
	public static final int _SectionAlignmentOffset_;
	public static final int _SizeOfCodeOffset_;
	public static final int _SizeOfHeadersOffset_;
	public static final int _SizeOfHeapCommitOffset_;
	public static final int _SizeOfHeapReserveOffset_;
	public static final int _SizeOfImageOffset_;
	public static final int _SizeOfInitializedDataOffset_;
	public static final int _SizeOfStackCommitOffset_;
	public static final int _SizeOfStackReserveOffset_;
	public static final int _SizeOfUninitializedDataOffset_;
	public static final int _SubsystemOffset_;
	public static final int _Win32VersionValueOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_AddressOfEntryPointOffset_ = 0;
		_BaseOfCodeOffset_ = 0;
		_CheckSumOffset_ = 0;
		_DataDirectoryOffset_ = 0;
		_DllCharacteristicsOffset_ = 0;
		_FileAlignmentOffset_ = 0;
		_ImageBaseOffset_ = 0;
		_LoaderFlagsOffset_ = 0;
		_MagicOffset_ = 0;
		_MajorImageVersionOffset_ = 0;
		_MajorLinkerVersionOffset_ = 0;
		_MajorOperatingSystemVersionOffset_ = 0;
		_MajorSubsystemVersionOffset_ = 0;
		_MinorImageVersionOffset_ = 0;
		_MinorLinkerVersionOffset_ = 0;
		_MinorOperatingSystemVersionOffset_ = 0;
		_MinorSubsystemVersionOffset_ = 0;
		_NumberOfRvaAndSizesOffset_ = 0;
		_SectionAlignmentOffset_ = 0;
		_SizeOfCodeOffset_ = 0;
		_SizeOfHeadersOffset_ = 0;
		_SizeOfHeapCommitOffset_ = 0;
		_SizeOfHeapReserveOffset_ = 0;
		_SizeOfImageOffset_ = 0;
		_SizeOfInitializedDataOffset_ = 0;
		_SizeOfStackCommitOffset_ = 0;
		_SizeOfStackReserveOffset_ = 0;
		_SizeOfUninitializedDataOffset_ = 0;
		_SubsystemOffset_ = 0;
		_Win32VersionValueOffset_ = 0;
	}

}
