/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _TP_CALLBACK_ENVIRON_V3
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _TP_CALLBACK_ENVIRON_V3 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _ActivationContextOffset_;
	public static final int _CallbackPriorityOffset_;
	public static final int _CleanupGroupOffset_;
	public static final int _CleanupGroupCancelCallbackOffset_;
	public static final int _FinalizationCallbackOffset_;
	public static final int _PoolOffset_;
	public static final int _RaceDllOffset_;
	public static final int _SizeOffset_;
	public static final int _VersionOffset_;
	public static final int _u$FlagsOffset_;
	public static final int _u$s$LongFunction_s_;
	public static final int _u$s$LongFunction_b_;
	public static final int _u$s$Persistent_s_;
	public static final int _u$s$Persistent_b_;
	public static final int _u$s$Private_s_;
	public static final int _u$s$Private_b_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_ActivationContextOffset_ = 0;
		_CallbackPriorityOffset_ = 0;
		_CleanupGroupOffset_ = 0;
		_CleanupGroupCancelCallbackOffset_ = 0;
		_FinalizationCallbackOffset_ = 0;
		_PoolOffset_ = 0;
		_RaceDllOffset_ = 0;
		_SizeOffset_ = 0;
		_VersionOffset_ = 0;
		_u$FlagsOffset_ = 0;
		_u$s$LongFunction_s_ = 0;
		_u$s$LongFunction_b_ = 0;
		_u$s$Persistent_s_ = 0;
		_u$s$Persistent_b_ = 0;
		_u$s$Private_s_ = 0;
		_u$s$Private_b_ = 0;
	}

}
