/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _XSAVE_FORMAT
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _XSAVE_FORMAT {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _ControlWordOffset_;
	public static final int _DataOffsetOffset_;
	public static final int _DataSelectorOffset_;
	public static final int _ErrorOffsetOffset_;
	public static final int _ErrorOpcodeOffset_;
	public static final int _ErrorSelectorOffset_;
	public static final int _FloatRegistersOffset_;
	public static final int _MxCsrOffset_;
	public static final int _MxCsr_MaskOffset_;
	public static final int _Reserved1Offset_;
	public static final int _Reserved2Offset_;
	public static final int _Reserved3Offset_;
	public static final int _Reserved4Offset_;
	public static final int _StatusWordOffset_;
	public static final int _TagWordOffset_;
	public static final int _XmmRegistersOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_ControlWordOffset_ = 0;
		_DataOffsetOffset_ = 0;
		_DataSelectorOffset_ = 0;
		_ErrorOffsetOffset_ = 0;
		_ErrorOpcodeOffset_ = 0;
		_ErrorSelectorOffset_ = 0;
		_FloatRegistersOffset_ = 0;
		_MxCsrOffset_ = 0;
		_MxCsr_MaskOffset_ = 0;
		_Reserved1Offset_ = 0;
		_Reserved2Offset_ = 0;
		_Reserved3Offset_ = 0;
		_Reserved4Offset_ = 0;
		_StatusWordOffset_ = 0;
		_TagWordOffset_ = 0;
		_XmmRegistersOffset_ = 0;
	}

}
