/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: jvmtiEvent
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class jvmtiEvent {

	// VM Constants

	public static final long SIZEOF;
	public static final long JVMTI_EVENT_BREAKPOINT;
	public static final long JVMTI_EVENT_CLASS_FILE_LOAD_HOOK;
	public static final long JVMTI_EVENT_CLASS_LOAD;
	public static final long JVMTI_EVENT_CLASS_PREPARE;
	public static final long JVMTI_EVENT_COMPILED_METHOD_LOAD;
	public static final long JVMTI_EVENT_COMPILED_METHOD_UNLOAD;
	public static final long JVMTI_EVENT_DATA_DUMP_REQUEST;
	public static final long JVMTI_EVENT_DYNAMIC_CODE_GENERATED;
	public static final long JVMTI_EVENT_EXCEPTION;
	public static final long JVMTI_EVENT_EXCEPTION_CATCH;
	public static final long JVMTI_EVENT_FIELD_ACCESS;
	public static final long JVMTI_EVENT_FIELD_MODIFICATION;
	public static final long JVMTI_EVENT_FRAME_POP;
	public static final long JVMTI_EVENT_GARBAGE_COLLECTION_FINISH;
	public static final long JVMTI_EVENT_GARBAGE_COLLECTION_START;
	public static final long JVMTI_EVENT_METHOD_ENTRY;
	public static final long JVMTI_EVENT_METHOD_EXIT;
	public static final long JVMTI_EVENT_MONITOR_CONTENDED_ENTER;
	public static final long JVMTI_EVENT_MONITOR_CONTENDED_ENTERED;
	public static final long JVMTI_EVENT_MONITOR_WAIT;
	public static final long JVMTI_EVENT_MONITOR_WAITED;
	public static final long JVMTI_EVENT_NATIVE_METHOD_BIND;
	public static final long JVMTI_EVENT_OBJECT_FREE;
	public static final long JVMTI_EVENT_RESOURCE_EXHAUSTED;
	public static final long JVMTI_EVENT_SINGLE_STEP;
	public static final long JVMTI_EVENT_THREAD_END;
	public static final long JVMTI_EVENT_THREAD_START;
	public static final long JVMTI_EVENT_VM_DEATH;
	public static final long JVMTI_EVENT_VM_INIT;
	public static final long JVMTI_EVENT_VM_OBJECT_ALLOC;
	public static final long JVMTI_EVENT_VM_START;
	public static final long JVMTI_MAX_EVENT_TYPE_VAL;
	public static final long JVMTI_MIN_EVENT_TYPE_VAL;
	public static final long jvmtiEventEnsureWideEnum;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		JVMTI_EVENT_BREAKPOINT = 0;
		JVMTI_EVENT_CLASS_FILE_LOAD_HOOK = 0;
		JVMTI_EVENT_CLASS_LOAD = 0;
		JVMTI_EVENT_CLASS_PREPARE = 0;
		JVMTI_EVENT_COMPILED_METHOD_LOAD = 0;
		JVMTI_EVENT_COMPILED_METHOD_UNLOAD = 0;
		JVMTI_EVENT_DATA_DUMP_REQUEST = 0;
		JVMTI_EVENT_DYNAMIC_CODE_GENERATED = 0;
		JVMTI_EVENT_EXCEPTION = 0;
		JVMTI_EVENT_EXCEPTION_CATCH = 0;
		JVMTI_EVENT_FIELD_ACCESS = 0;
		JVMTI_EVENT_FIELD_MODIFICATION = 0;
		JVMTI_EVENT_FRAME_POP = 0;
		JVMTI_EVENT_GARBAGE_COLLECTION_FINISH = 0;
		JVMTI_EVENT_GARBAGE_COLLECTION_START = 0;
		JVMTI_EVENT_METHOD_ENTRY = 0;
		JVMTI_EVENT_METHOD_EXIT = 0;
		JVMTI_EVENT_MONITOR_CONTENDED_ENTER = 0;
		JVMTI_EVENT_MONITOR_CONTENDED_ENTERED = 0;
		JVMTI_EVENT_MONITOR_WAIT = 0;
		JVMTI_EVENT_MONITOR_WAITED = 0;
		JVMTI_EVENT_NATIVE_METHOD_BIND = 0;
		JVMTI_EVENT_OBJECT_FREE = 0;
		JVMTI_EVENT_RESOURCE_EXHAUSTED = 0;
		JVMTI_EVENT_SINGLE_STEP = 0;
		JVMTI_EVENT_THREAD_END = 0;
		JVMTI_EVENT_THREAD_START = 0;
		JVMTI_EVENT_VM_DEATH = 0;
		JVMTI_EVENT_VM_INIT = 0;
		JVMTI_EVENT_VM_OBJECT_ALLOC = 0;
		JVMTI_EVENT_VM_START = 0;
		JVMTI_MAX_EVENT_TYPE_VAL = 0;
		JVMTI_MIN_EVENT_TYPE_VAL = 0;
		jvmtiEventEnsureWideEnum = 0;
	}

}
