/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GarbageCollectionEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GarbageCollectionEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GarbageCollectionEntry.class)
public class GarbageCollectionEntryPointer extends StructurePointer {

	// NULL
	public static final GarbageCollectionEntryPointer NULL = new GarbageCollectionEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GarbageCollectionEntryPointer(long address) {
		super(address);
	}

	public static GarbageCollectionEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GarbageCollectionEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GarbageCollectionEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GarbageCollectionEntryPointer(address);
	}

	public GarbageCollectionEntryPointer add(long count) {
		return GarbageCollectionEntryPointer.cast(address + (GarbageCollectionEntry.SIZEOF * count));
	}

	public GarbageCollectionEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GarbageCollectionEntryPointer addOffset(long offset) {
		return GarbageCollectionEntryPointer.cast(address + offset);
	}

	public GarbageCollectionEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GarbageCollectionEntryPointer sub(long count) {
		return GarbageCollectionEntryPointer.cast(address - (GarbageCollectionEntry.SIZEOF * count));
	}

	public GarbageCollectionEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GarbageCollectionEntryPointer subOffset(long offset) {
		return GarbageCollectionEntryPointer.cast(address - offset);
	}

	public GarbageCollectionEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GarbageCollectionEntryPointer untag(long mask) {
		return GarbageCollectionEntryPointer.cast(address & ~mask);
	}

	public GarbageCollectionEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GarbageCollectionEntry.SIZEOF;
	}

	// Implementation methods

	// I64 duration
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_durationOffset_", declaredType="I64")
	public IDATA duration() throws CorruptDataException {
		return new I64(getLongAtOffset(GarbageCollectionEntry._durationOffset_));
	}

	// I64 duration
	public IDATAPointer durationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._durationOffset_));
	}

	// U32 gcCauseID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcCauseIDOffset_", declaredType="U32")
	public UDATA gcCauseID() throws CorruptDataException {
		return new U32(getIntAtOffset(GarbageCollectionEntry._gcCauseIDOffset_));
	}

	// U32 gcCauseID
	public UDATAPointer gcCauseIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._gcCauseIDOffset_));
	}

	// U64 gcID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcIDOffset_", declaredType="U64")
	public UDATA gcID() throws CorruptDataException {
		return new U64(getLongAtOffset(GarbageCollectionEntry._gcIDOffset_));
	}

	// U64 gcID
	public UDATAPointer gcIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._gcIDOffset_));
	}

	// U32 gcNameID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcNameIDOffset_", declaredType="U32")
	public UDATA gcNameID() throws CorruptDataException {
		return new U32(getIntAtOffset(GarbageCollectionEntry._gcNameIDOffset_));
	}

	// U32 gcNameID
	public UDATAPointer gcNameIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._gcNameIDOffset_));
	}

	// I64 longestPause
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_longestPauseOffset_", declaredType="I64")
	public IDATA longestPause() throws CorruptDataException {
		return new I64(getLongAtOffset(GarbageCollectionEntry._longestPauseOffset_));
	}

	// I64 longestPause
	public IDATAPointer longestPauseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._longestPauseOffset_));
	}

	// I64 sumOfPauses
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sumOfPausesOffset_", declaredType="I64")
	public IDATA sumOfPauses() throws CorruptDataException {
		return new I64(getLongAtOffset(GarbageCollectionEntry._sumOfPausesOffset_));
	}

	// I64 sumOfPauses
	public IDATAPointer sumOfPausesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._sumOfPausesOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(GarbageCollectionEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GarbageCollectionEntry._ticksOffset_));
	}

}
