/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9JFRGCHeapSummaryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9JFRGCHeapSummaryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9JFRGCHeapSummary.class)
public class J9JFRGCHeapSummaryPointer extends StructurePointer {

	// NULL
	public static final J9JFRGCHeapSummaryPointer NULL = new J9JFRGCHeapSummaryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9JFRGCHeapSummaryPointer(long address) {
		super(address);
	}

	public static J9JFRGCHeapSummaryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9JFRGCHeapSummaryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9JFRGCHeapSummaryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9JFRGCHeapSummaryPointer(address);
	}

	public J9JFRGCHeapSummaryPointer add(long count) {
		return J9JFRGCHeapSummaryPointer.cast(address + (J9JFRGCHeapSummary.SIZEOF * count));
	}

	public J9JFRGCHeapSummaryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9JFRGCHeapSummaryPointer addOffset(long offset) {
		return J9JFRGCHeapSummaryPointer.cast(address + offset);
	}

	public J9JFRGCHeapSummaryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9JFRGCHeapSummaryPointer sub(long count) {
		return J9JFRGCHeapSummaryPointer.cast(address - (J9JFRGCHeapSummary.SIZEOF * count));
	}

	public J9JFRGCHeapSummaryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9JFRGCHeapSummaryPointer subOffset(long offset) {
		return J9JFRGCHeapSummaryPointer.cast(address - offset);
	}

	public J9JFRGCHeapSummaryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9JFRGCHeapSummaryPointer untag(long mask) {
		return J9JFRGCHeapSummaryPointer.cast(address & ~mask);
	}

	public J9JFRGCHeapSummaryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9JFRGCHeapSummary.SIZEOF;
	}

	// Implementation methods

	// I64 duration
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_durationOffset_", declaredType="I64")
	public IDATA duration() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGCHeapSummary._durationOffset_));
	}

	// I64 duration
	public IDATAPointer durationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._durationOffset_));
	}

	// U64 eventType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eventTypeOffset_", declaredType="U64")
	public UDATA eventType() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._eventTypeOffset_));
	}

	// U64 eventType
	public UDATAPointer eventTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._eventTypeOffset_));
	}

	// U64 gcID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcIDOffset_", declaredType="U64")
	public UDATA gcID() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._gcIDOffset_));
	}

	// U64 gcID
	public UDATAPointer gcIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._gcIDOffset_));
	}

	// U32 gcWhenID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcWhenIDOffset_", declaredType="U32")
	public UDATA gcWhenID() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JFRGCHeapSummary._gcWhenIDOffset_));
	}

	// U32 gcWhenID
	public UDATAPointer gcWhenIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._gcWhenIDOffset_));
	}

	// I64 heapUsed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapUsedOffset_", declaredType="I64")
	public IDATA heapUsed() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGCHeapSummary._heapUsedOffset_));
	}

	// I64 heapUsed
	public IDATAPointer heapUsedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._heapUsedOffset_));
	}

	// I64 startTicks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_startTicksOffset_", declaredType="I64")
	public IDATA startTicks() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGCHeapSummary._startTicksOffset_));
	}

	// I64 startTicks
	public IDATAPointer startTicksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._startTicksOffset_));
	}

	// U64 vCommittedEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vCommittedEndOffset_", declaredType="U64")
	public UDATA vCommittedEnd() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._vCommittedEndOffset_));
	}

	// U64 vCommittedEnd
	public UDATAPointer vCommittedEndEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._vCommittedEndOffset_));
	}

	// U64 vCommittedSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vCommittedSizeOffset_", declaredType="U64")
	public UDATA vCommittedSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._vCommittedSizeOffset_));
	}

	// U64 vCommittedSize
	public UDATAPointer vCommittedSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._vCommittedSizeOffset_));
	}

	// U64 vReservedEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vReservedEndOffset_", declaredType="U64")
	public UDATA vReservedEnd() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._vReservedEndOffset_));
	}

	// U64 vReservedEnd
	public UDATAPointer vReservedEndEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._vReservedEndOffset_));
	}

	// U64 vReservedSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vReservedSizeOffset_", declaredType="U64")
	public UDATA vReservedSize() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._vReservedSizeOffset_));
	}

	// U64 vReservedSize
	public UDATAPointer vReservedSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._vReservedSizeOffset_));
	}

	// U64 vStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vStartOffset_", declaredType="U64")
	public UDATA vStart() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGCHeapSummary._vStartOffset_));
	}

	// U64 vStart
	public UDATAPointer vStartEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._vStartOffset_));
	}

	// J9VMThread* vmThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer vmThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(J9JFRGCHeapSummary._vmThreadOffset_));
	}

	// J9VMThread* vmThread
	public PointerPointer vmThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9JFRGCHeapSummary._vmThreadOffset_));
	}

}
