/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9JFRGarbageCollectionPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9JFRGarbageCollectionPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9JFRGarbageCollection.class)
public class J9JFRGarbageCollectionPointer extends StructurePointer {

	// NULL
	public static final J9JFRGarbageCollectionPointer NULL = new J9JFRGarbageCollectionPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9JFRGarbageCollectionPointer(long address) {
		super(address);
	}

	public static J9JFRGarbageCollectionPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9JFRGarbageCollectionPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9JFRGarbageCollectionPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9JFRGarbageCollectionPointer(address);
	}

	public J9JFRGarbageCollectionPointer add(long count) {
		return J9JFRGarbageCollectionPointer.cast(address + (J9JFRGarbageCollection.SIZEOF * count));
	}

	public J9JFRGarbageCollectionPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9JFRGarbageCollectionPointer addOffset(long offset) {
		return J9JFRGarbageCollectionPointer.cast(address + offset);
	}

	public J9JFRGarbageCollectionPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9JFRGarbageCollectionPointer sub(long count) {
		return J9JFRGarbageCollectionPointer.cast(address - (J9JFRGarbageCollection.SIZEOF * count));
	}

	public J9JFRGarbageCollectionPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9JFRGarbageCollectionPointer subOffset(long offset) {
		return J9JFRGarbageCollectionPointer.cast(address - offset);
	}

	public J9JFRGarbageCollectionPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9JFRGarbageCollectionPointer untag(long mask) {
		return J9JFRGarbageCollectionPointer.cast(address & ~mask);
	}

	public J9JFRGarbageCollectionPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9JFRGarbageCollection.SIZEOF;
	}

	// Implementation methods

	// I64 duration
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_durationOffset_", declaredType="I64")
	public IDATA duration() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGarbageCollection._durationOffset_));
	}

	// I64 duration
	public IDATAPointer durationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._durationOffset_));
	}

	// U64 eventType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eventTypeOffset_", declaredType="U64")
	public UDATA eventType() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGarbageCollection._eventTypeOffset_));
	}

	// U64 eventType
	public UDATAPointer eventTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._eventTypeOffset_));
	}

	// U32 gcCauseID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcCauseIDOffset_", declaredType="U32")
	public UDATA gcCauseID() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JFRGarbageCollection._gcCauseIDOffset_));
	}

	// U32 gcCauseID
	public UDATAPointer gcCauseIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._gcCauseIDOffset_));
	}

	// U64 gcID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcIDOffset_", declaredType="U64")
	public UDATA gcID() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JFRGarbageCollection._gcIDOffset_));
	}

	// U64 gcID
	public UDATAPointer gcIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._gcIDOffset_));
	}

	// U32 gcNameID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcNameIDOffset_", declaredType="U32")
	public UDATA gcNameID() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JFRGarbageCollection._gcNameIDOffset_));
	}

	// U32 gcNameID
	public UDATAPointer gcNameIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._gcNameIDOffset_));
	}

	// I64 longestPause
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_longestPauseOffset_", declaredType="I64")
	public IDATA longestPause() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGarbageCollection._longestPauseOffset_));
	}

	// I64 longestPause
	public IDATAPointer longestPauseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._longestPauseOffset_));
	}

	// I64 startTicks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_startTicksOffset_", declaredType="I64")
	public IDATA startTicks() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGarbageCollection._startTicksOffset_));
	}

	// I64 startTicks
	public IDATAPointer startTicksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._startTicksOffset_));
	}

	// I64 sumOfPauses
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sumOfPausesOffset_", declaredType="I64")
	public IDATA sumOfPauses() throws CorruptDataException {
		return new I64(getLongAtOffset(J9JFRGarbageCollection._sumOfPausesOffset_));
	}

	// I64 sumOfPauses
	public IDATAPointer sumOfPausesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._sumOfPausesOffset_));
	}

	// J9VMThread* vmThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer vmThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(J9JFRGarbageCollection._vmThreadOffset_));
	}

	// J9VMThread* vmThread
	public PointerPointer vmThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9JFRGarbageCollection._vmThreadOffset_));
	}

}
