/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: PackageEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the PackageEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=PackageEntry.class)
public class PackageEntryPointer extends StructurePointer {

	// NULL
	public static final PackageEntryPointer NULL = new PackageEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected PackageEntryPointer(long address) {
		super(address);
	}

	public static PackageEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static PackageEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static PackageEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new PackageEntryPointer(address);
	}

	public PackageEntryPointer add(long count) {
		return PackageEntryPointer.cast(address + (PackageEntry.SIZEOF * count));
	}

	public PackageEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public PackageEntryPointer addOffset(long offset) {
		return PackageEntryPointer.cast(address + offset);
	}

	public PackageEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public PackageEntryPointer sub(long count) {
		return PackageEntryPointer.cast(address - (PackageEntry.SIZEOF * count));
	}

	public PackageEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public PackageEntryPointer subOffset(long offset) {
		return PackageEntryPointer.cast(address - offset);
	}

	public PackageEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public PackageEntryPointer untag(long mask) {
		return PackageEntryPointer.cast(address & ~mask);
	}

	public PackageEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return PackageEntry.SIZEOF;
	}

	// Implementation methods

	// U64 exported
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exportedOffset_", declaredType="U64")
	public UDATA exported() throws CorruptDataException {
		return new U64(getLongAtOffset(PackageEntry._exportedOffset_));
	}

	// U64 exported
	public UDATAPointer exportedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(PackageEntry._exportedOffset_));
	}

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(PackageEntry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(PackageEntry._indexOffset_));
	}

	// U32 moduleIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_moduleIndexOffset_", declaredType="U32")
	public UDATA moduleIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(PackageEntry._moduleIndexOffset_));
	}

	// U32 moduleIndex
	public UDATAPointer moduleIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(PackageEntry._moduleIndexOffset_));
	}

	// PackageEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="PackageEntry*")
	public PackageEntryPointer next() throws CorruptDataException {
		return PackageEntryPointer.cast(getPointerAtOffset(PackageEntry._nextOffset_));
	}

	// PackageEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PackageEntry._nextOffset_));
	}

	// const U8* packageName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_packageNameOffset_", declaredType="const U8*")
	public U8Pointer packageName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(PackageEntry._packageNameOffset_));
	}

	// const U8* packageName
	public PointerPointer packageNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PackageEntry._packageNameOffset_));
	}

	// U32 packageNameLength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_packageNameLengthOffset_", declaredType="U32")
	public UDATA packageNameLength() throws CorruptDataException {
		return new U32(getIntAtOffset(PackageEntry._packageNameLengthOffset_));
	}

	// U32 packageNameLength
	public UDATAPointer packageNameLengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(PackageEntry._packageNameLengthOffset_));
	}

	// J9ROMClass* romClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_romClassOffset_", declaredType="J9ROMClass*")
	public J9ROMClassPointer romClass() throws CorruptDataException {
		return J9ROMClassPointer.cast(getPointerAtOffset(PackageEntry._romClassOffset_));
	}

	// J9ROMClass* romClass
	public PointerPointer romClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PackageEntry._romClassOffset_));
	}

}
