/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _ACLPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _ACLPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_ACL.class)
public class _ACLPointer extends StructurePointer {

	// NULL
	public static final _ACLPointer NULL = new _ACLPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _ACLPointer(long address) {
		super(address);
	}

	public static _ACLPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _ACLPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _ACLPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _ACLPointer(address);
	}

	public _ACLPointer add(long count) {
		return _ACLPointer.cast(address + (_ACL.SIZEOF * count));
	}

	public _ACLPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _ACLPointer addOffset(long offset) {
		return _ACLPointer.cast(address + offset);
	}

	public _ACLPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _ACLPointer sub(long count) {
		return _ACLPointer.cast(address - (_ACL.SIZEOF * count));
	}

	public _ACLPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _ACLPointer subOffset(long offset) {
		return _ACLPointer.cast(address - offset);
	}

	public _ACLPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _ACLPointer untag(long mask) {
		return _ACLPointer.cast(address & ~mask);
	}

	public _ACLPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _ACL.SIZEOF;
	}

	// Implementation methods

	// U16 AceCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AceCountOffset_", declaredType="U16")
	public U16 AceCount() throws CorruptDataException {
		return new U16(getShortAtOffset(_ACL._AceCountOffset_));
	}

	// U16 AceCount
	public U16Pointer AceCountEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_ACL._AceCountOffset_));
	}

	// U8 AclRevision
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AclRevisionOffset_", declaredType="U8")
	public U8 AclRevision() throws CorruptDataException {
		return new U8(getByteAtOffset(_ACL._AclRevisionOffset_));
	}

	// U8 AclRevision
	public U8Pointer AclRevisionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_ACL._AclRevisionOffset_));
	}

	// U16 AclSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AclSizeOffset_", declaredType="U16")
	public U16 AclSize() throws CorruptDataException {
		return new U16(getShortAtOffset(_ACL._AclSizeOffset_));
	}

	// U16 AclSize
	public U16Pointer AclSizeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_ACL._AclSizeOffset_));
	}

	// U8 Sbz1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Sbz1Offset_", declaredType="U8")
	public U8 Sbz1() throws CorruptDataException {
		return new U8(getByteAtOffset(_ACL._Sbz1Offset_));
	}

	// U8 Sbz1
	public U8Pointer Sbz1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_ACL._Sbz1Offset_));
	}

	// U16 Sbz2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Sbz2Offset_", declaredType="U16")
	public U16 Sbz2() throws CorruptDataException {
		return new U16(getShortAtOffset(_ACL._Sbz2Offset_));
	}

	// U16 Sbz2
	public U16Pointer Sbz2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_ACL._Sbz2Offset_));
	}

}
