/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _GUIDPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _GUIDPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_GUID.class)
public class _GUIDPointer extends StructurePointer {

	// NULL
	public static final _GUIDPointer NULL = new _GUIDPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _GUIDPointer(long address) {
		super(address);
	}

	public static _GUIDPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _GUIDPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _GUIDPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _GUIDPointer(address);
	}

	public _GUIDPointer add(long count) {
		return _GUIDPointer.cast(address + (_GUID.SIZEOF * count));
	}

	public _GUIDPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _GUIDPointer addOffset(long offset) {
		return _GUIDPointer.cast(address + offset);
	}

	public _GUIDPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _GUIDPointer sub(long count) {
		return _GUIDPointer.cast(address - (_GUID.SIZEOF * count));
	}

	public _GUIDPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _GUIDPointer subOffset(long offset) {
		return _GUIDPointer.cast(address - offset);
	}

	public _GUIDPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _GUIDPointer untag(long mask) {
		return _GUIDPointer.cast(address & ~mask);
	}

	public _GUIDPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _GUID.SIZEOF;
	}

	// Implementation methods

	// U32 Data1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Data1Offset_", declaredType="U32")
	public UDATA Data1() throws CorruptDataException {
		return new U32(getIntAtOffset(_GUID._Data1Offset_));
	}

	// U32 Data1
	public UDATAPointer Data1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_GUID._Data1Offset_));
	}

	// U16 Data2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Data2Offset_", declaredType="U16")
	public U16 Data2() throws CorruptDataException {
		return new U16(getShortAtOffset(_GUID._Data2Offset_));
	}

	// U16 Data2
	public U16Pointer Data2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_GUID._Data2Offset_));
	}

	// U16 Data3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Data3Offset_", declaredType="U16")
	public U16 Data3() throws CorruptDataException {
		return new U16(getShortAtOffset(_GUID._Data3Offset_));
	}

	// U16 Data3
	public U16Pointer Data3EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_GUID._Data3Offset_));
	}

	// U8[] Data4
	public U8Pointer Data4EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_GUID._Data4Offset_));
	}

}
