/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGE_SECTION_HEADERPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGE_SECTION_HEADERPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGE_SECTION_HEADER.class)
public class _IMAGE_SECTION_HEADERPointer extends StructurePointer {

	// NULL
	public static final _IMAGE_SECTION_HEADERPointer NULL = new _IMAGE_SECTION_HEADERPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGE_SECTION_HEADERPointer(long address) {
		super(address);
	}

	public static _IMAGE_SECTION_HEADERPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGE_SECTION_HEADERPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGE_SECTION_HEADERPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGE_SECTION_HEADERPointer(address);
	}

	public _IMAGE_SECTION_HEADERPointer add(long count) {
		return _IMAGE_SECTION_HEADERPointer.cast(address + (_IMAGE_SECTION_HEADER.SIZEOF * count));
	}

	public _IMAGE_SECTION_HEADERPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGE_SECTION_HEADERPointer addOffset(long offset) {
		return _IMAGE_SECTION_HEADERPointer.cast(address + offset);
	}

	public _IMAGE_SECTION_HEADERPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGE_SECTION_HEADERPointer sub(long count) {
		return _IMAGE_SECTION_HEADERPointer.cast(address - (_IMAGE_SECTION_HEADER.SIZEOF * count));
	}

	public _IMAGE_SECTION_HEADERPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGE_SECTION_HEADERPointer subOffset(long offset) {
		return _IMAGE_SECTION_HEADERPointer.cast(address - offset);
	}

	public _IMAGE_SECTION_HEADERPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGE_SECTION_HEADERPointer untag(long mask) {
		return _IMAGE_SECTION_HEADERPointer.cast(address & ~mask);
	}

	public _IMAGE_SECTION_HEADERPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGE_SECTION_HEADER.SIZEOF;
	}

	// Implementation methods

	// U32 Characteristics
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CharacteristicsOffset_", declaredType="U32")
	public UDATA Characteristics() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._CharacteristicsOffset_));
	}

	// U32 Characteristics
	public UDATAPointer CharacteristicsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._CharacteristicsOffset_));
	}

	// U32 Misc.PhysicalAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Misc$PhysicalAddressOffset_", declaredType="U32")
	public UDATA Misc$PhysicalAddress() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._Misc$PhysicalAddressOffset_));
	}

	// U32 Misc.PhysicalAddress
	public UDATAPointer Misc$PhysicalAddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._Misc$PhysicalAddressOffset_));
	}

	// U32 Misc.VirtualSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Misc$VirtualSizeOffset_", declaredType="U32")
	public UDATA Misc$VirtualSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._Misc$VirtualSizeOffset_));
	}

	// U32 Misc.VirtualSize
	public UDATAPointer Misc$VirtualSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._Misc$VirtualSizeOffset_));
	}

	// U8[] Name
	public U8Pointer NameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._NameOffset_));
	}

	// U16 NumberOfLinenumbers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberOfLinenumbersOffset_", declaredType="U16")
	public U16 NumberOfLinenumbers() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_SECTION_HEADER._NumberOfLinenumbersOffset_));
	}

	// U16 NumberOfLinenumbers
	public U16Pointer NumberOfLinenumbersEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._NumberOfLinenumbersOffset_));
	}

	// U16 NumberOfRelocations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberOfRelocationsOffset_", declaredType="U16")
	public U16 NumberOfRelocations() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_SECTION_HEADER._NumberOfRelocationsOffset_));
	}

	// U16 NumberOfRelocations
	public U16Pointer NumberOfRelocationsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._NumberOfRelocationsOffset_));
	}

	// U32 PointerToLinenumbers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PointerToLinenumbersOffset_", declaredType="U32")
	public UDATA PointerToLinenumbers() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._PointerToLinenumbersOffset_));
	}

	// U32 PointerToLinenumbers
	public UDATAPointer PointerToLinenumbersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._PointerToLinenumbersOffset_));
	}

	// U32 PointerToRawData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PointerToRawDataOffset_", declaredType="U32")
	public UDATA PointerToRawData() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._PointerToRawDataOffset_));
	}

	// U32 PointerToRawData
	public UDATAPointer PointerToRawDataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._PointerToRawDataOffset_));
	}

	// U32 PointerToRelocations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PointerToRelocationsOffset_", declaredType="U32")
	public UDATA PointerToRelocations() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._PointerToRelocationsOffset_));
	}

	// U32 PointerToRelocations
	public UDATAPointer PointerToRelocationsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._PointerToRelocationsOffset_));
	}

	// U32 SizeOfRawData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfRawDataOffset_", declaredType="U32")
	public UDATA SizeOfRawData() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._SizeOfRawDataOffset_));
	}

	// U32 SizeOfRawData
	public UDATAPointer SizeOfRawDataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._SizeOfRawDataOffset_));
	}

	// U32 VirtualAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VirtualAddressOffset_", declaredType="U32")
	public UDATA VirtualAddress() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_SECTION_HEADER._VirtualAddressOffset_));
	}

	// U32 VirtualAddress
	public UDATAPointer VirtualAddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_SECTION_HEADER._VirtualAddressOffset_));
	}

}
