/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _PEBPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _PEBPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_PEB.class)
public class _PEBPointer extends StructurePointer {

	// NULL
	public static final _PEBPointer NULL = new _PEBPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _PEBPointer(long address) {
		super(address);
	}

	public static _PEBPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _PEBPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _PEBPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _PEBPointer(address);
	}

	public _PEBPointer add(long count) {
		return _PEBPointer.cast(address + (_PEB.SIZEOF * count));
	}

	public _PEBPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _PEBPointer addOffset(long offset) {
		return _PEBPointer.cast(address + offset);
	}

	public _PEBPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _PEBPointer sub(long count) {
		return _PEBPointer.cast(address - (_PEB.SIZEOF * count));
	}

	public _PEBPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _PEBPointer subOffset(long offset) {
		return _PEBPointer.cast(address - offset);
	}

	public _PEBPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _PEBPointer untag(long mask) {
		return _PEBPointer.cast(address & ~mask);
	}

	public _PEBPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _PEB.SIZEOF;
	}

	// Implementation methods

	// void* AtlThunkSListPtr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AtlThunkSListPtrOffset_", declaredType="void*")
	public VoidPointer AtlThunkSListPtr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_PEB._AtlThunkSListPtrOffset_));
	}

	// void* AtlThunkSListPtr
	public PointerPointer AtlThunkSListPtrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._AtlThunkSListPtrOffset_));
	}

	// U32 AtlThunkSListPtr32
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AtlThunkSListPtr32Offset_", declaredType="U32")
	public UDATA AtlThunkSListPtr32() throws CorruptDataException {
		return new U32(getIntAtOffset(_PEB._AtlThunkSListPtr32Offset_));
	}

	// U32 AtlThunkSListPtr32
	public UDATAPointer AtlThunkSListPtr32EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PEB._AtlThunkSListPtr32Offset_));
	}

	// U8 BeingDebugged
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BeingDebuggedOffset_", declaredType="U8")
	public U8 BeingDebugged() throws CorruptDataException {
		return new U8(getByteAtOffset(_PEB._BeingDebuggedOffset_));
	}

	// U8 BeingDebugged
	public U8Pointer BeingDebuggedEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_PEB._BeingDebuggedOffset_));
	}

	// _PEB_LDR_DATA* Ldr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LdrOffset_", declaredType="_PEB_LDR_DATA*")
	public _PEB_LDR_DATAPointer Ldr() throws CorruptDataException {
		return _PEB_LDR_DATAPointer.cast(getPointerAtOffset(_PEB._LdrOffset_));
	}

	// _PEB_LDR_DATA* Ldr
	public PointerPointer LdrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._LdrOffset_));
	}

	// void* PostProcessInitRoutine
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PostProcessInitRoutineOffset_", declaredType="void*")
	public VoidPointer PostProcessInitRoutine() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_PEB._PostProcessInitRoutineOffset_));
	}

	// void* PostProcessInitRoutine
	public PointerPointer PostProcessInitRoutineEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._PostProcessInitRoutineOffset_));
	}

	// _RTL_USER_PROCESS_PARAMETERS* ProcessParameters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessParametersOffset_", declaredType="_RTL_USER_PROCESS_PARAMETERS*")
	public _RTL_USER_PROCESS_PARAMETERSPointer ProcessParameters() throws CorruptDataException {
		return _RTL_USER_PROCESS_PARAMETERSPointer.cast(getPointerAtOffset(_PEB._ProcessParametersOffset_));
	}

	// _RTL_USER_PROCESS_PARAMETERS* ProcessParameters
	public PointerPointer ProcessParametersEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._ProcessParametersOffset_));
	}

	// U8[] Reserved1
	public U8Pointer Reserved1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_PEB._Reserved1Offset_));
	}

	// U8[] Reserved10
	public U8Pointer Reserved10EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_PEB._Reserved10Offset_));
	}

	// U8[] Reserved11
	public U8Pointer Reserved11EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_PEB._Reserved11Offset_));
	}

	// void*[] Reserved12
	public PointerPointer Reserved12EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._Reserved12Offset_));
	}

	// U8[] Reserved2
	public U8Pointer Reserved2EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_PEB._Reserved2Offset_));
	}

	// void*[] Reserved3
	public PointerPointer Reserved3EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._Reserved3Offset_));
	}

	// void*[] Reserved4
	public PointerPointer Reserved4EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._Reserved4Offset_));
	}

	// void* Reserved5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved5Offset_", declaredType="void*")
	public VoidPointer Reserved5() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_PEB._Reserved5Offset_));
	}

	// void* Reserved5
	public PointerPointer Reserved5EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._Reserved5Offset_));
	}

	// U32 Reserved6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved6Offset_", declaredType="U32")
	public UDATA Reserved6() throws CorruptDataException {
		return new U32(getIntAtOffset(_PEB._Reserved6Offset_));
	}

	// U32 Reserved6
	public UDATAPointer Reserved6EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PEB._Reserved6Offset_));
	}

	// void* Reserved7
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved7Offset_", declaredType="void*")
	public VoidPointer Reserved7() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_PEB._Reserved7Offset_));
	}

	// void* Reserved7
	public PointerPointer Reserved7EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._Reserved7Offset_));
	}

	// U32 Reserved8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved8Offset_", declaredType="U32")
	public UDATA Reserved8() throws CorruptDataException {
		return new U32(getIntAtOffset(_PEB._Reserved8Offset_));
	}

	// U32 Reserved8
	public UDATAPointer Reserved8EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PEB._Reserved8Offset_));
	}

	// void*[] Reserved9
	public PointerPointer Reserved9EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_PEB._Reserved9Offset_));
	}

	// U32 SessionId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SessionIdOffset_", declaredType="U32")
	public UDATA SessionId() throws CorruptDataException {
		return new U32(getIntAtOffset(_PEB._SessionIdOffset_));
	}

	// U32 SessionId
	public UDATAPointer SessionIdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PEB._SessionIdOffset_));
	}

}
