/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _XSAVE_FORMATPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _XSAVE_FORMATPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_XSAVE_FORMAT.class)
public class _XSAVE_FORMATPointer extends StructurePointer {

	// NULL
	public static final _XSAVE_FORMATPointer NULL = new _XSAVE_FORMATPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _XSAVE_FORMATPointer(long address) {
		super(address);
	}

	public static _XSAVE_FORMATPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _XSAVE_FORMATPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _XSAVE_FORMATPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _XSAVE_FORMATPointer(address);
	}

	public _XSAVE_FORMATPointer add(long count) {
		return _XSAVE_FORMATPointer.cast(address + (_XSAVE_FORMAT.SIZEOF * count));
	}

	public _XSAVE_FORMATPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _XSAVE_FORMATPointer addOffset(long offset) {
		return _XSAVE_FORMATPointer.cast(address + offset);
	}

	public _XSAVE_FORMATPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _XSAVE_FORMATPointer sub(long count) {
		return _XSAVE_FORMATPointer.cast(address - (_XSAVE_FORMAT.SIZEOF * count));
	}

	public _XSAVE_FORMATPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _XSAVE_FORMATPointer subOffset(long offset) {
		return _XSAVE_FORMATPointer.cast(address - offset);
	}

	public _XSAVE_FORMATPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _XSAVE_FORMATPointer untag(long mask) {
		return _XSAVE_FORMATPointer.cast(address & ~mask);
	}

	public _XSAVE_FORMATPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _XSAVE_FORMAT.SIZEOF;
	}

	// Implementation methods

	// U16 ControlWord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ControlWordOffset_", declaredType="U16")
	public U16 ControlWord() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._ControlWordOffset_));
	}

	// U16 ControlWord
	public U16Pointer ControlWordEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._ControlWordOffset_));
	}

	// U32 DataOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DataOffsetOffset_", declaredType="U32")
	public UDATA DataOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_XSAVE_FORMAT._DataOffsetOffset_));
	}

	// U32 DataOffset
	public UDATAPointer DataOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_XSAVE_FORMAT._DataOffsetOffset_));
	}

	// U16 DataSelector
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DataSelectorOffset_", declaredType="U16")
	public U16 DataSelector() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._DataSelectorOffset_));
	}

	// U16 DataSelector
	public U16Pointer DataSelectorEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._DataSelectorOffset_));
	}

	// U32 ErrorOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ErrorOffsetOffset_", declaredType="U32")
	public UDATA ErrorOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_XSAVE_FORMAT._ErrorOffsetOffset_));
	}

	// U32 ErrorOffset
	public UDATAPointer ErrorOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_XSAVE_FORMAT._ErrorOffsetOffset_));
	}

	// U16 ErrorOpcode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ErrorOpcodeOffset_", declaredType="U16")
	public U16 ErrorOpcode() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._ErrorOpcodeOffset_));
	}

	// U16 ErrorOpcode
	public U16Pointer ErrorOpcodeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._ErrorOpcodeOffset_));
	}

	// U16 ErrorSelector
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ErrorSelectorOffset_", declaredType="U16")
	public U16 ErrorSelector() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._ErrorSelectorOffset_));
	}

	// U16 ErrorSelector
	public U16Pointer ErrorSelectorEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._ErrorSelectorOffset_));
	}

	// _M128A[] FloatRegisters
	public _M128APointer FloatRegistersEA() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_XSAVE_FORMAT._FloatRegistersOffset_));
	}

	// U32 MxCsr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MxCsrOffset_", declaredType="U32")
	public UDATA MxCsr() throws CorruptDataException {
		return new U32(getIntAtOffset(_XSAVE_FORMAT._MxCsrOffset_));
	}

	// U32 MxCsr
	public UDATAPointer MxCsrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_XSAVE_FORMAT._MxCsrOffset_));
	}

	// U32 MxCsr_Mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MxCsr_MaskOffset_", declaredType="U32")
	public UDATA MxCsr_Mask() throws CorruptDataException {
		return new U32(getIntAtOffset(_XSAVE_FORMAT._MxCsr_MaskOffset_));
	}

	// U32 MxCsr_Mask
	public UDATAPointer MxCsr_MaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_XSAVE_FORMAT._MxCsr_MaskOffset_));
	}

	// U8 Reserved1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved1Offset_", declaredType="U8")
	public U8 Reserved1() throws CorruptDataException {
		return new U8(getByteAtOffset(_XSAVE_FORMAT._Reserved1Offset_));
	}

	// U8 Reserved1
	public U8Pointer Reserved1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._Reserved1Offset_));
	}

	// U16 Reserved2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved2Offset_", declaredType="U16")
	public U16 Reserved2() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._Reserved2Offset_));
	}

	// U16 Reserved2
	public U16Pointer Reserved2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._Reserved2Offset_));
	}

	// U16 Reserved3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Reserved3Offset_", declaredType="U16")
	public U16 Reserved3() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._Reserved3Offset_));
	}

	// U16 Reserved3
	public U16Pointer Reserved3EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._Reserved3Offset_));
	}

	// U8[] Reserved4
	public U8Pointer Reserved4EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._Reserved4Offset_));
	}

	// U16 StatusWord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StatusWordOffset_", declaredType="U16")
	public U16 StatusWord() throws CorruptDataException {
		return new U16(getShortAtOffset(_XSAVE_FORMAT._StatusWordOffset_));
	}

	// U16 StatusWord
	public U16Pointer StatusWordEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._StatusWordOffset_));
	}

	// U8 TagWord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TagWordOffset_", declaredType="U8")
	public U8 TagWord() throws CorruptDataException {
		return new U8(getByteAtOffset(_XSAVE_FORMAT._TagWordOffset_));
	}

	// U8 TagWord
	public U8Pointer TagWordEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_XSAVE_FORMAT._TagWordOffset_));
	}

	// _M128A[] XmmRegisters
	public _M128APointer XmmRegistersEA() throws CorruptDataException {
		return _M128APointer.cast(nonNullFieldEA(_XSAVE_FORMAT._XmmRegistersOffset_));
	}

}
