/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: findObjectDeadlockedThreads$__l2$ThreadChainPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the findObjectDeadlockedThreads$__l2$ThreadChainPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=findObjectDeadlockedThreads$__l2$ThreadChain.class)
public class findObjectDeadlockedThreads$__l2$ThreadChainPointer extends StructurePointer {

	// NULL
	public static final findObjectDeadlockedThreads$__l2$ThreadChainPointer NULL = new findObjectDeadlockedThreads$__l2$ThreadChainPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected findObjectDeadlockedThreads$__l2$ThreadChainPointer(long address) {
		super(address);
	}

	public static findObjectDeadlockedThreads$__l2$ThreadChainPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static findObjectDeadlockedThreads$__l2$ThreadChainPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static findObjectDeadlockedThreads$__l2$ThreadChainPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new findObjectDeadlockedThreads$__l2$ThreadChainPointer(address);
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer add(long count) {
		return findObjectDeadlockedThreads$__l2$ThreadChainPointer.cast(address + (findObjectDeadlockedThreads$__l2$ThreadChain.SIZEOF * count));
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer add(Scalar count) {
		return add(count.longValue());
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer addOffset(long offset) {
		return findObjectDeadlockedThreads$__l2$ThreadChainPointer.cast(address + offset);
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer sub(long count) {
		return findObjectDeadlockedThreads$__l2$ThreadChainPointer.cast(address - (findObjectDeadlockedThreads$__l2$ThreadChain.SIZEOF * count));
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer subOffset(long offset) {
		return findObjectDeadlockedThreads$__l2$ThreadChainPointer.cast(address - offset);
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer untag(long mask) {
		return findObjectDeadlockedThreads$__l2$ThreadChainPointer.cast(address & ~mask);
	}

	public findObjectDeadlockedThreads$__l2$ThreadChainPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return findObjectDeadlockedThreads$__l2$ThreadChain.SIZEOF;
	}

	// Implementation methods

	// U64 deadlocked
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_deadlockedOffset_", declaredType="U64")
	public UDATA deadlocked() throws CorruptDataException {
		return new U64(getLongAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._deadlockedOffset_));
	}

	// U64 deadlocked
	public UDATAPointer deadlockedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._deadlockedOffset_));
	}

	// J9Object* object
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objectOffset_", declaredType="J9Object*")
	public J9ObjectPointer object() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._objectOffset_));
	}

	// J9Object* object
	public PointerPointer objectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._objectOffset_));
	}

	// J9VMThread* owner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ownerOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer owner() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._ownerOffset_));
	}

	// J9VMThread* owner
	public PointerPointer ownerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._ownerOffset_));
	}

	// I64 owner_index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_owner_indexOffset_", declaredType="I64")
	public IDATA owner_index() throws CorruptDataException {
		return new I64(getLongAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._owner_indexOffset_));
	}

	// I64 owner_index
	public IDATAPointer owner_indexEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._owner_indexOffset_));
	}

	// J9VMThread* thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer thread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._threadOffset_));
	}

	// J9VMThread* thread
	public PointerPointer threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._threadOffset_));
	}

	// J9Object* threadobj
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadobjOffset_", declaredType="J9Object*")
	public J9ObjectPointer threadobj() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._threadobjOffset_));
	}

	// J9Object* threadobj
	public PointerPointer threadobjEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._threadobjOffset_));
	}

	// U64 visit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_visitOffset_", declaredType="U64")
	public UDATA visit() throws CorruptDataException {
		return new U64(getLongAtOffset(findObjectDeadlockedThreads$__l2$ThreadChain._visitOffset_));
	}

	// U64 visit
	public UDATAPointer visitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(findObjectDeadlockedThreads$__l2$ThreadChain._visitOffset_));
	}

}
