/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagPARAMDESCEXPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagPARAMDESCEXPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagPARAMDESCEX.class)
public class tagPARAMDESCEXPointer extends StructurePointer {

	// NULL
	public static final tagPARAMDESCEXPointer NULL = new tagPARAMDESCEXPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagPARAMDESCEXPointer(long address) {
		super(address);
	}

	public static tagPARAMDESCEXPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagPARAMDESCEXPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagPARAMDESCEXPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagPARAMDESCEXPointer(address);
	}

	public tagPARAMDESCEXPointer add(long count) {
		return tagPARAMDESCEXPointer.cast(address + (tagPARAMDESCEX.SIZEOF * count));
	}

	public tagPARAMDESCEXPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagPARAMDESCEXPointer addOffset(long offset) {
		return tagPARAMDESCEXPointer.cast(address + offset);
	}

	public tagPARAMDESCEXPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagPARAMDESCEXPointer sub(long count) {
		return tagPARAMDESCEXPointer.cast(address - (tagPARAMDESCEX.SIZEOF * count));
	}

	public tagPARAMDESCEXPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagPARAMDESCEXPointer subOffset(long offset) {
		return tagPARAMDESCEXPointer.cast(address - offset);
	}

	public tagPARAMDESCEXPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagPARAMDESCEXPointer untag(long mask) {
		return tagPARAMDESCEXPointer.cast(address & ~mask);
	}

	public tagPARAMDESCEXPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagPARAMDESCEX.SIZEOF;
	}

	// Implementation methods

	// U32 cBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cBytesOffset_", declaredType="U32")
	public UDATA cBytes() throws CorruptDataException {
		return new U32(getIntAtOffset(tagPARAMDESCEX._cBytesOffset_));
	}

	// U32 cBytes
	public UDATAPointer cBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagPARAMDESCEX._cBytesOffset_));
	}

	// tagVARIANT varDefaultValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_varDefaultValueOffset_", declaredType="tagVARIANT")
	public tagVARIANTPointer varDefaultValue() throws CorruptDataException {
		return tagVARIANTPointer.cast(nonNullFieldEA(tagPARAMDESCEX._varDefaultValueOffset_));
	}

	// tagVARIANT varDefaultValue
	public PointerPointer varDefaultValueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagPARAMDESCEX._varDefaultValueOffset_));
	}

}
