/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: typePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the typePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=type.class)
public class typePointer extends StructurePointer {

	// NULL
	public static final typePointer NULL = new typePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected typePointer(long address) {
		super(address);
	}

	public static typePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static typePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static typePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new typePointer(address);
	}

	public typePointer add(long count) {
		return typePointer.cast(address + (type.SIZEOF * count));
	}

	public typePointer add(Scalar count) {
		return add(count.longValue());
	}

	public typePointer addOffset(long offset) {
		return typePointer.cast(address + offset);
	}

	public typePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public typePointer sub(long count) {
		return typePointer.cast(address - (type.SIZEOF * count));
	}

	public typePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public typePointer subOffset(long offset) {
		return typePointer.cast(address - offset);
	}

	public typePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public typePointer untag(long mask) {
		return typePointer.cast(address & ~mask);
	}

	public typePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return type.SIZEOF;
	}

	// Implementation methods

	// void clazz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_clazzOffset_", declaredType="void")
	public VoidPointer clazz() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._clazzOffset_));
	}

	// void clazz
	public PointerPointer clazzEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._clazzOffset_));
	}

	// void intFloat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intFloatOffset_", declaredType="void")
	public VoidPointer intFloat() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._intFloatOffset_));
	}

	// void intFloat
	public PointerPointer intFloatEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._intFloatOffset_));
	}

	// void invokedynamic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_invokedynamicOffset_", declaredType="void")
	public VoidPointer invokedynamic() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._invokedynamicOffset_));
	}

	// void invokedynamic
	public PointerPointer invokedynamicEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._invokedynamicOffset_));
	}

	// void longDouble
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_longDoubleOffset_", declaredType="void")
	public VoidPointer longDouble() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._longDoubleOffset_));
	}

	// void longDouble
	public PointerPointer longDoubleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._longDoubleOffset_));
	}

	// void methodHandle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methodHandleOffset_", declaredType="void")
	public VoidPointer methodHandle() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._methodHandleOffset_));
	}

	// void methodHandle
	public PointerPointer methodHandleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._methodHandleOffset_));
	}

	// void methodType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methodTypeOffset_", declaredType="void")
	public VoidPointer methodType() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._methodTypeOffset_));
	}

	// void methodType
	public PointerPointer methodTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._methodTypeOffset_));
	}

	// void nas
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nasOffset_", declaredType="void")
	public VoidPointer nas() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._nasOffset_));
	}

	// void nas
	public PointerPointer nasEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._nasOffset_));
	}

	// void ref
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_refOffset_", declaredType="void")
	public VoidPointer ref() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._refOffset_));
	}

	// void ref
	public PointerPointer refEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._refOffset_));
	}

	// void string
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stringOffset_", declaredType="void")
	public VoidPointer string() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._stringOffset_));
	}

	// void string
	public PointerPointer stringEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._stringOffset_));
	}

	// void utf8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_utf8Offset_", declaredType="void")
	public VoidPointer utf8() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(type._utf8Offset_));
	}

	// void utf8
	public PointerPointer utf8EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(type._utf8Offset_));
	}

}
