/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9BaseTypePrimitiveROMClasses
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9BaseTypePrimitiveROMClasses {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _booleanClassNameOffset_;
	public static final int _booleanReflectROMClassOffset_;
	public static final int _byteClassNameOffset_;
	public static final int _byteReflectROMClassOffset_;
	public static final int _charClassNameOffset_;
	public static final int _charReflectROMClassOffset_;
	public static final int _doubleClassNameOffset_;
	public static final int _doubleReflectROMClassOffset_;
	public static final int _floatClassNameOffset_;
	public static final int _floatReflectROMClassOffset_;
	public static final int _headerOffset_;
	public static final int _intClassNameOffset_;
	public static final int _intReflectROMClassOffset_;
	public static final int _longClassNameOffset_;
	public static final int _longReflectROMClassOffset_;
	public static final int _shortClassNameOffset_;
	public static final int _shortReflectROMClassOffset_;
	public static final int _voidClassNameOffset_;
	public static final int _voidReflectROMClassOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_booleanClassNameOffset_ = 0;
		_booleanReflectROMClassOffset_ = 0;
		_byteClassNameOffset_ = 0;
		_byteReflectROMClassOffset_ = 0;
		_charClassNameOffset_ = 0;
		_charReflectROMClassOffset_ = 0;
		_doubleClassNameOffset_ = 0;
		_doubleReflectROMClassOffset_ = 0;
		_floatClassNameOffset_ = 0;
		_floatReflectROMClassOffset_ = 0;
		_headerOffset_ = 0;
		_intClassNameOffset_ = 0;
		_intReflectROMClassOffset_ = 0;
		_longClassNameOffset_ = 0;
		_longReflectROMClassOffset_ = 0;
		_shortClassNameOffset_ = 0;
		_shortReflectROMClassOffset_ = 0;
		_voidClassNameOffset_ = 0;
		_voidReflectROMClassOffset_ = 0;
	}

}
