/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: OSCacheConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class OSCacheConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9SH_OSCACHE_CORRUPT;
	public static final long J9SH_OSCACHE_CREATE;
	public static final long J9SH_OSCACHE_CREATED;
	public static final long J9SH_OSCACHE_DIFF_BUILDID;
	public static final long J9SH_OSCACHE_FAILURE;
	public static final long J9SH_OSCACHE_HEADER_CORRUPT;
	public static final long J9SH_OSCACHE_HEADER_DIFF_BUILDID;
	public static final long J9SH_OSCACHE_HEADER_MISSING;
	public static final long J9SH_OSCACHE_HEADER_OK;
	public static final long J9SH_OSCACHE_HEADER_WRONG_VERSION;
	public static final long J9SH_OSCACHE_INUSE;
	public static final long J9SH_OSCACHE_NO_CACHE;
	public static final long J9SH_OSCACHE_OPENED;
	public static final long J9SH_OSCACHE_OPEXIST_DESTROY;
	public static final long J9SH_OSCACHE_OPEXIST_DO_NOT_CREATE;
	public static final long J9SH_OSCACHE_OPEXIST_STATS;
	public static final long J9SH_OSCACHE_OUTOFMEMORY;
	public static final long J9SH_OSCACHE_READONLY_RETRY_COUNT;
	public static final long J9SH_OSCACHE_READONLY_RETRY_SLEEP_MILLIS;
	public static final long J9SH_OSCACHE_SEMAPHORE_MISMATCH;
	public static final long J9SH_OSCACHE_UNKNOWN;
	public static final long OSCACHE_CURRENT_CACHE_GEN;
	public static final long OSCACHE_HEADER_FIELD_BUILDID;
	public static final long OSCACHE_HEADER_FIELD_CACHE_INIT_COMPLETE;
	public static final long OSCACHE_HEADER_FIELD_DATA_LENGTH;
	public static final long OSCACHE_HEADER_FIELD_DATA_START;
	public static final long OSCACHE_HEADER_FIELD_GENERATION;
	public static final long OSCACHE_HEADER_FIELD_SIZE;
	public static final long OSCACHE_LOWEST_ACTIVE_GEN;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9SH_OSCACHE_CORRUPT = 0;
		J9SH_OSCACHE_CREATE = 0;
		J9SH_OSCACHE_CREATED = 0;
		J9SH_OSCACHE_DIFF_BUILDID = 0;
		J9SH_OSCACHE_FAILURE = 0;
		J9SH_OSCACHE_HEADER_CORRUPT = 0;
		J9SH_OSCACHE_HEADER_DIFF_BUILDID = 0;
		J9SH_OSCACHE_HEADER_MISSING = 0;
		J9SH_OSCACHE_HEADER_OK = 0;
		J9SH_OSCACHE_HEADER_WRONG_VERSION = 0;
		J9SH_OSCACHE_INUSE = 0;
		J9SH_OSCACHE_NO_CACHE = 0;
		J9SH_OSCACHE_OPENED = 0;
		J9SH_OSCACHE_OPEXIST_DESTROY = 0;
		J9SH_OSCACHE_OPEXIST_DO_NOT_CREATE = 0;
		J9SH_OSCACHE_OPEXIST_STATS = 0;
		J9SH_OSCACHE_OUTOFMEMORY = 0;
		J9SH_OSCACHE_READONLY_RETRY_COUNT = 0;
		J9SH_OSCACHE_READONLY_RETRY_SLEEP_MILLIS = 0;
		J9SH_OSCACHE_SEMAPHORE_MISMATCH = 0;
		J9SH_OSCACHE_UNKNOWN = 0;
		OSCACHE_CURRENT_CACHE_GEN = 0;
		OSCACHE_HEADER_FIELD_BUILDID = 0;
		OSCACHE_HEADER_FIELD_CACHE_INIT_COMPLETE = 0;
		OSCACHE_HEADER_FIELD_DATA_LENGTH = 0;
		OSCACHE_HEADER_FIELD_DATA_START = 0;
		OSCACHE_HEADER_FIELD_GENERATION = 0;
		OSCACHE_HEADER_FIELD_SIZE = 0;
		OSCACHE_LOWEST_ACTIVE_GEN = 0;
	}

}
