/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _KNONVOLATILE_CONTEXT_POINTERS
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _KNONVOLATILE_CONTEXT_POINTERS {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _FloatingContextOffset_;
	public static final int _IntegerContextOffset_;
	public static final int _R10Offset_;
	public static final int _R11Offset_;
	public static final int _R12Offset_;
	public static final int _R13Offset_;
	public static final int _R14Offset_;
	public static final int _R15Offset_;
	public static final int _R8Offset_;
	public static final int _R9Offset_;
	public static final int _RaxOffset_;
	public static final int _RbpOffset_;
	public static final int _RbxOffset_;
	public static final int _RcxOffset_;
	public static final int _RdiOffset_;
	public static final int _RdxOffset_;
	public static final int _RsiOffset_;
	public static final int _RspOffset_;
	public static final int _Xmm0Offset_;
	public static final int _Xmm1Offset_;
	public static final int _Xmm10Offset_;
	public static final int _Xmm11Offset_;
	public static final int _Xmm12Offset_;
	public static final int _Xmm13Offset_;
	public static final int _Xmm14Offset_;
	public static final int _Xmm15Offset_;
	public static final int _Xmm2Offset_;
	public static final int _Xmm3Offset_;
	public static final int _Xmm4Offset_;
	public static final int _Xmm5Offset_;
	public static final int _Xmm6Offset_;
	public static final int _Xmm7Offset_;
	public static final int _Xmm8Offset_;
	public static final int _Xmm9Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_FloatingContextOffset_ = 0;
		_IntegerContextOffset_ = 0;
		_R10Offset_ = 0;
		_R11Offset_ = 0;
		_R12Offset_ = 0;
		_R13Offset_ = 0;
		_R14Offset_ = 0;
		_R15Offset_ = 0;
		_R8Offset_ = 0;
		_R9Offset_ = 0;
		_RaxOffset_ = 0;
		_RbpOffset_ = 0;
		_RbxOffset_ = 0;
		_RcxOffset_ = 0;
		_RdiOffset_ = 0;
		_RdxOffset_ = 0;
		_RsiOffset_ = 0;
		_RspOffset_ = 0;
		_Xmm0Offset_ = 0;
		_Xmm1Offset_ = 0;
		_Xmm10Offset_ = 0;
		_Xmm11Offset_ = 0;
		_Xmm12Offset_ = 0;
		_Xmm13Offset_ = 0;
		_Xmm14Offset_ = 0;
		_Xmm15Offset_ = 0;
		_Xmm2Offset_ = 0;
		_Xmm3Offset_ = 0;
		_Xmm4Offset_ = 0;
		_Xmm5Offset_ = 0;
		_Xmm6Offset_ = 0;
		_Xmm7Offset_ = 0;
		_Xmm8Offset_ = 0;
		_Xmm9Offset_ = 0;
	}

}
