/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: malloc_state
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class malloc_state {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _dvOffset_;
	public static final int _dvsizeOffset_;
	public static final int _footprintOffset_;
	public static final int _least_addrOffset_;
	public static final int _magicOffset_;
	public static final int _max_footprintOffset_;
	public static final int _mflagsOffset_;
	public static final int _mutexOffset_;
	public static final int _segOffset_;
	public static final int _smallbinsOffset_;
	public static final int _smallmapOffset_;
	public static final int _topOffset_;
	public static final int _topsizeOffset_;
	public static final int _treebinsOffset_;
	public static final int _treemapOffset_;
	public static final int _trim_checkOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_dvOffset_ = 0;
		_dvsizeOffset_ = 0;
		_footprintOffset_ = 0;
		_least_addrOffset_ = 0;
		_magicOffset_ = 0;
		_max_footprintOffset_ = 0;
		_mflagsOffset_ = 0;
		_mutexOffset_ = 0;
		_segOffset_ = 0;
		_smallbinsOffset_ = 0;
		_smallmapOffset_ = 0;
		_topOffset_ = 0;
		_topsizeOffset_ = 0;
		_treebinsOffset_ = 0;
		_treemapOffset_ = 0;
		_trim_checkOffset_ = 0;
	}

}
