/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: mach_header_64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the mach_header_64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=mach_header_64.class)
public class mach_header_64Pointer extends StructurePointer {

	// NULL
	public static final mach_header_64Pointer NULL = new mach_header_64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected mach_header_64Pointer(long address) {
		super(address);
	}

	public static mach_header_64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static mach_header_64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static mach_header_64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new mach_header_64Pointer(address);
	}

	public mach_header_64Pointer add(long count) {
		return mach_header_64Pointer.cast(address + (mach_header_64.SIZEOF * count));
	}

	public mach_header_64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public mach_header_64Pointer addOffset(long offset) {
		return mach_header_64Pointer.cast(address + offset);
	}

	public mach_header_64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public mach_header_64Pointer sub(long count) {
		return mach_header_64Pointer.cast(address - (mach_header_64.SIZEOF * count));
	}

	public mach_header_64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public mach_header_64Pointer subOffset(long offset) {
		return mach_header_64Pointer.cast(address - offset);
	}

	public mach_header_64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public mach_header_64Pointer untag(long mask) {
		return mach_header_64Pointer.cast(address & ~mask);
	}

	public mach_header_64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return mach_header_64.SIZEOF;
	}

	// Implementation methods

	// I32 cpusubtype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpusubtypeOffset_", declaredType="I32")
	public IDATA cpusubtype() throws CorruptDataException {
		return new I32(getIntAtOffset(mach_header_64._cpusubtypeOffset_));
	}

	// I32 cpusubtype
	public IDATAPointer cpusubtypeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mach_header_64._cpusubtypeOffset_));
	}

	// I32 cputype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cputypeOffset_", declaredType="I32")
	public IDATA cputype() throws CorruptDataException {
		return new I32(getIntAtOffset(mach_header_64._cputypeOffset_));
	}

	// I32 cputype
	public IDATAPointer cputypeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mach_header_64._cputypeOffset_));
	}

	// U32 filetype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_filetypeOffset_", declaredType="U32")
	public UDATA filetype() throws CorruptDataException {
		return new U32(getIntAtOffset(mach_header_64._filetypeOffset_));
	}

	// U32 filetype
	public UDATAPointer filetypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mach_header_64._filetypeOffset_));
	}

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(mach_header_64._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mach_header_64._flagsOffset_));
	}

	// U32 magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_magicOffset_", declaredType="U32")
	public UDATA magic() throws CorruptDataException {
		return new U32(getIntAtOffset(mach_header_64._magicOffset_));
	}

	// U32 magic
	public UDATAPointer magicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mach_header_64._magicOffset_));
	}

	// U32 ncmds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ncmdsOffset_", declaredType="U32")
	public UDATA ncmds() throws CorruptDataException {
		return new U32(getIntAtOffset(mach_header_64._ncmdsOffset_));
	}

	// U32 ncmds
	public UDATAPointer ncmdsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mach_header_64._ncmdsOffset_));
	}

	// U32 reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedOffset_", declaredType="U32")
	public UDATA reserved() throws CorruptDataException {
		return new U32(getIntAtOffset(mach_header_64._reservedOffset_));
	}

	// U32 reserved
	public UDATAPointer reservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mach_header_64._reservedOffset_));
	}

	// U32 sizeofcmds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sizeofcmdsOffset_", declaredType="U32")
	public UDATA sizeofcmds() throws CorruptDataException {
		return new U32(getIntAtOffset(mach_header_64._sizeofcmdsOffset_));
	}

	// U32 sizeofcmds
	public UDATAPointer sizeofcmdsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(mach_header_64._sizeofcmdsOffset_));
	}

}
