/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JITDecompilationInfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JITDecompilationInfo {

	// VM Constants

	public static final long SIZEOF;
	public static final long JITDECOMP_CODE_BREAKPOINT;
	public static final long JITDECOMP_DATA_BREAKPOINT;
	public static final long JITDECOMP_FRAME_POP_NOTIFICATION;
	public static final long JITDECOMP_HOTSWAP;
	public static final long JITDECOMP_ON_STACK_REPLACEMENT;
	public static final long JITDECOMP_OSR_GLOBAL_BUFFER_USED;
	public static final long JITDECOMP_POP_FRAMES;
	public static final long JITDECOMP_SINGLE_STEP;
	public static final long JITDECOMP_STACK_LOCALS_MODIFIED;

	// Offsets

	public static final int _bpOffset_;
	public static final int _methodOffset_;
	public static final int _nextOffset_;
	public static final int _osrBufferOffset_;
	public static final int _pcOffset_;
	public static final int _pcAddressOffset_;
	public static final int _reasonOffset_;
	public static final int _usesOSROffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		JITDECOMP_CODE_BREAKPOINT = 0;
		JITDECOMP_DATA_BREAKPOINT = 0;
		JITDECOMP_FRAME_POP_NOTIFICATION = 0;
		JITDECOMP_HOTSWAP = 0;
		JITDECOMP_ON_STACK_REPLACEMENT = 0;
		JITDECOMP_OSR_GLOBAL_BUFFER_USED = 0;
		JITDECOMP_POP_FRAMES = 0;
		JITDECOMP_SINGLE_STEP = 0;
		JITDECOMP_STACK_LOCALS_MODIFIED = 0;
		_bpOffset_ = 0;
		_methodOffset_ = 0;
		_nextOffset_ = 0;
		_osrBufferOffset_ = 0;
		_pcOffset_ = 0;
		_pcAddressOffset_ = 0;
		_reasonOffset_ = 0;
		_usesOSROffset_ = 0;
	}

}
