/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_SchedulingDelegate
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_SchedulingDelegate {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __automaticDefragmentEmptinessThresholdOffset_;
	public static final int __averageCopyForwardBytesCopiedOffset_;
	public static final int __averageCopyForwardBytesDiscardedOffset_;
	public static final int __averageCopyForwardRateOffset_;
	public static final int __averageMacroDefragmentationWorkOffset_;
	public static final int __averagePgcIntervalOffset_;
	public static final int __averageSurvivorSetRegionCountOffset_;
	public static final int __bytesCompactedToFreeBytesRatioOffset_;
	public static final int __concurrentMarkGCThreadsTotalWorkTimeOffset_;
	public static final int __currentMacroDefragmentationWorkOffset_;
	public static final int __currentlyPerformingGMPOffset_;
	public static final int __defragmentRegionConsumptionRateOffset_;
	public static final int __didGMPCompleteSinceLastReclaimOffset_;
	public static final int __disableCopyForwardDuringCurrentGlobalMarkPhaseOffset_;
	public static final int __dynamicGlobalMarkIncrementTimeMillisOffset_;
	public static final int __edenRegionCountOffset_;
	public static final int __edenSizeFactorOffset_;
	public static final int __edenSurvivalRateCopyForwardOffset_;
	public static final int __estimatedFreeTenureOffset_;
	public static final int __extensionsOffset_;
	public static final int __globalMarkIncrementsTotalTimeOffset_;
	public static final int __globalMarkIntervalStartTimeOffset_;
	public static final int __globalMarkOverheadOffset_;
	public static final int __globalSweepRequiredOffset_;
	public static final int __globalSweepTimeUsOffset_;
	public static final int __heapOccupancyTrendOffset_;
	public static final int __historicBytesScannedConcurrentlyPerGMPOffset_;
	public static final int __historicTotalIncrementalScanTimePerGMPOffset_;
	public static final int __historicalPartialGCTimeOffset_;
	public static final int __idealEdenRegionCountOffset_;
	public static final int __liveSetBytesAfterGlobalSweepOffset_;
	public static final int __liveSetBytesAfterPartialCollectOffset_;
	public static final int __liveSetBytesBeforeGlobalSweepOffset_;
	public static final int __maxEdenRegionCountOffset_;
	public static final int __minEdenRegionCountOffset_;
	public static final int __minimumEdenRegionCountOffset_;
	public static final int __nextIncrementWillDoGlobalMarkPhaseOffset_;
	public static final int __nextIncrementWillDoPartialGarbageCollectionOffset_;
	public static final int __nextPGCShouldCopyForwardOffset_;
	public static final int __nonEdenSurvivalCountCopyForwardOffset_;
	public static final int __numberOfHeapRegionsOffset_;
	public static final int __partialGcOverheadOffset_;
	public static final int __partialGcStartTimeOffset_;
	public static final int __pgcCountSinceGMPEndOffset_;
	public static final int __pgcTimeIncreasePerEdenFactorOffset_;
	public static final int __previousDefragmentReclaimableRegionsOffset_;
	public static final int __previousLiveSetBytesAfterGlobalSweepOffset_;
	public static final int __previousReclaimableRegionsOffset_;
	public static final int __recentPartialGCTimeOffset_;
	public static final int __regionConsumptionRateOffset_;
	public static final int __regionManagerOffset_;
	public static final int __remainingGMPIntermissionIntervalsOffset_;
	public static final int __scanRateStatsOffset_;
	public static final int __scannableBytesRatioOffset_;
	public static final int __taxationIndexOffset_;
	public static final int __totalGMPWorkTimeUsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__automaticDefragmentEmptinessThresholdOffset_ = 0;
		__averageCopyForwardBytesCopiedOffset_ = 0;
		__averageCopyForwardBytesDiscardedOffset_ = 0;
		__averageCopyForwardRateOffset_ = 0;
		__averageMacroDefragmentationWorkOffset_ = 0;
		__averagePgcIntervalOffset_ = 0;
		__averageSurvivorSetRegionCountOffset_ = 0;
		__bytesCompactedToFreeBytesRatioOffset_ = 0;
		__concurrentMarkGCThreadsTotalWorkTimeOffset_ = 0;
		__currentMacroDefragmentationWorkOffset_ = 0;
		__currentlyPerformingGMPOffset_ = 0;
		__defragmentRegionConsumptionRateOffset_ = 0;
		__didGMPCompleteSinceLastReclaimOffset_ = 0;
		__disableCopyForwardDuringCurrentGlobalMarkPhaseOffset_ = 0;
		__dynamicGlobalMarkIncrementTimeMillisOffset_ = 0;
		__edenRegionCountOffset_ = 0;
		__edenSizeFactorOffset_ = 0;
		__edenSurvivalRateCopyForwardOffset_ = 0;
		__estimatedFreeTenureOffset_ = 0;
		__extensionsOffset_ = 0;
		__globalMarkIncrementsTotalTimeOffset_ = 0;
		__globalMarkIntervalStartTimeOffset_ = 0;
		__globalMarkOverheadOffset_ = 0;
		__globalSweepRequiredOffset_ = 0;
		__globalSweepTimeUsOffset_ = 0;
		__heapOccupancyTrendOffset_ = 0;
		__historicBytesScannedConcurrentlyPerGMPOffset_ = 0;
		__historicTotalIncrementalScanTimePerGMPOffset_ = 0;
		__historicalPartialGCTimeOffset_ = 0;
		__idealEdenRegionCountOffset_ = 0;
		__liveSetBytesAfterGlobalSweepOffset_ = 0;
		__liveSetBytesAfterPartialCollectOffset_ = 0;
		__liveSetBytesBeforeGlobalSweepOffset_ = 0;
		__maxEdenRegionCountOffset_ = 0;
		__minEdenRegionCountOffset_ = 0;
		__minimumEdenRegionCountOffset_ = 0;
		__nextIncrementWillDoGlobalMarkPhaseOffset_ = 0;
		__nextIncrementWillDoPartialGarbageCollectionOffset_ = 0;
		__nextPGCShouldCopyForwardOffset_ = 0;
		__nonEdenSurvivalCountCopyForwardOffset_ = 0;
		__numberOfHeapRegionsOffset_ = 0;
		__partialGcOverheadOffset_ = 0;
		__partialGcStartTimeOffset_ = 0;
		__pgcCountSinceGMPEndOffset_ = 0;
		__pgcTimeIncreasePerEdenFactorOffset_ = 0;
		__previousDefragmentReclaimableRegionsOffset_ = 0;
		__previousLiveSetBytesAfterGlobalSweepOffset_ = 0;
		__previousReclaimableRegionsOffset_ = 0;
		__recentPartialGCTimeOffset_ = 0;
		__regionConsumptionRateOffset_ = 0;
		__regionManagerOffset_ = 0;
		__remainingGMPIntermissionIntervalsOffset_ = 0;
		__scanRateStatsOffset_ = 0;
		__scannableBytesRatioOffset_ = 0;
		__taxationIndexOffset_ = 0;
		__totalGMPWorkTimeUsOffset_ = 0;
	}

}
