/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _pcredPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _pcredPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_pcred.class)
public class _pcredPointer extends StructurePointer {

	// NULL
	public static final _pcredPointer NULL = new _pcredPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _pcredPointer(long address) {
		super(address);
	}

	public static _pcredPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _pcredPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _pcredPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _pcredPointer(address);
	}

	public _pcredPointer add(long count) {
		return _pcredPointer.cast(address + (_pcred.SIZEOF * count));
	}

	public _pcredPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _pcredPointer addOffset(long offset) {
		return _pcredPointer.cast(address + offset);
	}

	public _pcredPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _pcredPointer sub(long count) {
		return _pcredPointer.cast(address - (_pcred.SIZEOF * count));
	}

	public _pcredPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _pcredPointer subOffset(long offset) {
		return _pcredPointer.cast(address - offset);
	}

	public _pcredPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _pcredPointer untag(long mask) {
		return _pcredPointer.cast(address & ~mask);
	}

	public _pcredPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _pcred.SIZEOF;
	}

	// Implementation methods

	// I32 p_refcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_refcntOffset_", declaredType="I32")
	public IDATA p_refcnt() throws CorruptDataException {
		return new I32(getIntAtOffset(_pcred._p_refcntOffset_));
	}

	// I32 p_refcnt
	public IDATAPointer p_refcntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_pcred._p_refcntOffset_));
	}

	// gid_t p_rgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_rgidOffset_", declaredType="gid_t")
	public UDATA p_rgid() throws CorruptDataException {
		return new U32(getIntAtOffset(_pcred._p_rgidOffset_));
	}

	// gid_t p_rgid
	public UDATAPointer p_rgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pcred._p_rgidOffset_));
	}

	// uid_t p_ruid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_ruidOffset_", declaredType="uid_t")
	public UDATA p_ruid() throws CorruptDataException {
		return new U32(getIntAtOffset(_pcred._p_ruidOffset_));
	}

	// uid_t p_ruid
	public UDATAPointer p_ruidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pcred._p_ruidOffset_));
	}

	// gid_t p_svgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_svgidOffset_", declaredType="gid_t")
	public UDATA p_svgid() throws CorruptDataException {
		return new U32(getIntAtOffset(_pcred._p_svgidOffset_));
	}

	// gid_t p_svgid
	public UDATAPointer p_svgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pcred._p_svgidOffset_));
	}

	// uid_t p_svuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_svuidOffset_", declaredType="uid_t")
	public UDATA p_svuid() throws CorruptDataException {
		return new U32(getIntAtOffset(_pcred._p_svuidOffset_));
	}

	// uid_t p_svuid
	public UDATAPointer p_svuidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_pcred._p_svuidOffset_));
	}

	// U8[] pc_lock
	public U8Pointer pc_lockEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_pcred._pc_lockOffset_));
	}

	// ucred* pc_ucred
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pc_ucredOffset_", declaredType="ucred*")
	public ucredPointer pc_ucred() throws CorruptDataException {
		return ucredPointer.cast(getPointerAtOffset(_pcred._pc_ucredOffset_));
	}

	// ucred* pc_ucred
	public PointerPointer pc_ucredEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_pcred._pc_ucredOffset_));
	}

}
