/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: arg_statePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the arg_statePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=arg_state.class)
public class arg_statePointer extends StructurePointer {

	// NULL
	public static final arg_statePointer NULL = new arg_statePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected arg_statePointer(long address) {
		super(address);
	}

	public static arg_statePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static arg_statePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static arg_statePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new arg_statePointer(address);
	}

	public arg_statePointer add(long count) {
		return arg_statePointer.cast(address + (arg_state.SIZEOF * count));
	}

	public arg_statePointer add(Scalar count) {
		return add(count.longValue());
	}

	public arg_statePointer addOffset(long offset) {
		return arg_statePointer.cast(address + offset);
	}

	public arg_statePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public arg_statePointer sub(long count) {
		return arg_statePointer.cast(address - (arg_state.SIZEOF * count));
	}

	public arg_statePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public arg_statePointer subOffset(long offset) {
		return arg_statePointer.cast(address - offset);
	}

	public arg_statePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public arg_statePointer untag(long mask) {
		return arg_statePointer.cast(address & ~mask);
	}

	public arg_statePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return arg_state.SIZEOF;
	}

	// Implementation methods

	// U32 allocating_variadic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_allocating_variadicOffset_", declaredType="U32")
	public UDATA allocating_variadic() throws CorruptDataException {
		return new U32(getIntAtOffset(arg_state._allocating_variadicOffset_));
	}

	// U32 allocating_variadic
	public UDATAPointer allocating_variadicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(arg_state._allocating_variadicOffset_));
	}

	// size_t next_struct_area
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_next_struct_areaOffset_", declaredType="size_t")
	public UDATA next_struct_area() throws CorruptDataException {
		return new U64(getLongAtOffset(arg_state._next_struct_areaOffset_));
	}

	// size_t next_struct_area
	public UDATAPointer next_struct_areaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(arg_state._next_struct_areaOffset_));
	}

	// U32 ngrn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ngrnOffset_", declaredType="U32")
	public UDATA ngrn() throws CorruptDataException {
		return new U32(getIntAtOffset(arg_state._ngrnOffset_));
	}

	// U32 ngrn
	public UDATAPointer ngrnEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(arg_state._ngrnOffset_));
	}

	// size_t nsaa
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nsaaOffset_", declaredType="size_t")
	public UDATA nsaa() throws CorruptDataException {
		return new U64(getLongAtOffset(arg_state._nsaaOffset_));
	}

	// size_t nsaa
	public UDATAPointer nsaaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(arg_state._nsaaOffset_));
	}

	// U32 nsrn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nsrnOffset_", declaredType="U32")
	public UDATA nsrn() throws CorruptDataException {
		return new U32(getIntAtOffset(arg_state._nsrnOffset_));
	}

	// U32 nsrn
	public UDATAPointer nsrnEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(arg_state._nsrnOffset_));
	}

}
