/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: extern_procPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the extern_procPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=extern_proc.class)
public class extern_procPointer extends StructurePointer {

	// NULL
	public static final extern_procPointer NULL = new extern_procPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected extern_procPointer(long address) {
		super(address);
	}

	public static extern_procPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static extern_procPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static extern_procPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new extern_procPointer(address);
	}

	public extern_procPointer add(long count) {
		return extern_procPointer.cast(address + (extern_proc.SIZEOF * count));
	}

	public extern_procPointer add(Scalar count) {
		return add(count.longValue());
	}

	public extern_procPointer addOffset(long offset) {
		return extern_procPointer.cast(address + offset);
	}

	public extern_procPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public extern_procPointer sub(long count) {
		return extern_procPointer.cast(address - (extern_proc.SIZEOF * count));
	}

	public extern_procPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public extern_procPointer subOffset(long offset) {
		return extern_procPointer.cast(address - offset);
	}

	public extern_procPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public extern_procPointer untag(long mask) {
		return extern_procPointer.cast(address & ~mask);
	}

	public extern_procPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return extern_proc.SIZEOF;
	}

	// Implementation methods

	// void* exit_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exit_threadOffset_", declaredType="void*")
	public VoidPointer exit_thread() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(extern_proc._exit_threadOffset_));
	}

	// void* exit_thread
	public PointerPointer exit_threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._exit_threadOffset_));
	}

	// u_short p_acflag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_acflagOffset_", declaredType="u_short")
	public U16 p_acflag() throws CorruptDataException {
		return new U16(getShortAtOffset(extern_proc._p_acflagOffset_));
	}

	// u_short p_acflag
	public U16Pointer p_acflagEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(extern_proc._p_acflagOffset_));
	}

	// user* p_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_addrOffset_", declaredType="user*")
	public userPointer p_addr() throws CorruptDataException {
		return userPointer.cast(getPointerAtOffset(extern_proc._p_addrOffset_));
	}

	// user* p_addr
	public PointerPointer p_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_addrOffset_));
	}

	// U8[] p_comm
	public U8Pointer p_commEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(extern_proc._p_commOffset_));
	}

	// I32 p_cpticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_cpticksOffset_", declaredType="I32")
	public IDATA p_cpticks() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_cpticksOffset_));
	}

	// I32 p_cpticks
	public IDATAPointer p_cpticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_cpticksOffset_));
	}

	// I32 p_debugger
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_debuggerOffset_", declaredType="I32")
	public IDATA p_debugger() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_debuggerOffset_));
	}

	// I32 p_debugger
	public IDATAPointer p_debuggerEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_debuggerOffset_));
	}

	// I32 p_dupfd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_dupfdOffset_", declaredType="I32")
	public IDATA p_dupfd() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_dupfdOffset_));
	}

	// I32 p_dupfd
	public IDATAPointer p_dupfdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_dupfdOffset_));
	}

	// u_int p_estcpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_estcpuOffset_", declaredType="u_int")
	public UDATA p_estcpu() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_estcpuOffset_));
	}

	// u_int p_estcpu
	public UDATAPointer p_estcpuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_estcpuOffset_));
	}

	// I32 p_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_flagOffset_", declaredType="I32")
	public IDATA p_flag() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_flagOffset_));
	}

	// I32 p_flag
	public IDATAPointer p_flagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_flagOffset_));
	}

	// I32 p_holdcnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_holdcntOffset_", declaredType="I32")
	public IDATA p_holdcnt() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_holdcntOffset_));
	}

	// I32 p_holdcnt
	public IDATAPointer p_holdcntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_holdcntOffset_));
	}

	// u_quad_t p_iticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_iticksOffset_", declaredType="u_quad_t")
	public UDATA p_iticks() throws CorruptDataException {
		return new U64(getLongAtOffset(extern_proc._p_iticksOffset_));
	}

	// u_quad_t p_iticks
	public UDATAPointer p_iticksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_iticksOffset_));
	}

	// U8 p_nice
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_niceOffset_", declaredType="U8")
	public U8 p_nice() throws CorruptDataException {
		return new U8(getByteAtOffset(extern_proc._p_niceOffset_));
	}

	// U8 p_nice
	public U8Pointer p_niceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(extern_proc._p_niceOffset_));
	}

	// pid_t p_oppid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_oppidOffset_", declaredType="pid_t")
	public IDATA p_oppid() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_oppidOffset_));
	}

	// pid_t p_oppid
	public IDATAPointer p_oppidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_oppidOffset_));
	}

	// fixpt_t p_pctcpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_pctcpuOffset_", declaredType="fixpt_t")
	public UDATA p_pctcpu() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_pctcpuOffset_));
	}

	// fixpt_t p_pctcpu
	public UDATAPointer p_pctcpuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_pctcpuOffset_));
	}

	// pgrp* p_pgrp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_pgrpOffset_", declaredType="pgrp*")
	public pgrpPointer p_pgrp() throws CorruptDataException {
		return pgrpPointer.cast(getPointerAtOffset(extern_proc._p_pgrpOffset_));
	}

	// pgrp* p_pgrp
	public PointerPointer p_pgrpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_pgrpOffset_));
	}

	// pid_t p_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_pidOffset_", declaredType="pid_t")
	public IDATA p_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_pidOffset_));
	}

	// pid_t p_pid
	public IDATAPointer p_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_pidOffset_));
	}

	// u_char p_priority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_priorityOffset_", declaredType="u_char")
	public U8 p_priority() throws CorruptDataException {
		return new U8(getByteAtOffset(extern_proc._p_priorityOffset_));
	}

	// u_char p_priority
	public U8Pointer p_priorityEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(extern_proc._p_priorityOffset_));
	}

	// itimerval p_realtimer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_realtimerOffset_", declaredType="itimerval")
	public itimervalPointer p_realtimer() throws CorruptDataException {
		return itimervalPointer.cast(nonNullFieldEA(extern_proc._p_realtimerOffset_));
	}

	// itimerval p_realtimer
	public PointerPointer p_realtimerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_realtimerOffset_));
	}

	// timeval p_rtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_rtimeOffset_", declaredType="timeval")
	public timevalPointer p_rtime() throws CorruptDataException {
		return timevalPointer.cast(nonNullFieldEA(extern_proc._p_rtimeOffset_));
	}

	// timeval p_rtime
	public PointerPointer p_rtimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_rtimeOffset_));
	}

	// rusage* p_ru
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_ruOffset_", declaredType="rusage*")
	public rusagePointer p_ru() throws CorruptDataException {
		return rusagePointer.cast(getPointerAtOffset(extern_proc._p_ruOffset_));
	}

	// rusage* p_ru
	public PointerPointer p_ruEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_ruOffset_));
	}

	// sigacts* p_sigacts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigactsOffset_", declaredType="sigacts*")
	public sigactsPointer p_sigacts() throws CorruptDataException {
		return sigactsPointer.cast(getPointerAtOffset(extern_proc._p_sigactsOffset_));
	}

	// sigacts* p_sigacts
	public PointerPointer p_sigactsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_sigactsOffset_));
	}

	// sigset_t p_sigcatch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigcatchOffset_", declaredType="sigset_t")
	public UDATA p_sigcatch() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_sigcatchOffset_));
	}

	// sigset_t p_sigcatch
	public UDATAPointer p_sigcatchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_sigcatchOffset_));
	}

	// sigset_t p_sigignore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigignoreOffset_", declaredType="sigset_t")
	public UDATA p_sigignore() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_sigignoreOffset_));
	}

	// sigset_t p_sigignore
	public UDATAPointer p_sigignoreEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_sigignoreOffset_));
	}

	// I32 p_siglist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_siglistOffset_", declaredType="I32")
	public IDATA p_siglist() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_siglistOffset_));
	}

	// I32 p_siglist
	public IDATAPointer p_siglistEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_siglistOffset_));
	}

	// sigset_t p_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sigmaskOffset_", declaredType="sigset_t")
	public UDATA p_sigmask() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_sigmaskOffset_));
	}

	// sigset_t p_sigmask
	public UDATAPointer p_sigmaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_sigmaskOffset_));
	}

	// u_int p_slptime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_slptimeOffset_", declaredType="u_int")
	public UDATA p_slptime() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_slptimeOffset_));
	}

	// u_int p_slptime
	public UDATAPointer p_slptimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_slptimeOffset_));
	}

	// U8 p_stat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_statOffset_", declaredType="U8")
	public U8 p_stat() throws CorruptDataException {
		return new U8(getByteAtOffset(extern_proc._p_statOffset_));
	}

	// U8 p_stat
	public U8Pointer p_statEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(extern_proc._p_statOffset_));
	}

	// u_quad_t p_sticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sticksOffset_", declaredType="u_quad_t")
	public UDATA p_sticks() throws CorruptDataException {
		return new U64(getLongAtOffset(extern_proc._p_sticksOffset_));
	}

	// u_quad_t p_sticks
	public UDATAPointer p_sticksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_sticksOffset_));
	}

	// u_int p_swtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_swtimeOffset_", declaredType="u_int")
	public UDATA p_swtime() throws CorruptDataException {
		return new U32(getIntAtOffset(extern_proc._p_swtimeOffset_));
	}

	// u_int p_swtime
	public UDATAPointer p_swtimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_swtimeOffset_));
	}

	// vnode* p_textvp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_textvpOffset_", declaredType="vnode*")
	public vnodePointer p_textvp() throws CorruptDataException {
		return vnodePointer.cast(getPointerAtOffset(extern_proc._p_textvpOffset_));
	}

	// vnode* p_textvp
	public PointerPointer p_textvpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_textvpOffset_));
	}

	// I32 p_traceflag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_traceflagOffset_", declaredType="I32")
	public IDATA p_traceflag() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._p_traceflagOffset_));
	}

	// I32 p_traceflag
	public IDATAPointer p_traceflagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._p_traceflagOffset_));
	}

	// vnode* p_tracep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_tracepOffset_", declaredType="vnode*")
	public vnodePointer p_tracep() throws CorruptDataException {
		return vnodePointer.cast(getPointerAtOffset(extern_proc._p_tracepOffset_));
	}

	// vnode* p_tracep
	public PointerPointer p_tracepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_tracepOffset_));
	}

	// timeval p_un.__p_starttime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_un$__p_starttimeOffset_", declaredType="timeval")
	public timevalPointer p_un$__p_starttime() throws CorruptDataException {
		return timevalPointer.cast(nonNullFieldEA(extern_proc._p_un$__p_starttimeOffset_));
	}

	// timeval p_un.__p_starttime
	public PointerPointer p_un$__p_starttimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_un$__p_starttimeOffset_));
	}

	// proc* p_un.p_st1.__p_back
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_un$p_st1$__p_backOffset_", declaredType="proc*")
	public procPointer p_un$p_st1$__p_back() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(extern_proc._p_un$p_st1$__p_backOffset_));
	}

	// proc* p_un.p_st1.__p_back
	public PointerPointer p_un$p_st1$__p_backEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_un$p_st1$__p_backOffset_));
	}

	// proc* p_un.p_st1.__p_forw
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_un$p_st1$__p_forwOffset_", declaredType="proc*")
	public procPointer p_un$p_st1$__p_forw() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(extern_proc._p_un$p_st1$__p_forwOffset_));
	}

	// proc* p_un.p_st1.__p_forw
	public PointerPointer p_un$p_st1$__p_forwEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_un$p_st1$__p_forwOffset_));
	}

	// u_char p_usrpri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_usrpriOffset_", declaredType="u_char")
	public U8 p_usrpri() throws CorruptDataException {
		return new U8(getByteAtOffset(extern_proc._p_usrpriOffset_));
	}

	// u_char p_usrpri
	public U8Pointer p_usrpriEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(extern_proc._p_usrpriOffset_));
	}

	// u_quad_t p_uticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_uticksOffset_", declaredType="u_quad_t")
	public UDATA p_uticks() throws CorruptDataException {
		return new U64(getLongAtOffset(extern_proc._p_uticksOffset_));
	}

	// u_quad_t p_uticks
	public UDATAPointer p_uticksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(extern_proc._p_uticksOffset_));
	}

	// vmspace* p_vmspace
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_vmspaceOffset_", declaredType="vmspace*")
	public vmspacePointer p_vmspace() throws CorruptDataException {
		return vmspacePointer.cast(getPointerAtOffset(extern_proc._p_vmspaceOffset_));
	}

	// vmspace* p_vmspace
	public PointerPointer p_vmspaceEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_vmspaceOffset_));
	}

	// void* p_wchan
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_wchanOffset_", declaredType="void*")
	public VoidPointer p_wchan() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(extern_proc._p_wchanOffset_));
	}

	// void* p_wchan
	public PointerPointer p_wchanEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_wchanOffset_));
	}

	// U8* p_wmesg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_wmesgOffset_", declaredType="U8*")
	public U8Pointer p_wmesg() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(extern_proc._p_wmesgOffset_));
	}

	// U8* p_wmesg
	public PointerPointer p_wmesgEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._p_wmesgOffset_));
	}

	// u_short p_xstat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_xstatOffset_", declaredType="u_short")
	public U16 p_xstat() throws CorruptDataException {
		return new U16(getShortAtOffset(extern_proc._p_xstatOffset_));
	}

	// u_short p_xstat
	public U16Pointer p_xstatEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(extern_proc._p_xstatOffset_));
	}

	// boolean_t sigwait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigwaitOffset_", declaredType="boolean_t")
	public IDATA sigwait() throws CorruptDataException {
		return new I32(getIntAtOffset(extern_proc._sigwaitOffset_));
	}

	// boolean_t sigwait
	public IDATAPointer sigwaitEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(extern_proc._sigwaitOffset_));
	}

	// caddr_t user_stack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_user_stackOffset_", declaredType="caddr_t")
	public U8Pointer user_stack() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(extern_proc._user_stackOffset_));
	}

	// caddr_t user_stack
	public PointerPointer user_stackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(extern_proc._user_stackOffset_));
	}

}
