/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: segment_command_64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the segment_command_64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=segment_command_64.class)
public class segment_command_64Pointer extends StructurePointer {

	// NULL
	public static final segment_command_64Pointer NULL = new segment_command_64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected segment_command_64Pointer(long address) {
		super(address);
	}

	public static segment_command_64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static segment_command_64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static segment_command_64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new segment_command_64Pointer(address);
	}

	public segment_command_64Pointer add(long count) {
		return segment_command_64Pointer.cast(address + (segment_command_64.SIZEOF * count));
	}

	public segment_command_64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public segment_command_64Pointer addOffset(long offset) {
		return segment_command_64Pointer.cast(address + offset);
	}

	public segment_command_64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public segment_command_64Pointer sub(long count) {
		return segment_command_64Pointer.cast(address - (segment_command_64.SIZEOF * count));
	}

	public segment_command_64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public segment_command_64Pointer subOffset(long offset) {
		return segment_command_64Pointer.cast(address - offset);
	}

	public segment_command_64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public segment_command_64Pointer untag(long mask) {
		return segment_command_64Pointer.cast(address & ~mask);
	}

	public segment_command_64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return segment_command_64.SIZEOF;
	}

	// Implementation methods

	// U32 cmd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmdOffset_", declaredType="U32")
	public UDATA cmd() throws CorruptDataException {
		return new U32(getIntAtOffset(segment_command_64._cmdOffset_));
	}

	// U32 cmd
	public UDATAPointer cmdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._cmdOffset_));
	}

	// U32 cmdsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmdsizeOffset_", declaredType="U32")
	public UDATA cmdsize() throws CorruptDataException {
		return new U32(getIntAtOffset(segment_command_64._cmdsizeOffset_));
	}

	// U32 cmdsize
	public UDATAPointer cmdsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._cmdsizeOffset_));
	}

	// U64 fileoff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fileoffOffset_", declaredType="U64")
	public UDATA fileoff() throws CorruptDataException {
		return new U64(getLongAtOffset(segment_command_64._fileoffOffset_));
	}

	// U64 fileoff
	public UDATAPointer fileoffEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._fileoffOffset_));
	}

	// U64 filesize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_filesizeOffset_", declaredType="U64")
	public UDATA filesize() throws CorruptDataException {
		return new U64(getLongAtOffset(segment_command_64._filesizeOffset_));
	}

	// U64 filesize
	public UDATAPointer filesizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._filesizeOffset_));
	}

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(segment_command_64._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._flagsOffset_));
	}

	// I32 initprot
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_initprotOffset_", declaredType="I32")
	public IDATA initprot() throws CorruptDataException {
		return new I32(getIntAtOffset(segment_command_64._initprotOffset_));
	}

	// I32 initprot
	public IDATAPointer initprotEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(segment_command_64._initprotOffset_));
	}

	// I32 maxprot
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxprotOffset_", declaredType="I32")
	public IDATA maxprot() throws CorruptDataException {
		return new I32(getIntAtOffset(segment_command_64._maxprotOffset_));
	}

	// I32 maxprot
	public IDATAPointer maxprotEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(segment_command_64._maxprotOffset_));
	}

	// U32 nsects
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nsectsOffset_", declaredType="U32")
	public UDATA nsects() throws CorruptDataException {
		return new U32(getIntAtOffset(segment_command_64._nsectsOffset_));
	}

	// U32 nsects
	public UDATAPointer nsectsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._nsectsOffset_));
	}

	// U8[] segname
	public U8Pointer segnameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(segment_command_64._segnameOffset_));
	}

	// U64 vmaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmaddrOffset_", declaredType="U64")
	public UDATA vmaddr() throws CorruptDataException {
		return new U64(getLongAtOffset(segment_command_64._vmaddrOffset_));
	}

	// U64 vmaddr
	public UDATAPointer vmaddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._vmaddrOffset_));
	}

	// U64 vmsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsizeOffset_", declaredType="U64")
	public UDATA vmsize() throws CorruptDataException {
		return new U64(getLongAtOffset(segment_command_64._vmsizeOffset_));
	}

	// U64 vmsize
	public UDATAPointer vmsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(segment_command_64._vmsizeOffset_));
	}

}
