/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JavaAccessFlags
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JavaAccessFlags {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9AccAbstract;
	public static final long J9AccAnnotation;
	public static final long J9AccBridge;
	public static final long J9AccClassAnnnotionRefersDoubleSlotEntry;
	public static final long J9AccClassAnonClass;
	public static final long J9AccClassArray;
	public static final long J9AccClassBytecodesModified;
	public static final long J9AccClassCloneable;
	public static final long J9AccClassCompatibilityMask;
	public static final long J9AccClassDepthMask;
	public static final long J9AccClassDying;
	public static final long J9AccClassFinalizeNeeded;
	public static final long J9AccClassGCSpecial;
	public static final long J9AccClassHasBeenOverridden;
	public static final long J9AccClassHasClinit;
	public static final long J9AccClassHasEmptyFinalize;
	public static final long J9AccClassHasFinalFields;
	public static final long J9AccClassHasIdentity;
	public static final long J9AccClassHasJDBCNatives;
	public static final long J9AccClassHasNonStaticNonAbstractMethods;
	public static final long J9AccClassHasVerifyData;
	public static final long J9AccClassHotSwappedOut;
	public static final long J9AccClassInnerClass;
	public static final long J9AccClassIntermediateDataIsClassfile;
	public static final long J9AccClassInternalPrimitiveType;
	public static final long J9AccClassIsContended;
	public static final long J9AccClassIsUnmodifiable;
	public static final long J9AccClassOwnableSynchronizer;
	public static final long J9AccClassRAMArray;
	public static final long J9AccClassRAMShapeShift;
	public static final long J9AccClassReferenceMask;
	public static final long J9AccClassReferencePhantom;
	public static final long J9AccClassReferenceSoft;
	public static final long J9AccClassReferenceWeak;
	public static final long J9AccClassRomToRamMask;
	public static final long J9AccClassUnsafe;
	public static final long J9AccClassUseBisectionSearch;
	public static final long J9AccEmptyMethod;
	public static final long J9AccEnum;
	public static final long J9AccFinal;
	public static final long J9AccGetterMethod;
	public static final long J9AccInterface;
	public static final long J9AccMethodCallerSensitive;
	public static final long J9AccMethodFrameIteratorSkip;
	public static final long J9AccMethodHasBackwardBranches;
	public static final long J9AccMethodHasDebugInfo;
	public static final long J9AccMethodHasDefaultAnnotation;
	public static final long J9AccMethodHasExceptionInfo;
	public static final long J9AccMethodHasExtendedModifiers;
	public static final long J9AccMethodHasGenericSignature;
	public static final long J9AccMethodHasMethodAnnotations;
	public static final long J9AccMethodHasMethodHandleInvokes;
	public static final long J9AccMethodHasMethodParameters;
	public static final long J9AccMethodHasParameterAnnotations;
	public static final long J9AccMethodHasStackMap;
	public static final long J9AccMethodHasTypeAnnotations;
	public static final long J9AccMethodObjectConstructor;
	public static final long J9AccMethodReturn0;
	public static final long J9AccMethodReturn1;
	public static final long J9AccMethodReturn2;
	public static final long J9AccMethodReturnA;
	public static final long J9AccMethodReturnD;
	public static final long J9AccMethodReturnF;
	public static final long J9AccMethodReturnMask;
	public static final long J9AccMethodReturnShift;
	public static final long J9AccMethodVTable;
	public static final long J9AccNative;
	public static final long J9AccPrivate;
	public static final long J9AccProtected;
	public static final long J9AccPublic;
	public static final long J9AccRecord;
	public static final long J9AccSealed;
	public static final long J9AccStatic;
	public static final long J9AccStrict;
	public static final long J9AccSuper;
	public static final long J9AccSynchronized;
	public static final long J9AccSynthetic;
	public static final long J9AccTransient;
	public static final long J9AccVarArgs;
	public static final long J9AccVolatile;
	public static final long J9PutfieldNarrowing;
	public static final long J9StaticFieldRefBaseType;
	public static final long J9StaticFieldRefBoolean;
	public static final long J9StaticFieldRefDouble;
	public static final long J9StaticFieldRefFlagBits;
	public static final long J9StaticFieldRefNullRestricted;
	public static final long J9StaticFieldRefPutResolved;
	public static final long J9StaticFieldRefTypeBoolean;
	public static final long J9StaticFieldRefTypeByte;
	public static final long J9StaticFieldRefTypeChar;
	public static final long J9StaticFieldRefTypeIntFloat;
	public static final long J9StaticFieldRefTypeLongDouble;
	public static final long J9StaticFieldRefTypeMask;
	public static final long J9StaticFieldRefTypeObject;
	public static final long J9StaticFieldRefTypeShort;
	public static final long J9StaticFieldRefVolatile;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9AccAbstract = 0;
		J9AccAnnotation = 0;
		J9AccBridge = 0;
		J9AccClassAnnnotionRefersDoubleSlotEntry = 0;
		J9AccClassAnonClass = 0;
		J9AccClassArray = 0;
		J9AccClassBytecodesModified = 0;
		J9AccClassCloneable = 0;
		J9AccClassCompatibilityMask = 0;
		J9AccClassDepthMask = 0;
		J9AccClassDying = 0;
		J9AccClassFinalizeNeeded = 0;
		J9AccClassGCSpecial = 0;
		J9AccClassHasBeenOverridden = 0;
		J9AccClassHasClinit = 0;
		J9AccClassHasEmptyFinalize = 0;
		J9AccClassHasFinalFields = 0;
		J9AccClassHasIdentity = 0;
		J9AccClassHasJDBCNatives = 0;
		J9AccClassHasNonStaticNonAbstractMethods = 0;
		J9AccClassHasVerifyData = 0;
		J9AccClassHotSwappedOut = 0;
		J9AccClassInnerClass = 0;
		J9AccClassIntermediateDataIsClassfile = 0;
		J9AccClassInternalPrimitiveType = 0;
		J9AccClassIsContended = 0;
		J9AccClassIsUnmodifiable = 0;
		J9AccClassOwnableSynchronizer = 0;
		J9AccClassRAMArray = 0;
		J9AccClassRAMShapeShift = 0;
		J9AccClassReferenceMask = 0;
		J9AccClassReferencePhantom = 0;
		J9AccClassReferenceSoft = 0;
		J9AccClassReferenceWeak = 0;
		J9AccClassRomToRamMask = 0;
		J9AccClassUnsafe = 0;
		J9AccClassUseBisectionSearch = 0;
		J9AccEmptyMethod = 0;
		J9AccEnum = 0;
		J9AccFinal = 0;
		J9AccGetterMethod = 0;
		J9AccInterface = 0;
		J9AccMethodCallerSensitive = 0;
		J9AccMethodFrameIteratorSkip = 0;
		J9AccMethodHasBackwardBranches = 0;
		J9AccMethodHasDebugInfo = 0;
		J9AccMethodHasDefaultAnnotation = 0;
		J9AccMethodHasExceptionInfo = 0;
		J9AccMethodHasExtendedModifiers = 0;
		J9AccMethodHasGenericSignature = 0;
		J9AccMethodHasMethodAnnotations = 0;
		J9AccMethodHasMethodHandleInvokes = 0;
		J9AccMethodHasMethodParameters = 0;
		J9AccMethodHasParameterAnnotations = 0;
		J9AccMethodHasStackMap = 0;
		J9AccMethodHasTypeAnnotations = 0;
		J9AccMethodObjectConstructor = 0;
		J9AccMethodReturn0 = 0;
		J9AccMethodReturn1 = 0;
		J9AccMethodReturn2 = 0;
		J9AccMethodReturnA = 0;
		J9AccMethodReturnD = 0;
		J9AccMethodReturnF = 0;
		J9AccMethodReturnMask = 0;
		J9AccMethodReturnShift = 0;
		J9AccMethodVTable = 0;
		J9AccNative = 0;
		J9AccPrivate = 0;
		J9AccProtected = 0;
		J9AccPublic = 0;
		J9AccRecord = 0;
		J9AccSealed = 0;
		J9AccStatic = 0;
		J9AccStrict = 0;
		J9AccSuper = 0;
		J9AccSynchronized = 0;
		J9AccSynthetic = 0;
		J9AccTransient = 0;
		J9AccVarArgs = 0;
		J9AccVolatile = 0;
		J9PutfieldNarrowing = 0;
		J9StaticFieldRefBaseType = 0;
		J9StaticFieldRefBoolean = 0;
		J9StaticFieldRefDouble = 0;
		J9StaticFieldRefFlagBits = 0;
		J9StaticFieldRefNullRestricted = 0;
		J9StaticFieldRefPutResolved = 0;
		J9StaticFieldRefTypeBoolean = 0;
		J9StaticFieldRefTypeByte = 0;
		J9StaticFieldRefTypeChar = 0;
		J9StaticFieldRefTypeIntFloat = 0;
		J9StaticFieldRefTypeLongDouble = 0;
		J9StaticFieldRefTypeMask = 0;
		J9StaticFieldRefTypeObject = 0;
		J9StaticFieldRefTypeShort = 0;
		J9StaticFieldRefVolatile = 0;
	}

}
