/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __tm_contextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __tm_contextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__tm_context.class)
public class __tm_contextPointer extends StructurePointer {

	// NULL
	public static final __tm_contextPointer NULL = new __tm_contextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __tm_contextPointer(long address) {
		super(address);
	}

	public static __tm_contextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __tm_contextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __tm_contextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __tm_contextPointer(address);
	}

	public __tm_contextPointer add(long count) {
		return __tm_contextPointer.cast(address + (__tm_context.SIZEOF * count));
	}

	public __tm_contextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __tm_contextPointer addOffset(long offset) {
		return __tm_contextPointer.cast(address + offset);
	}

	public __tm_contextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __tm_contextPointer sub(long count) {
		return __tm_contextPointer.cast(address - (__tm_context.SIZEOF * count));
	}

	public __tm_contextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __tm_contextPointer subOffset(long offset) {
		return __tm_contextPointer.cast(address - offset);
	}

	public __tm_contextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __tm_contextPointer untag(long mask) {
		return __tm_contextPointer.cast(address & ~mask);
	}

	public __tm_contextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __tm_context.SIZEOF;
	}

	// Implementation methods

	// U64 amr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_amrOffset_", declaredType="U64")
	public UDATA amr() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._amrOffset_));
	}

	// U64 amr
	public UDATAPointer amrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._amrOffset_));
	}

	// U32 cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crOffset_", declaredType="U32")
	public UDATA cr() throws CorruptDataException {
		return new U32(getIntAtOffset(__tm_context._crOffset_));
	}

	// U32 cr
	public UDATAPointer crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._crOffset_));
	}

	// U64 ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctrOffset_", declaredType="U64")
	public UDATA ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._ctrOffset_));
	}

	// U64 ctr
	public UDATAPointer ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._ctrOffset_));
	}

	// U64 dscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dscrOffset_", declaredType="U64")
	public UDATA dscr() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._dscrOffset_));
	}

	// U64 dscr
	public UDATAPointer dscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._dscrOffset_));
	}

	// double[] fpr
	public DoublePointer fprEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(__tm_context._fprOffset_));
	}

	// U32 fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrOffset_", declaredType="U32")
	public UDATA fpscr() throws CorruptDataException {
		return new U32(getIntAtOffset(__tm_context._fpscrOffset_));
	}

	// U32 fpscr
	public UDATAPointer fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._fpscrOffset_));
	}

	// U32 fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrxOffset_", declaredType="U32")
	public UDATA fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(__tm_context._fpscrxOffset_));
	}

	// U32 fpscrx
	public UDATAPointer fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._fpscrxOffset_));
	}

	// U64[] gpr
	public UDATAPointer gprEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(__tm_context._gprOffset_));
	}

	// U64 lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lrOffset_", declaredType="U64")
	public UDATA lr() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._lrOffset_));
	}

	// U64 lr
	public UDATAPointer lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._lrOffset_));
	}

	// U8[] pad
	public U8Pointer padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__tm_context._padOffset_));
	}

	// U64 ppr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pprOffset_", declaredType="U64")
	public UDATA ppr() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._pprOffset_));
	}

	// U64 ppr
	public UDATAPointer pprEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._pprOffset_));
	}

	// U8 prevowner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevownerOffset_", declaredType="U8")
	public U8 prevowner() throws CorruptDataException {
		return new U8(getByteAtOffset(__tm_context._prevownerOffset_));
	}

	// U8 prevowner
	public U8Pointer prevownerEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__tm_context._prevownerOffset_));
	}

	// U64 tar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tarOffset_", declaredType="U64")
	public UDATA tar() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._tarOffset_));
	}

	// U64 tar
	public UDATAPointer tarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._tarOffset_));
	}

	// U64 texasr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_texasrOffset_", declaredType="U64")
	public UDATA texasr() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._texasrOffset_));
	}

	// U64 texasr
	public UDATAPointer texasrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._texasrOffset_));
	}

	// U64 tfhar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tfharOffset_", declaredType="U64")
	public UDATA tfhar() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._tfharOffset_));
	}

	// U64 tfhar
	public UDATAPointer tfharEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._tfharOffset_));
	}

	// U64 tfiar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tfiarOffset_", declaredType="U64")
	public UDATA tfiar() throws CorruptDataException {
		return new U64(getLongAtOffset(__tm_context._tfiarOffset_));
	}

	// U64 tfiar
	public UDATAPointer tfiarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._tfiarOffset_));
	}

	// U8 tmcontext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmcontextOffset_", declaredType="U8")
	public U8 tmcontext() throws CorruptDataException {
		return new U8(getByteAtOffset(__tm_context._tmcontextOffset_));
	}

	// U8 tmcontext
	public U8Pointer tmcontextEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__tm_context._tmcontextOffset_));
	}

	// U8 tmstate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmstateOffset_", declaredType="U8")
	public U8 tmstate() throws CorruptDataException {
		return new U8(getByteAtOffset(__tm_context._tmstateOffset_));
	}

	// U8 tmstate
	public U8Pointer tmstateEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__tm_context._tmstateOffset_));
	}

	// __vmx_context_t vmx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmxOffset_", declaredType="__vmx_context_t")
	public __vmx_contextPointer vmx() throws CorruptDataException {
		return __vmx_contextPointer.cast(nonNullFieldEA(__tm_context._vmxOffset_));
	}

	// __vmx_context_t vmx
	public PointerPointer vmxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__tm_context._vmxOffset_));
	}

	// __vsx_context_t vsx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vsxOffset_", declaredType="__vsx_context_t")
	public __vsx_contextPointer vsx() throws CorruptDataException {
		return __vsx_contextPointer.cast(nonNullFieldEA(__tm_context._vsxOffset_));
	}

	// __vsx_context_t vsx
	public PointerPointer vsxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__tm_context._vsxOffset_));
	}

	// U32 xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xerOffset_", declaredType="U32")
	public UDATA xer() throws CorruptDataException {
		return new U32(getIntAtOffset(__tm_context._xerOffset_));
	}

	// U32 xer
	public UDATAPointer xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__tm_context._xerOffset_));
	}

}
