/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9RASdumpAgent
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9RASdumpAgent {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9RAS_DUMP_DO_ATTACH_THREAD;
	public static final long J9RAS_DUMP_DO_COMPACT_HEAP;
	public static final long J9RAS_DUMP_DO_EXCLUSIVE_VM_ACCESS;
	public static final long J9RAS_DUMP_DO_MULTIPLE_HEAPS;
	public static final long J9RAS_DUMP_DO_PREEMPT_THREADS;
	public static final long J9RAS_DUMP_DO_PREPARE_HEAP_FOR_WALK;
	public static final long J9RAS_DUMP_DO_SUSPEND_OTHER_DUMPS;
	public static final long J9RAS_DUMP_ON_ABORT_SIGNAL;
	public static final long J9RAS_DUMP_ON_ANY;
	public static final long J9RAS_DUMP_ON_BREAKPOINT;
	public static final long J9RAS_DUMP_ON_CLASS_LOAD;
	public static final long J9RAS_DUMP_ON_CLASS_UNLOAD;
	public static final long J9RAS_DUMP_ON_CORRUPT_CACHE;
	public static final long J9RAS_DUMP_ON_DEBUG_FRAME_POP;
	public static final long J9RAS_DUMP_ON_EXCEPTION_CATCH;
	public static final long J9RAS_DUMP_ON_EXCEPTION_DESCRIBE;
	public static final long J9RAS_DUMP_ON_EXCEPTION_SYSTHROW;
	public static final long J9RAS_DUMP_ON_EXCEPTION_THROW;
	public static final long J9RAS_DUMP_ON_EXCESSIVE_GC;
	public static final long J9RAS_DUMP_ON_GLOBAL_GC;
	public static final long J9RAS_DUMP_ON_GP_FAULT;
	public static final long J9RAS_DUMP_ON_HEAP_EXPAND;
	public static final long J9RAS_DUMP_ON_OBJECT_ALLOCATION;
	public static final long J9RAS_DUMP_ON_SLOW_EXCLUSIVE_ENTER;
	public static final long J9RAS_DUMP_ON_THREAD_BLOCKED;
	public static final long J9RAS_DUMP_ON_THREAD_END;
	public static final long J9RAS_DUMP_ON_THREAD_START;
	public static final long J9RAS_DUMP_ON_TRACE_ASSERT;
	public static final long J9RAS_DUMP_ON_USER2_SIGNAL;
	public static final long J9RAS_DUMP_ON_USER_REQUEST;
	public static final long J9RAS_DUMP_ON_USER_SIGNAL;
	public static final long J9RAS_DUMP_ON_VM_SHUTDOWN;
	public static final long J9RAS_DUMP_ON_VM_STARTUP;

	// Offsets

	public static final int _countOffset_;
	public static final int _detailFilterOffset_;
	public static final int _dumpFnOffset_;
	public static final int _dumpOptionsOffset_;
	public static final int _eventMaskOffset_;
	public static final int _labelTemplateOffset_;
	public static final int _nextPtrOffset_;
	public static final int _prepStateOffset_;
	public static final int _priorityOffset_;
	public static final int _requestMaskOffset_;
	public static final int _shutdownFnOffset_;
	public static final int _startOnCountOffset_;
	public static final int _stopOnCountOffset_;
	public static final int _subFilterOffset_;
	public static final int _userDataOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9RAS_DUMP_DO_ATTACH_THREAD = 0;
		J9RAS_DUMP_DO_COMPACT_HEAP = 0;
		J9RAS_DUMP_DO_EXCLUSIVE_VM_ACCESS = 0;
		J9RAS_DUMP_DO_MULTIPLE_HEAPS = 0;
		J9RAS_DUMP_DO_PREEMPT_THREADS = 0;
		J9RAS_DUMP_DO_PREPARE_HEAP_FOR_WALK = 0;
		J9RAS_DUMP_DO_SUSPEND_OTHER_DUMPS = 0;
		J9RAS_DUMP_ON_ABORT_SIGNAL = 0;
		J9RAS_DUMP_ON_ANY = 0;
		J9RAS_DUMP_ON_BREAKPOINT = 0;
		J9RAS_DUMP_ON_CLASS_LOAD = 0;
		J9RAS_DUMP_ON_CLASS_UNLOAD = 0;
		J9RAS_DUMP_ON_CORRUPT_CACHE = 0;
		J9RAS_DUMP_ON_DEBUG_FRAME_POP = 0;
		J9RAS_DUMP_ON_EXCEPTION_CATCH = 0;
		J9RAS_DUMP_ON_EXCEPTION_DESCRIBE = 0;
		J9RAS_DUMP_ON_EXCEPTION_SYSTHROW = 0;
		J9RAS_DUMP_ON_EXCEPTION_THROW = 0;
		J9RAS_DUMP_ON_EXCESSIVE_GC = 0;
		J9RAS_DUMP_ON_GLOBAL_GC = 0;
		J9RAS_DUMP_ON_GP_FAULT = 0;
		J9RAS_DUMP_ON_HEAP_EXPAND = 0;
		J9RAS_DUMP_ON_OBJECT_ALLOCATION = 0;
		J9RAS_DUMP_ON_SLOW_EXCLUSIVE_ENTER = 0;
		J9RAS_DUMP_ON_THREAD_BLOCKED = 0;
		J9RAS_DUMP_ON_THREAD_END = 0;
		J9RAS_DUMP_ON_THREAD_START = 0;
		J9RAS_DUMP_ON_TRACE_ASSERT = 0;
		J9RAS_DUMP_ON_USER2_SIGNAL = 0;
		J9RAS_DUMP_ON_USER_REQUEST = 0;
		J9RAS_DUMP_ON_USER_SIGNAL = 0;
		J9RAS_DUMP_ON_VM_SHUTDOWN = 0;
		J9RAS_DUMP_ON_VM_STARTUP = 0;
		_countOffset_ = 0;
		_detailFilterOffset_ = 0;
		_dumpFnOffset_ = 0;
		_dumpOptionsOffset_ = 0;
		_eventMaskOffset_ = 0;
		_labelTemplateOffset_ = 0;
		_nextPtrOffset_ = 0;
		_prepStateOffset_ = 0;
		_priorityOffset_ = 0;
		_requestMaskOffset_ = 0;
		_shutdownFnOffset_ = 0;
		_startOnCountOffset_ = 0;
		_stopOnCountOffset_ = 0;
		_subFilterOffset_ = 0;
		_userDataOffset_ = 0;
	}

}
