/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: jvmtiEventCallbacks
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class jvmtiEventCallbacks {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _BreakpointOffset_;
	public static final int _ClassFileLoadHookOffset_;
	public static final int _ClassLoadOffset_;
	public static final int _ClassPrepareOffset_;
	public static final int _CompiledMethodLoadOffset_;
	public static final int _CompiledMethodUnloadOffset_;
	public static final int _DataDumpRequestOffset_;
	public static final int _DynamicCodeGeneratedOffset_;
	public static final int _ExceptionOffset_;
	public static final int _ExceptionCatchOffset_;
	public static final int _FieldAccessOffset_;
	public static final int _FieldModificationOffset_;
	public static final int _FramePopOffset_;
	public static final int _GarbageCollectionFinishOffset_;
	public static final int _GarbageCollectionStartOffset_;
	public static final int _MethodEntryOffset_;
	public static final int _MethodExitOffset_;
	public static final int _MonitorContendedEnterOffset_;
	public static final int _MonitorContendedEnteredOffset_;
	public static final int _MonitorWaitOffset_;
	public static final int _MonitorWaitedOffset_;
	public static final int _NativeMethodBindOffset_;
	public static final int _ObjectFreeOffset_;
	public static final int _ResourceExhaustedOffset_;
	public static final int _SampledObjectAllocOffset_;
	public static final int _SingleStepOffset_;
	public static final int _ThreadEndOffset_;
	public static final int _ThreadStartOffset_;
	public static final int _VMDeathOffset_;
	public static final int _VMInitOffset_;
	public static final int _VMObjectAllocOffset_;
	public static final int _VMStartOffset_;
	public static final int _reserved72Offset_;
	public static final int _reserved77Offset_;
	public static final int _reserved78Offset_;
	public static final int _reserved79Offset_;
	public static final int _reserved85Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_BreakpointOffset_ = 0;
		_ClassFileLoadHookOffset_ = 0;
		_ClassLoadOffset_ = 0;
		_ClassPrepareOffset_ = 0;
		_CompiledMethodLoadOffset_ = 0;
		_CompiledMethodUnloadOffset_ = 0;
		_DataDumpRequestOffset_ = 0;
		_DynamicCodeGeneratedOffset_ = 0;
		_ExceptionOffset_ = 0;
		_ExceptionCatchOffset_ = 0;
		_FieldAccessOffset_ = 0;
		_FieldModificationOffset_ = 0;
		_FramePopOffset_ = 0;
		_GarbageCollectionFinishOffset_ = 0;
		_GarbageCollectionStartOffset_ = 0;
		_MethodEntryOffset_ = 0;
		_MethodExitOffset_ = 0;
		_MonitorContendedEnterOffset_ = 0;
		_MonitorContendedEnteredOffset_ = 0;
		_MonitorWaitOffset_ = 0;
		_MonitorWaitedOffset_ = 0;
		_NativeMethodBindOffset_ = 0;
		_ObjectFreeOffset_ = 0;
		_ResourceExhaustedOffset_ = 0;
		_SampledObjectAllocOffset_ = 0;
		_SingleStepOffset_ = 0;
		_ThreadEndOffset_ = 0;
		_ThreadStartOffset_ = 0;
		_VMDeathOffset_ = 0;
		_VMInitOffset_ = 0;
		_VMObjectAllocOffset_ = 0;
		_VMStartOffset_ = 0;
		_reserved72Offset_ = 0;
		_reserved77Offset_ = 0;
		_reserved78Offset_ = 0;
		_reserved79Offset_ = 0;
		_reserved85Offset_ = 0;
	}

}
