/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __extctxPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __extctxPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__extctx.class)
public class __extctxPointer extends StructurePointer {

	// NULL
	public static final __extctxPointer NULL = new __extctxPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __extctxPointer(long address) {
		super(address);
	}

	public static __extctxPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __extctxPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __extctxPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __extctxPointer(address);
	}

	public __extctxPointer add(long count) {
		return __extctxPointer.cast(address + (__extctx.SIZEOF * count));
	}

	public __extctxPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __extctxPointer addOffset(long offset) {
		return __extctxPointer.cast(address + offset);
	}

	public __extctxPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __extctxPointer sub(long count) {
		return __extctxPointer.cast(address - (__extctx.SIZEOF * count));
	}

	public __extctxPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __extctxPointer subOffset(long offset) {
		return __extctxPointer.cast(address - offset);
	}

	public __extctxPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __extctxPointer untag(long mask) {
		return __extctxPointer.cast(address & ~mask);
	}

	public __extctxPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __extctx.SIZEOF;
	}

	// Implementation methods

	// I32 __extctx_magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctx_magicOffset_", declaredType="I32")
	public IDATA __extctx_magic() throws CorruptDataException {
		return new I32(getIntAtOffset(__extctx.___extctx_magicOffset_));
	}

	// I32 __extctx_magic
	public IDATAPointer __extctx_magicEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__extctx.___extctx_magicOffset_));
	}

	// U32 __flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___flagsOffset_", declaredType="U32")
	public UDATA __flags() throws CorruptDataException {
		return new U32(getIntAtOffset(__extctx.___flagsOffset_));
	}

	// U32 __flags
	public UDATAPointer __flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__extctx.___flagsOffset_));
	}

	// U8[] __reserved
	public U8Pointer __reservedEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__extctx.___reservedOffset_));
	}

	// U32[] __rsvd1
	public UDATAPointer __rsvd1EA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(__extctx.___rsvd1Offset_));
	}

	// __tm_context_t __tm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___tmOffset_", declaredType="__tm_context_t")
	public __tm_contextPointer __tm() throws CorruptDataException {
		return __tm_contextPointer.cast(nonNullFieldEA(__extctx.___tmOffset_));
	}

	// __tm_context_t __tm
	public PointerPointer __tmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__extctx.___tmOffset_));
	}

	// U32[] __ukeys
	public UDATAPointer __ukeysEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(__extctx.___ukeysOffset_));
	}

	// __vmx_context_t __vmx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___vmxOffset_", declaredType="__vmx_context_t")
	public __vmx_contextPointer __vmx() throws CorruptDataException {
		return __vmx_contextPointer.cast(nonNullFieldEA(__extctx.___vmxOffset_));
	}

	// __vmx_context_t __vmx
	public PointerPointer __vmxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__extctx.___vmxOffset_));
	}

	// __vsx_context_t __vsx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___vsxOffset_", declaredType="__vsx_context_t")
	public __vsx_contextPointer __vsx() throws CorruptDataException {
		return __vsx_contextPointer.cast(nonNullFieldEA(__extctx.___vsxOffset_));
	}

	// __vsx_context_t __vsx
	public PointerPointer __vsxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__extctx.___vsxOffset_));
	}

}
