/*
 * Copyright (c) 2000, 2023, Oracle and/or its affiliates. All rights reserved.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

/*
 * ===========================================================================
 * (c) Copyright IBM Corp. 2022, 2022 All Rights Reserved
 * ===========================================================================
 */

// -- This file was mechanically generated: Do not edit! -- //

package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jdk.internal.vm.annotation.Stable;

public class StandardCharsets extends CharsetProvider {

    static String[] aliases_US_ASCII() { return new String[] {
            "iso-ir-6",
            "ANSI_X3.4-1986",
            "ISO_646.irv:1991",
            "ASCII",
            "ISO646-US",
            "us",
            "IBM367",
            "cp367",
            "csASCII",
            "default",
            "646",
            "iso_646.irv:1983",
            "ANSI_X3.4-1968",
            "ascii7",
        };

    }

    static String[] aliases_UTF_8() { return new String[] {
            "UTF8",
            "unicode-1-1-utf-8",
        };

    }

    static String[] aliases_CESU_8() { return new String[] {
            "CESU8",
            "csCESU-8",
        };

    }

    static String[] aliases_UTF_16() { return new String[] {
            "UTF_16",
            "utf16",
            "unicode",
            "UnicodeBig",
        };

    }

    static String[] aliases_UTF_16BE() { return new String[] {
            "UTF_16BE",
            "ISO-10646-UCS-2",
            "X-UTF-16BE",
            "UnicodeBigUnmarked",
        };

    }

    static String[] aliases_UTF_16LE() { return new String[] {
            "UTF_16LE",
            "X-UTF-16LE",
            "UnicodeLittleUnmarked",
        };

    }

    static String[] aliases_UTF_16LE_BOM() { return new String[] {
            "UnicodeLittle",
        };

    }

    static String[] aliases_UTF_32() { return new String[] {
            "UTF_32",
            "UTF32",
        };

    }

    static String[] aliases_UTF_32LE() { return new String[] {
            "UTF_32LE",
            "X-UTF-32LE",
        };

    }

    static String[] aliases_UTF_32BE() { return new String[] {
            "UTF_32BE",
            "X-UTF-32BE",
        };

    }

    static String[] aliases_UTF_32LE_BOM() { return new String[] {
            "UTF_32LE_BOM",
            "UTF-32LE-BOM",
        };

    }

    static String[] aliases_UTF_32BE_BOM() { return new String[] {
            "UTF_32BE_BOM",
            "UTF-32BE-BOM",
        };

    }

    static String[] aliases_ISO_8859_1() { return new String[] {
            "iso-ir-100",
            "ISO_8859-1",
            "latin1",
            "l1",
            "IBM819",
            "cp819",
            "csISOLatin1",
            "819",
            "IBM-819",
            "ISO8859_1",
            "ISO_8859-1:1987",
            "ISO_8859_1",
            "8859_1",
            "ISO8859-1",
        };

    }

    static String[] aliases_ISO_8859_2() { return new String[] {
            "iso8859_2",
            "8859_2",
            "iso-ir-101",
            "ISO_8859-2",
            "ISO_8859-2:1987",
            "ISO8859-2",
            "latin2",
            "l2",
            "ibm912",
            "ibm-912",
            "cp912",
            "912",
            "csISOLatin2",
        };

    }

    static String[] aliases_ISO_8859_4() { return new String[] {
            "iso8859_4",
            "iso8859-4",
            "8859_4",
            "iso-ir-110",
            "ISO_8859-4",
            "ISO_8859-4:1988",
            "latin4",
            "l4",
            "ibm914",
            "ibm-914",
            "cp914",
            "914",
            "csISOLatin4",
        };

    }

    static String[] aliases_ISO_8859_5() { return new String[] {
            "iso8859_5",
            "8859_5",
            "iso-ir-144",
            "ISO_8859-5",
            "ISO_8859-5:1988",
            "ISO8859-5",
            "cyrillic",
            "ibm915",
            "ibm-915",
            "cp915",
            "915",
            "csISOLatinCyrillic",
        };

    }

    static String[] aliases_ISO_8859_7() { return new String[] {
            "iso8859_7",
            "8859_7",
            "iso-ir-126",
            "ISO_8859-7",
            "ISO_8859-7:1987",
            "ELOT_928",
            "ECMA-118",
            "greek",
            "greek8",
            "csISOLatinGreek",
            "sun_eu_greek",
            "ibm813",
            "ibm-813",
            "813",
            "cp813",
            "iso8859-7",
        };

    }

    static String[] aliases_ISO_8859_9() { return new String[] {
            "iso8859_9",
            "8859_9",
            "iso-ir-148",
            "ISO_8859-9",
            "ISO_8859-9:1989",
            "ISO8859-9",
            "latin5",
            "l5",
            "ibm920",
            "ibm-920",
            "920",
            "cp920",
            "csISOLatin5",
        };

    }

    static String[] aliases_ISO_8859_13() { return new String[] {
            "iso8859_13",
            "8859_13",
            "iso_8859-13",
            "ISO8859-13",
        };

    }

    static String[] aliases_ISO_8859_15() { return new String[] {
            "ISO_8859-15",
            "Latin-9",
            "csISO885915",
            "8859_15",
            "ISO-8859-15",
            "ISO8859_15",
            "ISO8859-15",
            "IBM923",
            "IBM-923",
            "cp923",
            "923",
            "LATIN0",
            "LATIN9",
            "L9",
            "csISOlatin0",
            "csISOlatin9",
            "ISO8859_15_FDIS",
        };

    }

    static String[] aliases_ISO_8859_16() { return new String[] {
            "iso-ir-226",
            "ISO_8859-16:2001",
            "ISO_8859-16",
            "ISO8859_16",
            "latin10",
            "l10",
            "csISO885916",
        };

    }

    static String[] aliases_KOI8_R() { return new String[] {
            "koi8_r",
            "koi8",
            "cskoi8r",
        };

    }

    static String[] aliases_KOI8_U() { return new String[] {
            "koi8_u",
        };

    }

    static String[] aliases_MS1250() { return new String[] {
            "cp1250",
            "cp5346",
        };

    }

    static String[] aliases_MS1251() { return new String[] {
            "cp1251",
            "cp5347",
            "ansi-1251",
        };

    }

    static String[] aliases_MS1252() { return new String[] {
            "cp1252",
            "cp5348",
            "ibm-1252",
            "ibm1252",
        };

    }

    static String[] aliases_MS1253() { return new String[] {
            "cp1253",
            "cp5349",
        };

    }

    static String[] aliases_MS1254() { return new String[] {
            "cp1254",
            "cp5350",
        };

    }

    static String[] aliases_MS1257() { return new String[] {
            "cp1257",
            "cp5353",
        };

    }

    static String[] aliases_IBM437() { return new String[] {
            "cp437",
            "ibm437",
            "ibm-437",
            "437",
            "cspc8codepage437",
            "windows-437",
        };

    }

    static String[] aliases_IBM737() { return new String[] {
            "cp737",
            "ibm737",
            "ibm-737",
            "737",
        };

    }

    static String[] aliases_IBM775() { return new String[] {
            "cp775",
            "ibm775",
            "ibm-775",
            "775",
        };

    }

    static String[] aliases_IBM850() { return new String[] {
            "cp850",
            "ibm-850",
            "ibm850",
            "850",
            "cspc850multilingual",
        };

    }

    static String[] aliases_IBM852() { return new String[] {
            "cp852",
            "ibm852",
            "ibm-852",
            "852",
            "csPCp852",
        };

    }

    static String[] aliases_IBM855() { return new String[] {
            "cp855",
            "ibm-855",
            "ibm855",
            "855",
            "cspcp855",
        };

    }

    static String[] aliases_IBM857() { return new String[] {
            "cp857",
            "ibm857",
            "ibm-857",
            "857",
            "csIBM857",
        };

    }

    static String[] aliases_IBM858() { return new String[] {
            "cp858",
            "ccsid00858",
            "cp00858",
            "858",
            "PC-Multilingual-850+euro",
            "ibm858",
            "ibm-858",
        };

    }

    static String[] aliases_IBM862() { return new String[] {
            "cp862",
            "ibm862",
            "ibm-862",
            "862",
            "csIBM862",
            "cspc862latinhebrew",
        };

    }

    static String[] aliases_IBM866() { return new String[] {
            "cp866",
            "ibm866",
            "ibm-866",
            "866",
            "csIBM866",
        };

    }

    static String[] aliases_IBM874() { return new String[] {
            "cp874",
            "ibm874",
            "ibm-874",
            "874",
        };

    }

    static String[] aliases_GB18030() { return new String[] {
            GB18030.IS_2000 ? "gb18030-2000" : "gb18030-2022"
        };
    }

    static String[] aliases_Big5() { return new String[] {
            "csBig5",
        };

    }

    static String[] aliases_Big5_HKSCS() { return new String[] {
            "Big5_HKSCS",
            "big5hk",
            "big5-hkscs",
            "big5hkscs",
        };

    }

    static String[] aliases_Big5_Solaris() { return new String[] {
            "Big5_Solaris",
        };

    }

    static String[] aliases_GBK() { return new String[] {
            "windows-936",
            "CP936",
        };

    }

    static String[] aliases_EUC_CN() { return new String[] {
            "gb2312",
            "gb2312-80",
            "gb2312-1980",
            "euc-cn",
            "euccn",
            "x-EUC-CN",
            "EUC_CN",
        };

    }

    static String[] aliases_JIS_X_0201() { return new String[] {
            "JIS0201",
            "JIS_X0201",
            "X0201",
            "csHalfWidthKatakana",
        };

    }

    static String[] aliases_JIS_X_0208() { return new String[] {
            "JIS0208",
            "JIS_C6226-1983",
            "iso-ir-87",
            "x0208",
            "JIS_X0208-1983",
            "csISO87JISX0208",
        };

    }

    static String[] aliases_JIS_X_0212() { return new String[] {
            "JIS0212",
            "jis_x0212-1990",
            "x0212",
            "iso-ir-159",
            "csISO159JISX02121990",
        };

    }

    static String[] aliases_EUC_KR() { return new String[] {
            "euc_kr",
            "ksc5601",
            "euckr",
            "ks_c_5601-1987",
            "ksc5601-1987",
            "ksc5601_1987",
            "ksc_5601",
            "csEUCKR",
            "5601",
        };

    }

    static String[] aliases_ISO_8859_6() { return new String[] {
            "iso8859_6",
            "8859_6",
            "iso-ir-127",
            "ISO_8859-6",
            "ISO_8859-6:1987",
            "ISO8859-6",
            "ECMA-114",
            "ASMO-708",
            "arabic",
            "ibm1089",
            "ibm-1089",
            "cp1089",
            "1089",
            "csISOLatinArabic",
        };

    }

    static String[] aliases_ISO_8859_8() { return new String[] {
            "iso8859_8",
            "8859_8",
            "iso-ir-138",
            "ISO_8859-8",
            "ISO_8859-8:1988",
            "ISO8859-8",
            "cp916",
            "916",
            "ibm916",
            "ibm-916",
            "hebrew",
            "csISOLatinHebrew",
        };

    }

    static String[] aliases_TIS_620() { return new String[] {
            "tis620",
            "tis620.2533",
        };

    }

    static String[] aliases_IBM942() { return new String[] {
            "cp942",
            "ibm942",
            "ibm-942",
            "942",
        };

    }

    static String[] aliases_IBM942C() { return new String[] {
            "cp942C",
            "ibm942C",
            "ibm-942C",
            "942C",
            "cp932",
            "ibm932",
            "ibm-932",
            "932",
            "x-ibm932",
        };

    }

    static String[] aliases_IBM943() { return new String[] {
            "cp943",
            "ibm943",
            "ibm-943",
            "943",
        };

    }

    static String[] aliases_IBM943C() { return new String[] {
            "cp943C",
            "ibm943C",
            "ibm-943C",
            "943C",
        };

    }

    static String[] aliases_IBM950() { return new String[] {
            "cp950",
            "ibm950",
            "ibm-950",
            "950",
        };

    }

    static String[] aliases_IBM856() { return new String[] {
            "cp856",
            "ibm-856",
            "ibm856",
            "856",
        };

    }

    static String[] aliases_IBM921() { return new String[] {
            "cp921",
            "ibm921",
            "ibm-921",
            "921",
        };

    }

    static String[] aliases_IBM1046() { return new String[] {
            "cp1046",
            "ibm1046",
            "ibm-1046",
            "1046",
        };

    }

    static String[] aliases_IBM1124() { return new String[] {
            "cp1124",
            "ibm1124",
            "ibm-1124",
            "1124",
        };

    }

    static String[] aliases_IBM1129() { return new String[] {
            "cp1129",
            "ibm1129",
            "ibm-1129",
            "1129",
        };

    }

    static String[] aliases_IBM922() { return new String[] {
            "cp922",
            "ibm922",
            "ibm-922",
            "922",
        };

    }

    static String[] aliases_IBM1383() { return new String[] {
            "cp1383",
            "ibm1383",
            "ibm-1383",
            "1383",
            "ibmeuccn",
            "ibm-euccn",
            "cpeuccn",
        };

    }

    static String[] aliases_IBM970() { return new String[] {
            "cp970",
            "ibm970",
            "ibm-970",
            "ibm-eucKR",
            "970",
        };

    }

    static String[] aliases_IBM964() { return new String[] {
            "cp964",
            "ibm964",
            "ibm-964",
            "ibm-euctw",
            "964",
        };

    }

    static String[] aliases_IBM29626C() { return new String[] {
            "cp29626c",
            "ibm29626c",
            "ibm-29626c",
            "29626c",
            "ibm-eucjp",
        };

    }

    static String[] aliases_SimpleEUCEncoder() { return null; }

    static String[] aliases_SJIS = null;

    static String[] aliases_MS932 = null;

    private static final class Aliases
        extends sun.util.PreHashedMap<String>
    {

        private static final int ROWS = 2048;
        private static final int SIZE = 362;
        private static final int SHIFT = 0;
        private static final int MASK = 0x7ff;

        private Aliases() {
            super(ROWS, SIZE, SHIFT, MASK);
        }

        protected void init(Object[] ht) {
            ht[1] = new Object[] { "csisolatin0", "iso-8859-15" };
            ht[2] = new Object[] { "x0208", "x-jis0208",
                         new Object[] { "csisolatin1", "iso-8859-1" } };
            ht[3] = new Object[] { "csisolatin2", "iso-8859-2" };
            ht[5] = new Object[] { "csisolatin4", "iso-8859-4" };
            ht[6] = new Object[] { "csisolatin5", "iso-8859-9" };
            ht[10] = new Object[] { "csisolatin9", "iso-8859-15" };
            ht[27] = new Object[] { "ibm-1124", "x-ibm1124",
                         new Object[] { "x0212", "jis_x0212-1990" } };
            ht[29] = new Object[] { "cp29626c", "x-ibm29626c" };
            ht[32] = new Object[] { "ibm-1129", "x-ibm1129" };
            ht[35] = new Object[] { "latin10", "iso-8859-16" };
            ht[86] = new Object[] { "ibm-1383", "x-ibm1383",
                         new Object[] { "8859_1", "iso-8859-1" } };
            ht[87] = new Object[] { "8859_2", "iso-8859-2" };
            ht[89] = new Object[] { "8859_4", "iso-8859-4" };
            ht[90] = new Object[] { "813", "iso-8859-7",
                         new Object[] { "8859_5", "iso-8859-5" } };
            ht[91] = new Object[] { "8859_6", "iso-8859-6" };
            ht[92] = new Object[] { "8859_7", "iso-8859-7" };
            ht[93] = new Object[] { "8859_8", "iso-8859-8" };
            ht[94] = new Object[] { "8859_9", "iso-8859-9" };
            ht[95] = new Object[] { "iso_8859-1:1987", "iso-8859-1" };
            ht[96] = new Object[] { "819", "iso-8859-1" };
            ht[98] = new Object[] { "5601", "euc-kr" };
            ht[106] = new Object[] { "unicode-1-1-utf-8", "utf-8" };
            ht[172] = new Object[] { "arabic", "iso-8859-6" };
            ht[177] = new Object[] { "utf_32le_bom", "x-utf-32le-bom" };
            ht[185] = new Object[] { "cp942c", "x-ibm942c" };
            ht[192] = new Object[] { "utf_16be", "utf-16be" };
            ht[197] = new Object[] { "ibm-euccn", "x-ibm1383" };
            ht[199] = new Object[] { "ansi-1251", "windows-1251" };
            ht[205] = new Object[] { "cp813", "iso-8859-7" };
            ht[211] = new Object[] { "850", "ibm850",
                         new Object[] { "cp819", "iso-8859-1" } };
            ht[213] = new Object[] { "852", "ibm852" };
            ht[214] = new Object[] { "ibm1124", "x-ibm1124" };
            ht[216] = new Object[] { "cp943c", "x-ibm943c",
                         new Object[] { "855", "ibm855" } };
            ht[217] = new Object[] { "856", "x-ibm856" };
            ht[218] = new Object[] { "857", "ibm857",
                         new Object[] { "iso-ir-6", "us-ascii" } };
            ht[219] = new Object[] { "ibm1129", "x-ibm1129",
                         new Object[] { "858", "ibm00858" } };
            ht[225] = new Object[] { "1046", "x-ibm1046",
                         new Object[] { "csascii", "us-ascii" } };
            ht[228] = new Object[] { "ibm29626c", "x-ibm29626c" };
            ht[244] = new Object[] { "862", "ibm862" };
            ht[248] = new Object[] { "866", "ibm866" };
            ht[254] = new Object[] { "iso_8859-2:1987", "iso-8859-2" };
            ht[259] = new Object[] { "unicodebig", "utf-16" };
            ht[273] = new Object[] { "ibm1383", "x-ibm1383" };
            ht[277] = new Object[] { "874", "x-ibm874" };
            ht[283] = new Object[] { "iso8859_1", "iso-8859-1" };
            ht[284] = new Object[] { "iso8859_2", "iso-8859-2" };
            ht[286] = new Object[] { "iso8859_4", "iso-8859-4" };
            ht[287] = new Object[] { "iso8859_5", "iso-8859-5" };
            ht[288] = new Object[] { "iso8859_6", "iso-8859-6" };
            ht[289] = new Object[] { "iso8859_7", "iso-8859-7" };
            ht[290] = new Object[] { "iso8859_8", "iso-8859-8" };
            ht[291] = new Object[] { "iso8859_9", "iso-8859-9" };
            ht[294] = new Object[] { "ibm912", "iso-8859-2" };
            ht[296] = new Object[] { "ibm914", "iso-8859-4" };
            ht[297] = new Object[] { "ibm915", "iso-8859-5" };
            ht[298] = new Object[] { "ibm916", "iso-8859-8" };
            ht[305] = new Object[] { "iso_8859-13", "iso-8859-13" };
            ht[307] = new Object[] { "iso_8859-15", "iso-8859-15" };
            ht[308] = new Object[] { "iso_8859-16", "iso-8859-16" };
            ht[312] = new Object[] { "greek8", "iso-8859-7",
                         new Object[] { "646", "us-ascii" } };
            ht[322] = new Object[] { "csiso87jisx0208", "x-jis0208" };
            ht[323] = new Object[] { "ibm920", "iso-8859-9" };
            ht[324] = new Object[] { "ibm921", "x-ibm921" };
            ht[325] = new Object[] { "ibm922", "x-ibm922" };
            ht[326] = new Object[] { "cp850", "ibm850",
                         new Object[] { "ibm923", "iso-8859-15" } };
            ht[327] = new Object[] { "cyrillic", "iso-8859-5" };
            ht[328] = new Object[] { "cp852", "ibm852" };
            ht[331] = new Object[] { "cp855", "ibm855" };
            ht[332] = new Object[] { "cp856", "x-ibm856" };
            ht[333] = new Object[] { "cp857", "ibm857" };
            ht[334] = new Object[] { "cp858", "ibm00858" };
            ht[339] = new Object[] { "koi8", "koi8-r" };
            ht[352] = new Object[] { "1089", "iso-8859-6" };
            ht[356] = new Object[] { "ibm932", "x-ibm942c" };
            ht[359] = new Object[] { "cp862", "ibm862" };
            ht[363] = new Object[] { "cp866", "ibm866" };
            ht[368] = new Object[] { "29626c", "x-ibm29626c" };
            ht[378] = new Object[] { "ansi_x3.4-1968", "us-ascii" };
            ht[385] = new Object[] { "ibm-813", "iso-8859-7" };
            ht[387] = new Object[] { "ibm942", "x-ibm942" };
            ht[388] = new Object[] { "ibm943", "x-ibm943" };
            ht[391] = new Object[] { "ibm-819", "iso-8859-1" };
            ht[392] = new Object[] { "cp874", "x-ibm874" };
            ht[408] = new Object[] { "437", "ibm437" };
            ht[410] = new Object[] { "iso-ir-226", "iso-8859-16" };
            ht[416] = new Object[] { "ibm-eucjp", "x-ibm29626c",
                         new Object[] { "ibm950", "x-ibm950" } };
            ht[438] = new Object[] { "ansi_x3.4-1986", "us-ascii" };
            ht[443] = new Object[] { "utf-32be-bom", "x-utf-32be-bom" };
            ht[449] = new Object[] { "ibm-euckr", "x-ibm970" };
            ht[451] = new Object[] { "ibm964", "x-ibm964" };
            ht[478] = new Object[] { "ibm970", "x-ibm970" };
            ht[487] = new Object[] { "ibm737", "x-ibm737" };
            ht[502] = new Object[] { "utf_16le", "utf-16le" };
            ht[506] = new Object[] { "ibm-850", "ibm850" };
            ht[508] = new Object[] { "ibm-852", "ibm852" };
            ht[511] = new Object[] { "ibm-855", "ibm855" };
            ht[512] = new Object[] { "ibm-856", "x-ibm856" };
            ht[513] = new Object[] { "ibm-857", "ibm857" };
            ht[514] = new Object[] { "ibm-858", "ibm00858" };
            ht[520] = new Object[] { "unicodebigunmarked", "utf-16be" };
            ht[523] = new Object[] { "cp437", "ibm437" };
            ht[530] = new Object[] { "windows-936", "gbk" };
            ht[539] = new Object[] { "ibm-862", "ibm862" };
            ht[543] = new Object[] { "ibm-866", "ibm866" };
            ht[555] = new Object[] { "big5hkscs", "big5-hkscs" };
            ht[572] = new Object[] { "ibm-874", "x-ibm874" };
            ht[573] = new Object[] { "iso_8859-4:1988", "iso-8859-4" };
            ht[588] = new Object[] { "elot_928", "iso-8859-7" };
            ht[591] = new Object[] { "cp1124", "x-ibm1124" };
            ht[596] = new Object[] { "cp1129", "x-ibm1129" };
            ht[609] = new Object[] { "ibm775", "ibm775" };
            ht[632] = new Object[] { "iso8859_13", "iso-8859-13" };
            ht[634] = new Object[] { "iso8859_15", "iso-8859-15",
                         new Object[] { "utf_32be", "utf-32be" } };
            ht[635] = new Object[] { "iso8859_16", "iso-8859-16",
                         new Object[] { "utf_32be_bom", "x-utf-32be-bom" } };
            ht[650] = new Object[] { "cp1383", "x-ibm1383" };
            ht[654] = new Object[] { "cp00858", "ibm00858" };
            ht[669] = new Object[] { "8859_13", "iso-8859-13" };
            ht[671] = new Object[] { "8859_15", "iso-8859-15" };
            ht[703] = new Object[] { "ibm-437", "ibm437" };
            ht[709] = new Object[] { "euc-cn", "gb2312" };
            ht[716] = new Object[] { "942c", "x-ibm942c" };
            ht[731] = new Object[] { "iso-ir-87", "x-jis0208" };
            ht[732] = new Object[] { "iso_8859-5:1988", "iso-8859-5" };
            ht[733] = new Object[] { "ibm-euctw", "x-ibm964",
                         new Object[] { "ksc5601", "euc-kr",
                             new Object[] { "unicode", "utf-16" } } };
            ht[745] = new Object[] { "ibm-29626c", "x-ibm29626c" };
            ht[747] = new Object[] { "943c", "x-ibm943c" };
            ht[774] = new Object[] { "ascii7", "us-ascii" };
            ht[781] = new Object[] { "iso8859-1", "iso-8859-1" };
            ht[782] = new Object[] { "iso8859-2", "iso-8859-2" };
            ht[783] = new Object[] { "cskoi8r", "koi8-r" };
            ht[784] = new Object[] { "iso8859-4", "iso-8859-4" };
            ht[785] = new Object[] { "iso8859-5", "iso-8859-5" };
            ht[786] = new Object[] { "iso8859-6", "iso-8859-6" };
            ht[787] = new Object[] { "iso8859-7", "iso-8859-7" };
            ht[788] = new Object[] { "iso8859-8", "iso-8859-8" };
            ht[789] = new Object[] { "iso8859-9", "iso-8859-9" };
            ht[813] = new Object[] { "ccsid00858", "ibm00858" };
            ht[827] = new Object[] { "tis620.2533", "tis-620" };
            ht[832] = new Object[] { "ibm367", "us-ascii" };
            ht[835] = new Object[] { "x-utf-16be", "utf-16be" };
            ht[836] = new Object[] { "sun_eu_greek", "iso-8859-7" };
            ht[840] = new Object[] { "gb2312-80", "gb2312" };
            ht[841] = new Object[] { "ksc5601_1987", "euc-kr" };
            ht[880] = new Object[] { "gb2312-1980", "gb2312" };
            ht[890] = new Object[] { "iso_8859-6:1987", "iso-8859-6" };
            ht[891] = new Object[] { "csisolatinarabic", "iso-8859-6" };
            ht[895] = new Object[] { "hebrew", "iso-8859-8" };
            ht[896] = new Object[] { "iso_646.irv:1983", "us-ascii" };
            ht[907] = new Object[] { "l10", "iso-8859-16" };
            ht[909] = new Object[] { "cp5346", "windows-1250" };
            ht[910] = new Object[] { "cp5347", "windows-1251" };
            ht[911] = new Object[] { "cp5348", "windows-1252" };
            ht[912] = new Object[] { "cp5349", "windows-1253" };
            ht[918] = new Object[] { "tis620", "tis-620" };
            ht[925] = new Object[] { "iso_646.irv:1991", "us-ascii" };
            ht[929] = new Object[] { "big5_solaris", "x-big5-solaris" };
            ht[934] = new Object[] { "cp5350", "windows-1254" };
            ht[937] = new Object[] { "cp5353", "windows-1257" };
            ht[944] = new Object[] { "utf_32le", "utf-32le" };
            ht[956] = new Object[] { "jis_x0212-1990", "jis_x0212-1990" };
            ht[984] = new Object[] { "jis_c6226-1983", "x-jis0208" };
            ht[993] = new Object[] { "cspc850multilingual", "ibm850" };
            ht[1043] = new Object[] { "unicodelittle", "x-utf-16le-bom" };
            ht[1047] = new Object[] { "ksc5601-1987", "euc-kr" };
            ht[1048] = new Object[] { "iso646-us", "us-ascii" };
            ht[1049] = new Object[] { "jis_x0208-1983", "x-jis0208",
                         new Object[] { "iso_8859-7:1987", "iso-8859-7" } };
            ht[1050] = new Object[] { "912", "iso-8859-2" };
            ht[1052] = new Object[] { "914", "iso-8859-4" };
            ht[1053] = new Object[] { "915", "iso-8859-5" };
            ht[1054] = new Object[] { "916", "iso-8859-8" };
            ht[1079] = new Object[] { "ibm-1252", "windows-1252",
                         new Object[] { "920", "iso-8859-9" } };
            ht[1080] = new Object[] { "921", "x-ibm921" };
            ht[1081] = new Object[] { "922", "x-ibm922" };
            ht[1082] = new Object[] { "923", "iso-8859-15" };
            ht[1110] = new Object[] { "csisolatincyrillic", "iso-8859-5" };
            ht[1112] = new Object[] { "932", "x-ibm942c" };
            ht[1113] = new Object[] { "x-ibm932", "x-ibm942c" };
            ht[1122] = new Object[] { "1124", "x-ibm1124" };
            ht[1127] = new Object[] { "1129", "x-ibm1129" };
            ht[1143] = new Object[] { "942", "x-ibm942" };
            ht[1144] = new Object[] { "943", "x-ibm943" };
            ht[1145] = new Object[] { "ecma-114", "iso-8859-6",
                         new Object[] { "x-utf-16le", "utf-16le" } };
            ht[1149] = new Object[] { "ecma-118", "iso-8859-7" };
            ht[1151] = new Object[] { "ks_c_5601-1987", "euc-kr" };
            ht[1158] = new Object[] { "asmo-708", "iso-8859-6",
                         new Object[] { "koi8_r", "koi8-r" } };
            ht[1161] = new Object[] { "koi8_u", "koi8-u" };
            ht[1165] = new Object[] { "cp912", "iso-8859-2" };
            ht[1167] = new Object[] { "cp914", "iso-8859-4" };
            ht[1168] = new Object[] { "cp915", "iso-8859-5" };
            ht[1169] = new Object[] { "cp916", "iso-8859-8" };
            ht[1172] = new Object[] { "950", "x-ibm950" };
            ht[1175] = new Object[] { "jis0201", "jis_x0201" };
            ht[1178] = new Object[] { "ibm-1046", "x-ibm1046" };
            ht[1181] = new Object[] { "1383", "x-ibm1383" };
            ht[1182] = new Object[] { "jis0208", "x-jis0208" };
            ht[1194] = new Object[] { "cp920", "iso-8859-9" };
            ht[1195] = new Object[] { "cp921", "x-ibm921" };
            ht[1196] = new Object[] { "cp922", "x-ibm922" };
            ht[1197] = new Object[] { "cp923", "iso-8859-15" };
            ht[1207] = new Object[] { "964", "x-ibm964",
                         new Object[] { "jis0212", "jis_x0212-1990" } };
            ht[1209] = new Object[] { "iso_8859-8:1988", "iso-8859-8" };
            ht[1223] = new Object[] { "cspc8codepage437", "ibm437" };
            ht[1227] = new Object[] { "cp932", "x-ibm942c" };
            ht[1231] = new Object[] { "cp936", "gbk" };
            ht[1234] = new Object[] { "970", "x-ibm970" };
            ht[1243] = new Object[] { "737", "x-ibm737" };
            ht[1258] = new Object[] { "cp942", "x-ibm942" };
            ht[1259] = new Object[] { "cp943", "x-ibm943" };
            ht[1266] = new Object[] { "ibm1252", "windows-1252" };
            ht[1277] = new Object[] { "x-utf-32be", "utf-32be" };
            ht[1287] = new Object[] { "cp950", "x-ibm950" };
            ht[1293] = new Object[] { "iso8859_15_fdis", "iso-8859-15" };
            ht[1297] = new Object[] { "cpeuccn", "x-ibm1383" };
            ht[1304] = new Object[] { "unicodelittleunmarked", "utf-16le" };
            ht[1305] = new Object[] { "ibm-1089", "iso-8859-6" };
            ht[1309] = new Object[] { "csiso885915", "iso-8859-15" };
            ht[1310] = new Object[] { "csiso885916", "iso-8859-16" };
            ht[1322] = new Object[] { "cp964", "x-ibm964" };
            ht[1345] = new Object[] { "ibm-912", "iso-8859-2" };
            ht[1347] = new Object[] { "ibm-914", "iso-8859-4" };
            ht[1348] = new Object[] { "ibm-915", "iso-8859-5" };
            ht[1349] = new Object[] { "cp970", "x-ibm970",
                         new Object[] { "ibm-916", "iso-8859-8",
                             new Object[] { "l1", "iso-8859-1" } } };
            ht[1350] = new Object[] { "l2", "iso-8859-2" };
            ht[1352] = new Object[] { "l4", "iso-8859-4" };
            ht[1353] = new Object[] { "l5", "iso-8859-9" };
            ht[1357] = new Object[] { "l9", "iso-8859-15" };
            ht[1358] = new Object[] { "cp737", "x-ibm737" };
            ht[1360] = new Object[] { "iso_8859_1", "iso-8859-1" };
            ht[1365] = new Object[] { "ibm1046", "x-ibm1046",
                         new Object[] { "775", "ibm775" } };
            ht[1369] = new Object[] { "iso_8859-9:1989", "iso-8859-9" };
            ht[1374] = new Object[] { "euccn", "gb2312",
                         new Object[] { "ibm-920", "iso-8859-9" } };
            ht[1375] = new Object[] { "ibm-921", "x-ibm921" };
            ht[1376] = new Object[] { "ibm-922", "x-ibm922" };
            ht[1377] = new Object[] { "ibm-923", "iso-8859-15" };
            ht[1382] = new Object[] { "ibm813", "iso-8859-7" };
            ht[1388] = new Object[] { "ibm819", "iso-8859-1" };
            ht[1407] = new Object[] { "ibm-932", "x-ibm942c" };
            ht[1429] = new Object[] { "iso-ir-100", "iso-8859-1" };
            ht[1430] = new Object[] { "iso-ir-101", "iso-8859-2" };
            ht[1438] = new Object[] { "ibm-942", "x-ibm942" };
            ht[1439] = new Object[] { "ibm-943", "x-ibm943" };
            ht[1445] = new Object[] { "iso-8859-15", "iso-8859-15" };
            ht[1446] = new Object[] { "csiso159jisx02121990", "jis_x0212-1990" };
            ht[1452] = new Object[] { "latin0", "iso-8859-15" };
            ht[1453] = new Object[] { "latin1", "iso-8859-1" };
            ht[1454] = new Object[] { "latin2", "iso-8859-2" };
            ht[1456] = new Object[] { "latin4", "iso-8859-4" };
            ht[1457] = new Object[] { "latin5", "iso-8859-9" };
            ht[1460] = new Object[] { "iso-ir-110", "iso-8859-4" };
            ht[1461] = new Object[] { "latin9", "iso-8859-15" };
            ht[1466] = new Object[] { "x-euc-cn", "gb2312" };
            ht[1467] = new Object[] { "ibm-950", "x-ibm950" };
            ht[1480] = new Object[] { "cp775", "ibm775" };
            ht[1492] = new Object[] { "ibm1089", "iso-8859-6" };
            ht[1497] = new Object[] { "iso-ir-126", "iso-8859-7" };
            ht[1498] = new Object[] { "iso-ir-127", "iso-8859-6" };
            ht[1502] = new Object[] { "ibm-964", "x-ibm964" };
            ht[1503] = new Object[] { "ibm850", "ibm850" };
            ht[1505] = new Object[] { "ibm852", "ibm852" };
            ht[1508] = new Object[] { "ibm855", "ibm855" };
            ht[1509] = new Object[] { "ibm856", "x-ibm856" };
            ht[1510] = new Object[] { "ibm857", "ibm857" };
            ht[1511] = new Object[] { "ibm858", "ibm00858" };
            ht[1529] = new Object[] { "ibm-970", "x-ibm970" };
            ht[1530] = new Object[] { "iso-ir-138", "iso-8859-8" };
            ht[1536] = new Object[] { "ibm862", "ibm862" };
            ht[1538] = new Object[] { "ibm-737", "x-ibm737" };
            ht[1540] = new Object[] { "ibm866", "ibm866" };
            ht[1548] = new Object[] { "utf16", "utf-16" };
            ht[1557] = new Object[] { "iso-ir-144", "iso-8859-5" };
            ht[1561] = new Object[] { "iso-ir-148", "iso-8859-9" };
            ht[1569] = new Object[] { "ibm874", "x-ibm874" };
            ht[1574] = new Object[] { "ksc_5601", "euc-kr" };
            ht[1587] = new Object[] { "x-utf-32le", "utf-32le" };
            ht[1593] = new Object[] { "iso-ir-159", "jis_x0212-1990" };
            ht[1601] = new Object[] { "default", "us-ascii" };
            ht[1606] = new Object[] { "utf32", "utf-32" };
            ht[1607] = new Object[] { "pc-multilingual-850+euro", "ibm00858" };
            ht[1614] = new Object[] { "csisolatinhebrew", "iso-8859-8" };
            ht[1615] = new Object[] { "cshalfwidthkatakana", "jis_x0201" };
            ht[1617] = new Object[] { "csisolatingreek", "iso-8859-7" };
            ht[1622] = new Object[] { "csibm857", "ibm857" };
            ht[1626] = new Object[] { "euckr", "euc-kr" };
            ht[1641] = new Object[] { "cp1250", "windows-1250" };
            ht[1642] = new Object[] { "cp1251", "windows-1251" };
            ht[1643] = new Object[] { "cp1252", "windows-1252" };
            ht[1644] = new Object[] { "cp1253", "windows-1253" };
            ht[1645] = new Object[] { "cp1254", "windows-1254" };
            ht[1648] = new Object[] { "csibm862", "ibm862",
                         new Object[] { "cp1257", "windows-1257" } };
            ht[1652] = new Object[] { "csibm866", "ibm866",
                         new Object[] { "cesu8", "cesu-8" } };
            ht[1655] = new Object[] { "euc_cn", "gb2312" };
            ht[1660] = new Object[] { "ibm-775", "ibm775" };
            ht[1669] = new Object[] { "ibm-942c", "x-ibm942c" };
            ht[1694] = new Object[] { "us", "us-ascii" };
            ht[1700] = new Object[] { "ibm-943c", "x-ibm943c",
                         new Object[] { "ibm437", "ibm437" } };
            ht[1703] = new Object[] { "cp367", "us-ascii" };
            ht[1710] = new Object[] { "iso-10646-ucs-2", "utf-16be" };
            ht[1718] = new Object[] { "big5_hkscs", "big5-hkscs" };
            ht[1734] = new Object[] { "iso8859-13", "iso-8859-13" };
            ht[1736] = new Object[] { "iso8859-15", "iso-8859-15" };
            ht[1742] = new Object[] { "cp1046", "x-ibm1046" };
            ht[1784] = new Object[] { "big5hk", "big5-hkscs" };
            ht[1792] = new Object[] { "greek", "iso-8859-7" };
            ht[1808] = new Object[] { "jis_x0201", "jis_x0201" };
            ht[1842] = new Object[] { "cspc862latinhebrew", "ibm862" };
            ht[1856] = new Object[] { "ibm942c", "x-ibm942c" };
            ht[1858] = new Object[] { "iso_8859-1", "iso-8859-1" };
            ht[1859] = new Object[] { "iso_8859-2", "iso-8859-2" };
            ht[1861] = new Object[] { "iso_8859-16:2001", "iso-8859-16",
                         new Object[] { "iso_8859-4", "iso-8859-4" } };
            ht[1862] = new Object[] { "iso_8859-5", "iso-8859-5" };
            ht[1863] = new Object[] { "iso_8859-6", "iso-8859-6" };
            ht[1864] = new Object[] { "cspcp852", "ibm852",
                         new Object[] { "iso_8859-7", "iso-8859-7" } };
            ht[1865] = new Object[] { "iso_8859-8", "iso-8859-8" };
            ht[1866] = new Object[] { "iso_8859-9", "iso-8859-9" };
            ht[1867] = new Object[] { "cspcp855", "ibm855" };
            ht[1869] = new Object[] { "cp1089", "iso-8859-6" };
            ht[1870] = new Object[] { "windows-437", "ibm437" };
            ht[1873] = new Object[] { "ascii", "us-ascii" };
            ht[1887] = new Object[] { "ibm943c", "x-ibm943c",
                         new Object[] { "cscesu-8", "cesu-8" } };
            ht[1898] = new Object[] { "ibmeuccn", "x-ibm1383" };
            ht[1905] = new Object[] { "utf8", "utf-8" };
            ht[1907] = new Object[] { "euc_kr", "euc-kr" };
            ht[1917] = new Object[] { "gb2312", "gb2312" };
            ht[1957] = new Object[] { "csbig5", "big5" };
            ht[1960] = new Object[] { "big5-hkscs", "big5-hkscs" };
            ht[1968] = new Object[] { "latin-9", "iso-8859-15" };
            ht[1981] = new Object[] { "utf_16", "utf-16" };
            ht[2026] = new Object[] { "cseuckr", "euc-kr" };
            ht[2033] = new Object[] { "utf-32le-bom", "x-utf-32le-bom" };
            ht[2039] = new Object[] { "utf_32", "utf-32" };
            ht[2043] = new Object[] { "x0201", "jis_x0201" };
        }

    }

    private static final class Classes
        extends sun.util.PreHashedMap<String>
    {

        private static final int ROWS = 64;
        private static final int SIZE = 68;
        private static final int SHIFT = 0;
        private static final int MASK = 0x3f;

        private Classes() {
            super(ROWS, SIZE, SHIFT, MASK);
        }

        protected void init(Object[] ht) {
            ht[0] = new Object[] { "x-ibm1046", "IBM1046",
                         new Object[] { "ibm862", "IBM862" } };
            ht[1] = new Object[] { "x-ibm1124", "IBM1124",
                         new Object[] { "euc-kr", "EUC_KR" } };
            ht[4] = new Object[] { "ibm866", "IBM866",
                         new Object[] { "utf-16le", "UTF_16LE" } };
            ht[5] = new Object[] { "tis-620", "TIS_620",
                         new Object[] { "utf-32", "UTF_32" } };
            ht[6] = new Object[] { "x-ibm1129", "IBM1129",
                         new Object[] { "windows-1250", "MS1250" } };
            ht[7] = new Object[] { "windows-1251", "MS1251" };
            ht[8] = new Object[] { "x-big5-solaris", "Big5_Solaris",
                         new Object[] { "windows-1252", "MS1252",
                             new Object[] { "utf-32be", "UTF_32BE" } } };
            ht[9] = new Object[] { "x-jis0208", "JIS_X_0208",
                         new Object[] { "windows-1253", "MS1253" } };
            ht[10] = new Object[] { "x-ibm943c", "IBM943C",
                         new Object[] { "windows-1254", "MS1254" } };
            ht[11] = new Object[] { "gb18030", "GB18030",
                         new Object[] { "utf-16", "UTF_16" } };
            ht[13] = new Object[] { "windows-1257", "MS1257" };
            ht[14] = new Object[] { "utf-16be", "UTF_16BE" };
            ht[15] = new Object[] { "x-ibm29626c", "IBM29626C" };
            ht[16] = new Object[] { "jis_x0201", "JIS_X_0201",
                         new Object[] { "iso-8859-1", "ISO_8859_1" } };
            ht[17] = new Object[] { "iso-8859-2", "ISO_8859_2" };
            ht[18] = new Object[] { "utf-8", "UTF_8" };
            ht[19] = new Object[] { "x-ibm970", "IBM970",
                         new Object[] { "iso-8859-4", "ISO_8859_4" } };
            ht[20] = new Object[] { "iso-8859-5", "ISO_8859_5" };
            ht[21] = new Object[] { "x-ibm950", "IBM950",
                         new Object[] { "iso-8859-6", "ISO_8859_6" } };
            ht[22] = new Object[] { "x-ibm874", "IBM874",
                         new Object[] { "iso-8859-7", "ISO_8859_7" } };
            ht[23] = new Object[] { "iso-8859-8", "ISO_8859_8" };
            ht[24] = new Object[] { "iso-8859-9", "ISO_8859_9" };
            ht[26] = new Object[] { "x-ibm856", "IBM856" };
            ht[28] = new Object[] { "x-ibm737", "IBM737" };
            ht[31] = new Object[] { "ibm850", "IBM850" };
            ht[33] = new Object[] { "ibm852", "IBM852",
                         new Object[] { "ibm775", "IBM775" } };
            ht[34] = new Object[] { "us-ascii", "US_ASCII" };
            ht[35] = new Object[] { "iso-8859-13", "ISO_8859_13" };
            ht[36] = new Object[] { "ibm855", "IBM855",
                         new Object[] { "ibm437", "IBM437" } };
            ht[37] = new Object[] { "iso-8859-15", "ISO_8859_15" };
            ht[38] = new Object[] { "ibm857", "IBM857",
                         new Object[] { "iso-8859-16", "ISO_8859_16",
                             new Object[] { "x-utf-32le-bom", "UTF_32LE_BOM" } } };
            ht[39] = new Object[] { "ibm00858", "IBM858" };
            ht[40] = new Object[] { "big5-hkscs", "Big5_HKSCS" };
            ht[43] = new Object[] { "x-ibm942c", "IBM942C" };
            ht[44] = new Object[] { "x-utf-16le-bom", "UTF_16LE_BOM" };
            ht[47] = new Object[] { "cesu-8", "CESU_8" };
            ht[48] = new Object[] { "gbk", "GBK",
                         new Object[] { "x-utf-32be-bom", "UTF_32BE_BOM" } };
            ht[53] = new Object[] { "big5", "Big5" };
            ht[56] = new Object[] { "x-ibm964", "IBM964",
                         new Object[] { "x-ibm942", "IBM942",
                             new Object[] { "koi8-r", "KOI8_R" } } };
            ht[57] = new Object[] { "x-ibm921", "IBM921",
                         new Object[] { "x-ibm943", "IBM943" } };
            ht[58] = new Object[] { "x-ibm922", "IBM922" };
            ht[59] = new Object[] { "koi8-u", "KOI8_U" };
            ht[60] = new Object[] { "x-ibm1383", "IBM1383",
                         new Object[] { "jis_x0212-1990", "JIS_X_0212" } };
            ht[61] = new Object[] { "gb2312", "EUC_CN" };
            ht[62] = new Object[] { "utf-32le", "UTF_32LE" };
        }

    }

    private static final class Cache
        extends sun.util.PreHashedMap<Charset>
    {

        private static final int ROWS = 64;
        private static final int SIZE = 68;
        private static final int SHIFT = 0;
        private static final int MASK = 0x3f;

        private Cache() {
            super(ROWS, SIZE, SHIFT, MASK);
        }

        protected void init(Object[] ht) {
            ht[0] = new Object[] { "x-ibm1046", null,
                         new Object[] { "ibm862", null } };
            ht[1] = new Object[] { "x-ibm1124", null,
                         new Object[] { "euc-kr", null } };
            ht[4] = new Object[] { "ibm866", null,
                         new Object[] { "utf-16le", null } };
            ht[5] = new Object[] { "tis-620", null,
                         new Object[] { "utf-32", null } };
            ht[6] = new Object[] { "x-ibm1129", null,
                         new Object[] { "windows-1250", null } };
            ht[7] = new Object[] { "windows-1251", null };
            ht[8] = new Object[] { "x-big5-solaris", null,
                         new Object[] { "windows-1252", null,
                             new Object[] { "utf-32be", null } } };
            ht[9] = new Object[] { "x-jis0208", null,
                         new Object[] { "windows-1253", null } };
            ht[10] = new Object[] { "x-ibm943c", null,
                         new Object[] { "windows-1254", null } };
            ht[11] = new Object[] { "gb18030", null,
                         new Object[] { "utf-16", null } };
            ht[13] = new Object[] { "windows-1257", null };
            ht[14] = new Object[] { "utf-16be", null };
            ht[15] = new Object[] { "x-ibm29626c", null };
            ht[16] = new Object[] { "jis_x0201", null,
                         new Object[] { "iso-8859-1", null } };
            ht[17] = new Object[] { "iso-8859-2", null };
            ht[18] = new Object[] { "utf-8", null };
            ht[19] = new Object[] { "x-ibm970", null,
                         new Object[] { "iso-8859-4", null } };
            ht[20] = new Object[] { "iso-8859-5", null };
            ht[21] = new Object[] { "x-ibm950", null,
                         new Object[] { "iso-8859-6", null } };
            ht[22] = new Object[] { "x-ibm874", null,
                         new Object[] { "iso-8859-7", null } };
            ht[23] = new Object[] { "iso-8859-8", null };
            ht[24] = new Object[] { "iso-8859-9", null };
            ht[26] = new Object[] { "x-ibm856", null };
            ht[28] = new Object[] { "x-ibm737", null };
            ht[31] = new Object[] { "ibm850", null };
            ht[33] = new Object[] { "ibm852", null,
                         new Object[] { "ibm775", null } };
            ht[34] = new Object[] { "us-ascii", null };
            ht[35] = new Object[] { "iso-8859-13", null };
            ht[36] = new Object[] { "ibm855", null,
                         new Object[] { "ibm437", null } };
            ht[37] = new Object[] { "iso-8859-15", null };
            ht[38] = new Object[] { "ibm857", null,
                         new Object[] { "iso-8859-16", null,
                             new Object[] { "x-utf-32le-bom", null } } };
            ht[39] = new Object[] { "ibm00858", null };
            ht[40] = new Object[] { "big5-hkscs", null };
            ht[43] = new Object[] { "x-ibm942c", null };
            ht[44] = new Object[] { "x-utf-16le-bom", null };
            ht[47] = new Object[] { "cesu-8", null };
            ht[48] = new Object[] { "gbk", null,
                         new Object[] { "x-utf-32be-bom", null } };
            ht[53] = new Object[] { "big5", null };
            ht[56] = new Object[] { "x-ibm964", null,
                         new Object[] { "x-ibm942", null,
                             new Object[] { "koi8-r", null } } };
            ht[57] = new Object[] { "x-ibm921", null,
                         new Object[] { "x-ibm943", null } };
            ht[58] = new Object[] { "x-ibm922", null };
            ht[59] = new Object[] { "koi8-u", null };
            ht[60] = new Object[] { "x-ibm1383", null,
                         new Object[] { "jis_x0212-1990", null } };
            ht[61] = new Object[] { "gb2312", null };
            ht[62] = new Object[] { "utf-32le", null };
        }

    }

    // Maps canonical names to class names
    private @Stable Map<String,String> classMap;

    // Maps alias names to canonical names
    private @Stable Map<String,String> aliasMap;

    // Maps canonical names to cached instances
    private @Stable Map<String,Charset> cache;

    private static final String packagePrefix = "sun.nio.cs.";

    public StandardCharsets() {
    }

    private String canonicalize(String csn) {
        if (csn.startsWith("gb18030-")) {
            return csn.equals("gb18030-2022") && !GB18030.IS_2000 ||
                   csn.equals("gb18030-2000") && GB18030.IS_2000 ? "gb18030" : csn;
        } else {
            String acn = aliasMap().get(csn);
            return (acn != null) ? acn : csn;
        }
    }

    private Map<String,String> aliasMap() {
        Map<String,String> map = aliasMap;
        if (map == null) {
            aliasMap = map = new Aliases();
        }
        return map;
    }

    private Map<String,String> classMap() {
        Map<String,String> map = classMap;
        if (map == null) {
            classMap = map = new Classes();
        }
        return map;
    }

    private Map<String,Charset> cache() {
        Map<String,Charset> map = cache;
        if (map == null) {
            map = new Cache();
            map.put("utf-8", UTF_8.INSTANCE);
            map.put("iso-8859-1", ISO_8859_1.INSTANCE);
            map.put("us-ascii", US_ASCII.INSTANCE);
            map.put("utf-16", java.nio.charset.StandardCharsets.UTF_16);
            map.put("utf-16be", java.nio.charset.StandardCharsets.UTF_16BE);
            map.put("utf-16le", java.nio.charset.StandardCharsets.UTF_16LE);
            cache = map;
        }
        return map;
    }

    // Private ASCII-only version, optimized for interpretation during startup
    //
    private static String toLower(String s) {
        int n = s.length();
        boolean allLower = true;
        for (int i = 0; i < n; i++) {
            int c = s.charAt(i);
            if (((c - 'A') | ('Z' - c)) >= 0) {
                allLower = false;
                break;
            }
        }
        if (allLower)
            return s;
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; i++) {
            int c = s.charAt(i);
            if (((c - 'A') | ('Z' - c)) >= 0)
                sb.append((char)(c + 0x20));
            else
                sb.append((char)c);
        }
        return sb.toString();
    }

    private Charset lookup(String charsetName) {
        // By checking these built-ins we can avoid initializing Aliases,
        // Classes and Cache eagerly during bootstrap.
        //
        // Initialization of java.nio.charset.StandardCharsets should be
        // avoided here to minimize time spent in System.initPhase1, as it
        // may delay initialization of performance critical VM subsystems.
        String csn;
        if (charsetName.equals("UTF-8")) {
            return UTF_8.INSTANCE;
        } else if (charsetName.equals("US-ASCII")) {
            return US_ASCII.INSTANCE;
        } else if (charsetName.equals("ISO-8859-1")) {
            return ISO_8859_1.INSTANCE;
        } else {
            csn = canonicalize(toLower(charsetName));
        }

        // Check cache first
        Charset cs = cache().get(csn);
        if (cs != null)
            return cs;

        // Do we even support this charset?
        String cln = classMap().get(csn);
        if (cln == null)
            return null;

        // Instantiate the charset and cache it
        try {
            @SuppressWarnings("deprecation")
            Object o = Class.forName(packagePrefix + cln,
                                     true,
                                     this.getClass().getClassLoader()).newInstance();
            return cache(csn, (Charset)o);
        } catch (ClassNotFoundException |
                 IllegalAccessException |
                 InstantiationException x) {
            return null;
        }
    }

    private Charset cache(String csn, Charset cs) {
        cache().put(csn, cs);
        return cs;
    }

    public final Charset charsetForName(String charsetName) {
        synchronized (this) {
            return lookup(charsetName);
        }
    }

    public final Iterator<Charset> charsets() {
        Set<String> charsetNames;
        synchronized (this) {
            // Ensure initialized in synchronized block
            charsetNames = classMap().keySet();
            aliasMap();
            cache();
        }
        return new Iterator<Charset>() {

                Iterator<String> i = charsetNames.iterator();

                public boolean hasNext() {
                    return i.hasNext();
                }

                public Charset next() {
                    String csn = i.next();
                    return lookup(csn);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

            };
    }
}
