/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: FILEPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the FILEPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=FILE.class)
public class FILEPointer extends StructurePointer {

	// NULL
	public static final FILEPointer NULL = new FILEPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected FILEPointer(long address) {
		super(address);
	}

	public static FILEPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static FILEPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static FILEPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new FILEPointer(address);
	}

	public FILEPointer add(long count) {
		return FILEPointer.cast(address + (FILE.SIZEOF * count));
	}

	public FILEPointer add(Scalar count) {
		return add(count.longValue());
	}

	public FILEPointer addOffset(long offset) {
		return FILEPointer.cast(address + offset);
	}

	public FILEPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public FILEPointer sub(long count) {
		return FILEPointer.cast(address - (FILE.SIZEOF * count));
	}

	public FILEPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public FILEPointer subOffset(long offset) {
		return FILEPointer.cast(address - offset);
	}

	public FILEPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public FILEPointer untag(long mask) {
		return FILEPointer.cast(address & ~mask);
	}

	public FILEPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return FILE.SIZEOF;
	}

	// Implementation methods

	// U8* __newbase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___newbaseOffset_", declaredType="U8*")
	public U8Pointer __newbase() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(FILE.___newbaseOffset_));
	}

	// U8* __newbase
	public PointerPointer __newbaseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(FILE.___newbaseOffset_));
	}

	// I32 __stdioid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___stdioidOffset_", declaredType="I32")
	public IDATA __stdioid() throws CorruptDataException {
		return new I32(getIntAtOffset(FILE.___stdioidOffset_));
	}

	// I32 __stdioid
	public IDATAPointer __stdioidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(FILE.___stdioidOffset_));
	}

	// U8* _base
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__baseOffset_", declaredType="U8*")
	public U8Pointer _base() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(FILE.__baseOffset_));
	}

	// U8* _base
	public PointerPointer _baseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(FILE.__baseOffset_));
	}

	// U8* _bufendp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufendpOffset_", declaredType="U8*")
	public U8Pointer _bufendp() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(FILE.__bufendpOffset_));
	}

	// U8* _bufendp
	public PointerPointer _bufendpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(FILE.__bufendpOffset_));
	}

	// I32 _cnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cntOffset_", declaredType="I32")
	public IDATA _cnt() throws CorruptDataException {
		return new I32(getIntAtOffset(FILE.__cntOffset_));
	}

	// I32 _cnt
	public IDATAPointer _cntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(FILE.__cntOffset_));
	}

	// I32 _file
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__fileOffset_", declaredType="I32")
	public IDATA _file() throws CorruptDataException {
		return new I32(getIntAtOffset(FILE.__fileOffset_));
	}

	// I32 _file
	public IDATAPointer _fileEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(FILE.__fileOffset_));
	}

	// I16 _flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__flagOffset_", declaredType="I16")
	public I16 _flag() throws CorruptDataException {
		return new I16(getShortAtOffset(FILE.__flagOffset_));
	}

	// I16 _flag
	public I16Pointer _flagEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(FILE.__flagOffset_));
	}

	// void* _lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__lockOffset_", declaredType="void*")
	public VoidPointer _lock() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(FILE.__lockOffset_));
	}

	// void* _lock
	public PointerPointer _lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(FILE.__lockOffset_));
	}

	// U8* _ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__ptrOffset_", declaredType="U8*")
	public U8Pointer _ptr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(FILE.__ptrOffset_));
	}

	// U8* _ptr
	public PointerPointer _ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(FILE.__ptrOffset_));
	}

	// I16 _unused
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__unusedOffset_", declaredType="I16")
	public I16 _unused() throws CorruptDataException {
		return new I16(getShortAtOffset(FILE.__unusedOffset_));
	}

	// I16 _unused
	public I16Pointer _unusedEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(FILE.__unusedOffset_));
	}

	// I64[] _unused1
	public IDATAPointer _unused1EA() throws CorruptDataException {
		return I64Pointer.cast(nonNullFieldEA(FILE.__unused1Offset_));
	}

}
