/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GC_ClassArrayClassSlotIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GC_ClassArrayClassSlotIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GC_ClassArrayClassSlotIterator.class)
public class GC_ClassArrayClassSlotIteratorPointer extends StructurePointer {

	// NULL
	public static final GC_ClassArrayClassSlotIteratorPointer NULL = new GC_ClassArrayClassSlotIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GC_ClassArrayClassSlotIteratorPointer(long address) {
		super(address);
	}

	public static GC_ClassArrayClassSlotIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GC_ClassArrayClassSlotIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GC_ClassArrayClassSlotIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GC_ClassArrayClassSlotIteratorPointer(address);
	}

	public GC_ClassArrayClassSlotIteratorPointer add(long count) {
		return GC_ClassArrayClassSlotIteratorPointer.cast(address + (GC_ClassArrayClassSlotIterator.SIZEOF * count));
	}

	public GC_ClassArrayClassSlotIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GC_ClassArrayClassSlotIteratorPointer addOffset(long offset) {
		return GC_ClassArrayClassSlotIteratorPointer.cast(address + offset);
	}

	public GC_ClassArrayClassSlotIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GC_ClassArrayClassSlotIteratorPointer sub(long count) {
		return GC_ClassArrayClassSlotIteratorPointer.cast(address - (GC_ClassArrayClassSlotIterator.SIZEOF * count));
	}

	public GC_ClassArrayClassSlotIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GC_ClassArrayClassSlotIteratorPointer subOffset(long offset) {
		return GC_ClassArrayClassSlotIteratorPointer.cast(address - offset);
	}

	public GC_ClassArrayClassSlotIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GC_ClassArrayClassSlotIteratorPointer untag(long mask) {
		return GC_ClassArrayClassSlotIteratorPointer.cast(address & ~mask);
	}

	public GC_ClassArrayClassSlotIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GC_ClassArrayClassSlotIterator.SIZEOF;
	}

	// Implementation methods

	// bool _isArrayClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__isArrayClassOffset_", declaredType="bool")
	public boolean _isArrayClass() throws CorruptDataException {
		return getBoolAtOffset(GC_ClassArrayClassSlotIterator.__isArrayClassOffset_);
	}

	// bool _isArrayClass
	public BoolPointer _isArrayClassEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(GC_ClassArrayClassSlotIterator.__isArrayClassOffset_));
	}

	// J9Class* _iterateClazz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__iterateClazzOffset_", declaredType="J9Class*")
	public J9ClassPointer _iterateClazz() throws CorruptDataException {
		return J9ClassPointer.cast(getPointerAtOffset(GC_ClassArrayClassSlotIterator.__iterateClazzOffset_));
	}

	// J9Class* _iterateClazz
	public PointerPointer _iterateClazzEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_ClassArrayClassSlotIterator.__iterateClazzOffset_));
	}

	// I32 _state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stateOffset_", declaredType="I32")
	public IDATA _state() throws CorruptDataException {
		return new I32(getIntAtOffset(GC_ClassArrayClassSlotIterator.__stateOffset_));
	}

	// I32 _state
	public IDATAPointer _stateEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(GC_ClassArrayClassSlotIterator.__stateOffset_));
	}

}
