/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_SparseAddressOrderedFixedSizeDataPoolPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_SparseAddressOrderedFixedSizeDataPoolPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_SparseAddressOrderedFixedSizeDataPool.class)
public class MM_SparseAddressOrderedFixedSizeDataPoolPointer extends MM_BaseVirtualPointer {

	// NULL
	public static final MM_SparseAddressOrderedFixedSizeDataPoolPointer NULL = new MM_SparseAddressOrderedFixedSizeDataPoolPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_SparseAddressOrderedFixedSizeDataPoolPointer(long address) {
		super(address);
	}

	public static MM_SparseAddressOrderedFixedSizeDataPoolPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_SparseAddressOrderedFixedSizeDataPoolPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_SparseAddressOrderedFixedSizeDataPoolPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_SparseAddressOrderedFixedSizeDataPoolPointer(address);
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer add(long count) {
		return MM_SparseAddressOrderedFixedSizeDataPoolPointer.cast(address + (MM_SparseAddressOrderedFixedSizeDataPool.SIZEOF * count));
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer addOffset(long offset) {
		return MM_SparseAddressOrderedFixedSizeDataPoolPointer.cast(address + offset);
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer sub(long count) {
		return MM_SparseAddressOrderedFixedSizeDataPoolPointer.cast(address - (MM_SparseAddressOrderedFixedSizeDataPool.SIZEOF * count));
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer subOffset(long offset) {
		return MM_SparseAddressOrderedFixedSizeDataPoolPointer.cast(address - offset);
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer untag(long mask) {
		return MM_SparseAddressOrderedFixedSizeDataPoolPointer.cast(address & ~mask);
	}

	public MM_SparseAddressOrderedFixedSizeDataPoolPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_SparseAddressOrderedFixedSizeDataPool.SIZEOF;
	}

	// Implementation methods

	// U64 _allocObjectCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__allocObjectCountOffset_", declaredType="U64")
	public UDATA _allocObjectCount() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__allocObjectCountOffset_));
	}

	// U64 _allocObjectCount
	public UDATAPointer _allocObjectCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__allocObjectCountOffset_));
	}

	// U64 _approxLargestFreeEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__approxLargestFreeEntryOffset_", declaredType="U64")
	public UDATA _approxLargestFreeEntry() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__approxLargestFreeEntryOffset_));
	}

	// U64 _approxLargestFreeEntry
	public UDATAPointer _approxLargestFreeEntryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__approxLargestFreeEntryOffset_));
	}

	// U64 _approximateFreeMemorySize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__approximateFreeMemorySizeOffset_", declaredType="U64")
	public UDATA _approximateFreeMemorySize() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__approximateFreeMemorySizeOffset_));
	}

	// U64 _approximateFreeMemorySize
	public UDATAPointer _approximateFreeMemorySizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__approximateFreeMemorySizeOffset_));
	}

	// MM_GCExtensionsBase* _extensions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__extensionsOffset_", declaredType="MM_GCExtensionsBase*")
	public MM_GCExtensionsBasePointer _extensions() throws CorruptDataException {
		return MM_GCExtensionsBasePointer.cast(getPointerAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__extensionsOffset_));
	}

	// MM_GCExtensionsBase* _extensions
	public PointerPointer _extensionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__extensionsOffset_));
	}

	// J9Pool* _freeListPool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__freeListPoolOffset_", declaredType="J9Pool*")
	public J9PoolPointer _freeListPool() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__freeListPoolOffset_));
	}

	// J9Pool* _freeListPool
	public PointerPointer _freeListPoolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__freeListPoolOffset_));
	}

	// U64 _freeListPoolAllocBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__freeListPoolAllocBytesOffset_", declaredType="U64")
	public UDATA _freeListPoolAllocBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__freeListPoolAllocBytesOffset_));
	}

	// U64 _freeListPoolAllocBytes
	public UDATAPointer _freeListPoolAllocBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__freeListPoolAllocBytesOffset_));
	}

	// U64 _freeListPoolFreeNodesCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__freeListPoolFreeNodesCountOffset_", declaredType="U64")
	public UDATA _freeListPoolFreeNodesCount() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__freeListPoolFreeNodesCountOffset_));
	}

	// U64 _freeListPoolFreeNodesCount
	public UDATAPointer _freeListPoolFreeNodesCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__freeListPoolFreeNodesCountOffset_));
	}

	// MM_SparseHeapLinkedFreeHeader* _heapFreeList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapFreeListOffset_", declaredType="MM_SparseHeapLinkedFreeHeader*")
	public MM_SparseHeapLinkedFreeHeaderPointer _heapFreeList() throws CorruptDataException {
		return MM_SparseHeapLinkedFreeHeaderPointer.cast(getPointerAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__heapFreeListOffset_));
	}

	// MM_SparseHeapLinkedFreeHeader* _heapFreeList
	public PointerPointer _heapFreeListEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__heapFreeListOffset_));
	}

	// void* _largestFreeEntryAddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__largestFreeEntryAddrOffset_", declaredType="void*")
	public VoidPointer _largestFreeEntryAddr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__largestFreeEntryAddrOffset_));
	}

	// void* _largestFreeEntryAddr
	public PointerPointer _largestFreeEntryAddrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__largestFreeEntryAddrOffset_));
	}

	// U64 _lastFreeBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__lastFreeBytesOffset_", declaredType="U64")
	public UDATA _lastFreeBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__lastFreeBytesOffset_));
	}

	// U64 _lastFreeBytes
	public UDATAPointer _lastFreeBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__lastFreeBytesOffset_));
	}

	// J9HashTable* _objectToSparseDataTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__objectToSparseDataTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _objectToSparseDataTable() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9HashTablePointer.cast(getPointerAtOffset(MM_SparseAddressOrderedFixedSizeDataPool.__objectToSparseDataTableOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9HashTable* _objectToSparseDataTable
	public PointerPointer _objectToSparseDataTableEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseAddressOrderedFixedSizeDataPool.__objectToSparseDataTableOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

}
