/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: procentry64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the procentry64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=procentry64.class)
public class procentry64Pointer extends StructurePointer {

	// NULL
	public static final procentry64Pointer NULL = new procentry64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected procentry64Pointer(long address) {
		super(address);
	}

	public static procentry64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static procentry64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static procentry64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new procentry64Pointer(address);
	}

	public procentry64Pointer add(long count) {
		return procentry64Pointer.cast(address + (procentry64.SIZEOF * count));
	}

	public procentry64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public procentry64Pointer addOffset(long offset) {
		return procentry64Pointer.cast(address + offset);
	}

	public procentry64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public procentry64Pointer sub(long count) {
		return procentry64Pointer.cast(address - (procentry64.SIZEOF * count));
	}

	public procentry64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public procentry64Pointer subOffset(long offset) {
		return procentry64Pointer.cast(address - offset);
	}

	public procentry64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public procentry64Pointer untag(long mask) {
		return procentry64Pointer.cast(address & ~mask);
	}

	public procentry64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return procentry64.SIZEOF;
	}

	// Implementation methods

	// I16 pi_acctflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_acctflagsOffset_", declaredType="I16")
	public I16 pi_acctflags() throws CorruptDataException {
		return new I16(getShortAtOffset(procentry64._pi_acctflagsOffset_));
	}

	// I16 pi_acctflags
	public I16Pointer pi_acctflagsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(procentry64._pi_acctflagsOffset_));
	}

	// u_longlong_t pi_adspace
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_adspaceOffset_", declaredType="u_longlong_t")
	public UDATA pi_adspace() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_adspaceOffset_));
	}

	// u_longlong_t pi_adspace
	public UDATAPointer pi_adspaceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_adspaceOffset_));
	}

	// u_longlong_t pi_adspace_ldr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_adspace_ldrOffset_", declaredType="u_longlong_t")
	public UDATA pi_adspace_ldr() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_adspace_ldrOffset_));
	}

	// u_longlong_t pi_adspace_ldr
	public UDATAPointer pi_adspace_ldrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_adspace_ldrOffset_));
	}

	// U8 pi_aslr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_aslrOffset_", declaredType="U8")
	public U8 pi_aslr() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_aslrOffset_));
	}

	// U8 pi_aslr
	public U8Pointer pi_aslrEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_aslrOffset_));
	}

	// U32 pi_aslr1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_aslr1Offset_", declaredType="U32")
	public UDATA pi_aslr1() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_aslr1Offset_));
	}

	// U32 pi_aslr1
	public UDATAPointer pi_aslr1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_aslr1Offset_));
	}

	// U32 pi_aslr2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_aslr2Offset_", declaredType="U32")
	public UDATA pi_aslr2() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_aslr2Offset_));
	}

	// U32 pi_aslr2
	public UDATAPointer pi_aslr2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_aslr2Offset_));
	}

	// U8 pi_boost_level
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_boost_levelOffset_", declaredType="U8")
	public U8 pi_boost_level() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_boost_levelOffset_));
	}

	// U8 pi_boost_level
	public U8Pointer pi_boost_levelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_boost_levelOffset_));
	}

	// U8 pi_boost_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_boost_typeOffset_", declaredType="U8")
	public U8 pi_boost_type() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_boost_typeOffset_));
	}

	// U8 pi_boost_type
	public U8Pointer pi_boost_typeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_boost_typeOffset_));
	}

	// u_longlong_t pi_cdir
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_cdirOffset_", declaredType="u_longlong_t")
	public UDATA pi_cdir() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_cdirOffset_));
	}

	// u_longlong_t pi_cdir
	public UDATAPointer pi_cdirEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_cdirOffset_));
	}

	// suseconds_t pi_chk_ctime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_chk_ctimeOffset_", declaredType="suseconds_t")
	public IDATA pi_chk_ctime() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_chk_ctimeOffset_));
	}

	// suseconds_t pi_chk_ctime
	public IDATAPointer pi_chk_ctimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_chk_ctimeOffset_));
	}

	// suseconds_t pi_chk_utime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_chk_utimeOffset_", declaredType="suseconds_t")
	public IDATA pi_chk_utime() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_chk_utimeOffset_));
	}

	// suseconds_t pi_chk_utime
	public IDATAPointer pi_chk_utimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_chk_utimeOffset_));
	}

	// cid_t pi_cid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_cidOffset_", declaredType="cid_t")
	public U16 pi_cid() throws CorruptDataException {
		return new U16(getShortAtOffset(procentry64._pi_cidOffset_));
	}

	// cid_t pi_cid
	public U16Pointer pi_cidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(procentry64._pi_cidOffset_));
	}

	// U8[] pi_classname
	public U8Pointer pi_classnameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_classnameOffset_));
	}

	// I16 pi_cmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_cmaskOffset_", declaredType="I16")
	public I16 pi_cmask() throws CorruptDataException {
		return new I16(getShortAtOffset(procentry64._pi_cmaskOffset_));
	}

	// I16 pi_cmask
	public I16Pointer pi_cmaskEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(procentry64._pi_cmaskOffset_));
	}

	// U8[] pi_comm
	public U8Pointer pi_commEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_commOffset_));
	}

	// uint pi_cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_cpuOffset_", declaredType="uint")
	public UDATA pi_cpu() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_cpuOffset_));
	}

	// uint pi_cpu
	public UDATAPointer pi_cpuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_cpuOffset_));
	}

	// cred_ext_t pi_cred
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_credOffset_", declaredType="cred_ext_t")
	public ucred_extPointer pi_cred() throws CorruptDataException {
		return ucred_extPointer.cast(nonNullFieldEA(procentry64._pi_credOffset_));
	}

	// cred_ext_t pi_cred
	public PointerPointer pi_credEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(procentry64._pi_credOffset_));
	}

	// trusage64 pi_cru
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_cruOffset_", declaredType="trusage64")
	public trusage64Pointer pi_cru() throws CorruptDataException {
		return trusage64Pointer.cast(nonNullFieldEA(procentry64._pi_cruOffset_));
	}

	// trusage64 pi_cru
	public PointerPointer pi_cruEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(procentry64._pi_cruOffset_));
	}

	// U64 pi_cvmem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_cvmemOffset_", declaredType="U64")
	public UDATA pi_cvmem() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_cvmemOffset_));
	}

	// U64 pi_cvmem
	public UDATAPointer pi_cvmemEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_cvmemOffset_));
	}

	// U8 pi_data_l2psize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_data_l2psizeOffset_", declaredType="U8")
	public U8 pi_data_l2psize() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_data_l2psizeOffset_));
	}

	// U8 pi_data_l2psize
	public U8Pointer pi_data_l2psizeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_data_l2psizeOffset_));
	}

	// u_longlong_t pi_drss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_drssOffset_", declaredType="u_longlong_t")
	public UDATA pi_drss() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_drssOffset_));
	}

	// u_longlong_t pi_drss
	public UDATAPointer pi_drssEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_drssOffset_));
	}

	// u_longlong_t pi_dsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_dsizeOffset_", declaredType="u_longlong_t")
	public UDATA pi_dsize() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_dsizeOffset_));
	}

	// u_longlong_t pi_dsize
	public UDATAPointer pi_dsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_dsizeOffset_));
	}

	// u_longlong_t pi_dvm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_dvmOffset_", declaredType="u_longlong_t")
	public UDATA pi_dvm() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_dvmOffset_));
	}

	// u_longlong_t pi_dvm
	public UDATAPointer pi_dvmEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_dvmOffset_));
	}

	// uint pi_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_flagsOffset_", declaredType="uint")
	public UDATA pi_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_flagsOffset_));
	}

	// uint pi_flags
	public UDATAPointer pi_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_flagsOffset_));
	}

	// uint pi_flags2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_flags2Offset_", declaredType="uint")
	public UDATA pi_flags2() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_flags2Offset_));
	}

	// uint pi_flags2
	public UDATAPointer pi_flags2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_flags2Offset_));
	}

	// longlong_t pi_ioch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_iochOffset_", declaredType="longlong_t")
	public IDATA pi_ioch() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_iochOffset_));
	}

	// longlong_t pi_ioch
	public IDATAPointer pi_iochEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_iochOffset_));
	}

	// longlong_t pi_irss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_irssOffset_", declaredType="longlong_t")
	public IDATA pi_irss() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_irssOffset_));
	}

	// longlong_t pi_irss
	public IDATAPointer pi_irssEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_irssOffset_));
	}

	// longlong_t pi_majflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_majfltOffset_", declaredType="longlong_t")
	public IDATA pi_majflt() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_majfltOffset_));
	}

	// longlong_t pi_majflt
	public IDATAPointer pi_majfltEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_majfltOffset_));
	}

	// uint pi_maxofile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_maxofileOffset_", declaredType="uint")
	public UDATA pi_maxofile() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_maxofileOffset_));
	}

	// uint pi_maxofile
	public UDATAPointer pi_maxofileEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_maxofileOffset_));
	}

	// longlong_t pi_minflt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_minfltOffset_", declaredType="longlong_t")
	public IDATA pi_minflt() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_minfltOffset_));
	}

	// longlong_t pi_minflt
	public IDATAPointer pi_minfltEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_minfltOffset_));
	}

	// uint pi_nice
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_niceOffset_", declaredType="uint")
	public UDATA pi_nice() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_niceOffset_));
	}

	// uint pi_nice
	public UDATAPointer pi_niceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_niceOffset_));
	}

	// uint pi_pad0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_pad0Offset_", declaredType="uint")
	public UDATA pi_pad0() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_pad0Offset_));
	}

	// uint pi_pad0
	public UDATAPointer pi_pad0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_pad0Offset_));
	}

	// I16 pi_pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_pad1Offset_", declaredType="I16")
	public I16 pi_pad1() throws CorruptDataException {
		return new I16(getShortAtOffset(procentry64._pi_pad1Offset_));
	}

	// I16 pi_pad1
	public I16Pointer pi_pad1EA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(procentry64._pi_pad1Offset_));
	}

	// pid32_t pi_pgrp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_pgrpOffset_", declaredType="pid32_t")
	public IDATA pi_pgrp() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_pgrpOffset_));
	}

	// pid32_t pi_pgrp
	public IDATAPointer pi_pgrpEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_pgrpOffset_));
	}

	// pid32_t pi_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_pidOffset_", declaredType="pid32_t")
	public IDATA pi_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_pidOffset_));
	}

	// pid32_t pi_pid
	public IDATAPointer pi_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_pidOffset_));
	}

	// uint pi_policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_policyOffset_", declaredType="uint")
	public UDATA pi_policy() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_policyOffset_));
	}

	// uint pi_policy
	public UDATAPointer pi_policyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_policyOffset_));
	}

	// pid32_t pi_ppid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_ppidOffset_", declaredType="pid32_t")
	public IDATA pi_ppid() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_ppidOffset_));
	}

	// pid32_t pi_ppid
	public IDATAPointer pi_ppidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_ppidOffset_));
	}

	// uint pi_ppri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_ppriOffset_", declaredType="uint")
	public UDATA pi_ppri() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_ppriOffset_));
	}

	// uint pi_ppri
	public UDATAPointer pi_ppriEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_ppriOffset_));
	}

	// uint pi_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_priOffset_", declaredType="uint")
	public UDATA pi_pri() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_priOffset_));
	}

	// uint pi_pri
	public UDATAPointer pi_priEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_priOffset_));
	}

	// u_longlong_t pi_prm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_prmOffset_", declaredType="u_longlong_t")
	public UDATA pi_prm() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_prmOffset_));
	}

	// u_longlong_t pi_prm
	public UDATAPointer pi_prmEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_prmOffset_));
	}

	// I32 pi_projid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_projidOffset_", declaredType="I32")
	public IDATA pi_projid() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_projidOffset_));
	}

	// I32 pi_projid
	public IDATAPointer pi_projidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_projidOffset_));
	}

	// u_longlong_t pi_rdir
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_rdirOffset_", declaredType="u_longlong_t")
	public UDATA pi_rdir() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_rdirOffset_));
	}

	// u_longlong_t pi_rdir
	public UDATAPointer pi_rdirEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_rdirOffset_));
	}

	// longlong_t pi_repage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_repageOffset_", declaredType="longlong_t")
	public IDATA pi_repage() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_repageOffset_));
	}

	// longlong_t pi_repage
	public IDATAPointer pi_repageEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_repageOffset_));
	}

	// U64[] pi_resvd
	public UDATAPointer pi_resvdEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(procentry64._pi_resvdOffset_));
	}

	// rlimit64[] pi_rlimit
	public rlimit64Pointer pi_rlimitEA() throws CorruptDataException {
		return rlimit64Pointer.cast(nonNullFieldEA(procentry64._pi_rlimitOffset_));
	}

	// trusage64 pi_ru
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_ruOffset_", declaredType="trusage64")
	public trusage64Pointer pi_ru() throws CorruptDataException {
		return trusage64Pointer.cast(nonNullFieldEA(procentry64._pi_ruOffset_));
	}

	// trusage64 pi_ru
	public PointerPointer pi_ruEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(procentry64._pi_ruOffset_));
	}

	// u_longlong_t pi_sdsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_sdsizeOffset_", declaredType="u_longlong_t")
	public UDATA pi_sdsize() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_sdsizeOffset_));
	}

	// u_longlong_t pi_sdsize
	public UDATAPointer pi_sdsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_sdsizeOffset_));
	}

	// U8 pi_shm_l2psize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_shm_l2psizeOffset_", declaredType="U8")
	public U8 pi_shm_l2psize() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_shm_l2psizeOffset_));
	}

	// U8 pi_shm_l2psize
	public U8Pointer pi_shm_l2psizeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_shm_l2psizeOffset_));
	}

	// pid32_t pi_sid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_sidOffset_", declaredType="pid32_t")
	public IDATA pi_sid() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_sidOffset_));
	}

	// pid32_t pi_sid
	public IDATAPointer pi_sidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_sidOffset_));
	}

	// sigset64_t pi_sig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_sigOffset_", declaredType="sigset64_t")
	public sigset64_tPointer pi_sig() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(procentry64._pi_sigOffset_));
	}

	// sigset64_t pi_sig
	public PointerPointer pi_sigEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(procentry64._pi_sigOffset_));
	}

	// uint[] pi_sigflags
	public UDATAPointer pi_sigflagsEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(procentry64._pi_sigflagsOffset_));
	}

	// u_longlong_t[] pi_signal
	public UDATAPointer pi_signalEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(procentry64._pi_signalOffset_));
	}

	// longlong_t pi_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_sizeOffset_", declaredType="longlong_t")
	public IDATA pi_size() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_sizeOffset_));
	}

	// longlong_t pi_size
	public IDATAPointer pi_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_sizeOffset_));
	}

	// U8 pi_stack_l2psize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_stack_l2psizeOffset_", declaredType="U8")
	public U8 pi_stack_l2psize() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_stack_l2psizeOffset_));
	}

	// U8 pi_stack_l2psize
	public U8Pointer pi_stack_l2psizeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_stack_l2psizeOffset_));
	}

	// time64_t pi_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_startOffset_", declaredType="time64_t")
	public IDATA pi_start() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_startOffset_));
	}

	// time64_t pi_start
	public IDATAPointer pi_startEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_startOffset_));
	}

	// uint pi_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_stateOffset_", declaredType="uint")
	public UDATA pi_state() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_stateOffset_));
	}

	// uint pi_state
	public UDATAPointer pi_stateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_stateOffset_));
	}

	// time64_t pi_stime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_stimeOffset_", declaredType="time64_t")
	public IDATA pi_stime() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_stimeOffset_));
	}

	// time64_t pi_stime
	public IDATAPointer pi_stimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_stimeOffset_));
	}

	// U32 pi_stkdelta
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_stkdeltaOffset_", declaredType="U32")
	public UDATA pi_stkdelta() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_stkdeltaOffset_));
	}

	// U32 pi_stkdelta
	public UDATAPointer pi_stkdeltaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_stkdeltaOffset_));
	}

	// U32 pi_stkorigsz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_stkorigszOffset_", declaredType="U32")
	public UDATA pi_stkorigsz() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_stkorigszOffset_));
	}

	// U32 pi_stkorigsz
	public UDATAPointer pi_stkorigszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_stkorigszOffset_));
	}

	// U64 pi_subproj
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_subprojOffset_", declaredType="U64")
	public UDATA pi_subproj() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_subprojOffset_));
	}

	// U64 pi_subproj
	public UDATAPointer pi_subprojEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_subprojOffset_));
	}

	// uid_t pi_suid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_suidOffset_", declaredType="uid_t")
	public UDATA pi_suid() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_suidOffset_));
	}

	// uid_t pi_suid
	public UDATAPointer pi_suidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_suidOffset_));
	}

	// U8[] pi_tag
	public U8Pointer pi_tagEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_tagOffset_));
	}

	// U8 pi_text_l2psize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_text_l2psizeOffset_", declaredType="U8")
	public U8 pi_text_l2psize() throws CorruptDataException {
		return new U8(getByteAtOffset(procentry64._pi_text_l2psizeOffset_));
	}

	// U8 pi_text_l2psize
	public U8Pointer pi_text_l2psizeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(procentry64._pi_text_l2psizeOffset_));
	}

	// uint pi_thcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_thcountOffset_", declaredType="uint")
	public UDATA pi_thcount() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_thcountOffset_));
	}

	// uint pi_thcount
	public UDATAPointer pi_thcountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_thcountOffset_));
	}

	// u_longlong_t pi_trss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_trssOffset_", declaredType="u_longlong_t")
	public UDATA pi_trss() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_trssOffset_));
	}

	// u_longlong_t pi_trss
	public UDATAPointer pi_trssEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_trssOffset_));
	}

	// u_longlong_t pi_tsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_tsizeOffset_", declaredType="u_longlong_t")
	public UDATA pi_tsize() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_tsizeOffset_));
	}

	// u_longlong_t pi_tsize
	public UDATAPointer pi_tsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_tsizeOffset_));
	}

	// dev64_t pi_ttyd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_ttydOffset_", declaredType="dev64_t")
	public UDATA pi_ttyd() throws CorruptDataException {
		return new U64(getLongAtOffset(procentry64._pi_ttydOffset_));
	}

	// dev64_t pi_ttyd
	public UDATAPointer pi_ttydEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_ttydOffset_));
	}

	// longlong_t pi_ttympx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_ttympxOffset_", declaredType="longlong_t")
	public IDATA pi_ttympx() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_ttympxOffset_));
	}

	// longlong_t pi_ttympx
	public IDATAPointer pi_ttympxEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_ttympxOffset_));
	}

	// pid32_t pi_ttyp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_ttypOffset_", declaredType="pid32_t")
	public IDATA pi_ttyp() throws CorruptDataException {
		return new I32(getIntAtOffset(procentry64._pi_ttypOffset_));
	}

	// pid32_t pi_ttyp
	public IDATAPointer pi_ttypEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_ttypOffset_));
	}

	// uid_t pi_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_uidOffset_", declaredType="uid_t")
	public UDATA pi_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(procentry64._pi_uidOffset_));
	}

	// uid_t pi_uid
	public UDATAPointer pi_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(procentry64._pi_uidOffset_));
	}

	// time64_t pi_utime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pi_utimeOffset_", declaredType="time64_t")
	public IDATA pi_utime() throws CorruptDataException {
		return new I64(getLongAtOffset(procentry64._pi_utimeOffset_));
	}

	// time64_t pi_utime
	public IDATAPointer pi_utimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(procentry64._pi_utimeOffset_));
	}

}
