/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: stat64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the stat64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=stat64.class)
public class stat64Pointer extends StructurePointer {

	// NULL
	public static final stat64Pointer NULL = new stat64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected stat64Pointer(long address) {
		super(address);
	}

	public static stat64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static stat64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static stat64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new stat64Pointer(address);
	}

	public stat64Pointer add(long count) {
		return stat64Pointer.cast(address + (stat64.SIZEOF * count));
	}

	public stat64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public stat64Pointer addOffset(long offset) {
		return stat64Pointer.cast(address + offset);
	}

	public stat64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public stat64Pointer sub(long count) {
		return stat64Pointer.cast(address - (stat64.SIZEOF * count));
	}

	public stat64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public stat64Pointer subOffset(long offset) {
		return stat64Pointer.cast(address - offset);
	}

	public stat64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public stat64Pointer untag(long mask) {
		return stat64Pointer.cast(address & ~mask);
	}

	public stat64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return stat64.SIZEOF;
	}

	// Implementation methods

	// st_timespec_t st_atim
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_atimOffset_", declaredType="st_timespec_t")
	public st_timespecPointer st_atim() throws CorruptDataException {
		return st_timespecPointer.cast(nonNullFieldEA(stat64._st_atimOffset_));
	}

	// st_timespec_t st_atim
	public PointerPointer st_atimEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(stat64._st_atimOffset_));
	}

	// blksize_t st_blksize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_blksizeOffset_", declaredType="blksize_t")
	public IDATA st_blksize() throws CorruptDataException {
		return new I64(getLongAtOffset(stat64._st_blksizeOffset_));
	}

	// blksize_t st_blksize
	public IDATAPointer st_blksizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64._st_blksizeOffset_));
	}

	// blkcnt_t st_blocks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_blocksOffset_", declaredType="blkcnt_t")
	public IDATA st_blocks() throws CorruptDataException {
		return new I64(getLongAtOffset(stat64._st_blocksOffset_));
	}

	// blkcnt_t st_blocks
	public IDATAPointer st_blocksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64._st_blocksOffset_));
	}

	// st_timespec_t st_ctim
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_ctimOffset_", declaredType="st_timespec_t")
	public st_timespecPointer st_ctim() throws CorruptDataException {
		return st_timespecPointer.cast(nonNullFieldEA(stat64._st_ctimOffset_));
	}

	// st_timespec_t st_ctim
	public PointerPointer st_ctimEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(stat64._st_ctimOffset_));
	}

	// dev_t st_dev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_devOffset_", declaredType="dev_t")
	public UDATA st_dev() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64._st_devOffset_));
	}

	// dev_t st_dev
	public UDATAPointer st_devEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_devOffset_));
	}

	// ushort_t st_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_flagOffset_", declaredType="ushort_t")
	public U16 st_flag() throws CorruptDataException {
		return new U16(getShortAtOffset(stat64._st_flagOffset_));
	}

	// ushort_t st_flag
	public U16Pointer st_flagEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(stat64._st_flagOffset_));
	}

	// uint_t st_gen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_genOffset_", declaredType="uint_t")
	public UDATA st_gen() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64._st_genOffset_));
	}

	// uint_t st_gen
	public UDATAPointer st_genEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_genOffset_));
	}

	// gid_t st_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_gidOffset_", declaredType="gid_t")
	public UDATA st_gid() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64._st_gidOffset_));
	}

	// gid_t st_gid
	public UDATAPointer st_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_gidOffset_));
	}

	// ino_t st_ino
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_inoOffset_", declaredType="ino_t")
	public UDATA st_ino() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64._st_inoOffset_));
	}

	// ino_t st_ino
	public UDATAPointer st_inoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_inoOffset_));
	}

	// mode_t st_mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_modeOffset_", declaredType="mode_t")
	public UDATA st_mode() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64._st_modeOffset_));
	}

	// mode_t st_mode
	public UDATAPointer st_modeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_modeOffset_));
	}

	// st_timespec_t st_mtim
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_mtimOffset_", declaredType="st_timespec_t")
	public st_timespecPointer st_mtim() throws CorruptDataException {
		return st_timespecPointer.cast(nonNullFieldEA(stat64._st_mtimOffset_));
	}

	// st_timespec_t st_mtim
	public PointerPointer st_mtimEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(stat64._st_mtimOffset_));
	}

	// nlink_t st_nlink
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_nlinkOffset_", declaredType="nlink_t")
	public I16 st_nlink() throws CorruptDataException {
		return new I16(getShortAtOffset(stat64._st_nlinkOffset_));
	}

	// nlink_t st_nlink
	public I16Pointer st_nlinkEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(stat64._st_nlinkOffset_));
	}

	// dev_t st_rdev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_rdevOffset_", declaredType="dev_t")
	public UDATA st_rdev() throws CorruptDataException {
		return new U64(getLongAtOffset(stat64._st_rdevOffset_));
	}

	// dev_t st_rdev
	public UDATAPointer st_rdevEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_rdevOffset_));
	}

	// uint_t[] st_reserved
	public UDATAPointer st_reservedEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(stat64._st_reservedOffset_));
	}

	// off_t st_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_sizeOffset_", declaredType="off_t")
	public IDATA st_size() throws CorruptDataException {
		return new I64(getLongAtOffset(stat64._st_sizeOffset_));
	}

	// off_t st_size
	public IDATAPointer st_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64._st_sizeOffset_));
	}

	// soff_t st_ssize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_ssizeOffset_", declaredType="soff_t")
	public IDATA st_ssize() throws CorruptDataException {
		return new I32(getIntAtOffset(stat64._st_ssizeOffset_));
	}

	// soff_t st_ssize
	public IDATAPointer st_ssizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64._st_ssizeOffset_));
	}

	// uint_t st_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_typeOffset_", declaredType="uint_t")
	public UDATA st_type() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64._st_typeOffset_));
	}

	// uint_t st_type
	public UDATAPointer st_typeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_typeOffset_));
	}

	// uid_t st_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_uidOffset_", declaredType="uid_t")
	public UDATA st_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64._st_uidOffset_));
	}

	// uid_t st_uid
	public UDATAPointer st_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_uidOffset_));
	}

	// uint_t st_vfs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_vfsOffset_", declaredType="uint_t")
	public UDATA st_vfs() throws CorruptDataException {
		return new U32(getIntAtOffset(stat64._st_vfsOffset_));
	}

	// uint_t st_vfs
	public UDATAPointer st_vfsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(stat64._st_vfsOffset_));
	}

	// I32 st_vfstype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_vfstypeOffset_", declaredType="I32")
	public IDATA st_vfstype() throws CorruptDataException {
		return new I32(getIntAtOffset(stat64._st_vfstypeOffset_));
	}

	// I32 st_vfstype
	public IDATAPointer st_vfstypeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(stat64._st_vfstypeOffset_));
	}

}
