/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: thrdentry64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the thrdentry64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=thrdentry64.class)
public class thrdentry64Pointer extends StructurePointer {

	// NULL
	public static final thrdentry64Pointer NULL = new thrdentry64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected thrdentry64Pointer(long address) {
		super(address);
	}

	public static thrdentry64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static thrdentry64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static thrdentry64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new thrdentry64Pointer(address);
	}

	public thrdentry64Pointer add(long count) {
		return thrdentry64Pointer.cast(address + (thrdentry64.SIZEOF * count));
	}

	public thrdentry64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public thrdentry64Pointer addOffset(long offset) {
		return thrdentry64Pointer.cast(address + offset);
	}

	public thrdentry64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public thrdentry64Pointer sub(long count) {
		return thrdentry64Pointer.cast(address - (thrdentry64.SIZEOF * count));
	}

	public thrdentry64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public thrdentry64Pointer subOffset(long offset) {
		return thrdentry64Pointer.cast(address - offset);
	}

	public thrdentry64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public thrdentry64Pointer untag(long mask) {
		return thrdentry64Pointer.cast(address & ~mask);
	}

	public thrdentry64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return thrdentry64.SIZEOF;
	}

	// Implementation methods

	// cpu_t ti_affinity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_affinityOffset_", declaredType="cpu_t")
	public I16 ti_affinity() throws CorruptDataException {
		return new I16(getShortAtOffset(thrdentry64._ti_affinityOffset_));
	}

	// cpu_t ti_affinity
	public I16Pointer ti_affinityEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thrdentry64._ti_affinityOffset_));
	}

	// U64 ti_code
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_codeOffset_", declaredType="U64")
	public UDATA ti_code() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_codeOffset_));
	}

	// U64 ti_code
	public UDATAPointer ti_codeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_codeOffset_));
	}

	// uint ti_cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_cpuOffset_", declaredType="uint")
	public UDATA ti_cpu() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_cpuOffset_));
	}

	// uint ti_cpu
	public UDATAPointer ti_cpuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_cpuOffset_));
	}

	// cpu_t ti_cpuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_cpuidOffset_", declaredType="cpu_t")
	public I16 ti_cpuid() throws CorruptDataException {
		return new I16(getShortAtOffset(thrdentry64._ti_cpuidOffset_));
	}

	// cpu_t ti_cpuid
	public I16Pointer ti_cpuidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thrdentry64._ti_cpuidOffset_));
	}

	// U8 ti_cursig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_cursigOffset_", declaredType="U8")
	public U8 ti_cursig() throws CorruptDataException {
		return new U8(getByteAtOffset(thrdentry64._ti_cursigOffset_));
	}

	// U8 ti_cursig
	public U8Pointer ti_cursigEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thrdentry64._ti_cursigOffset_));
	}

	// uint ti_dispct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_dispctOffset_", declaredType="uint")
	public UDATA ti_dispct() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_dispctOffset_));
	}

	// uint ti_dispct
	public UDATAPointer ti_dispctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_dispctOffset_));
	}

	// U64 ti_errnopp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_errnoppOffset_", declaredType="U64")
	public UDATA ti_errnopp() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_errnoppOffset_));
	}

	// U64 ti_errnopp
	public UDATAPointer ti_errnoppEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_errnoppOffset_));
	}

	// uint ti_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_flagOffset_", declaredType="uint")
	public UDATA ti_flag() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_flagOffset_));
	}

	// uint ti_flag
	public UDATAPointer ti_flagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_flagOffset_));
	}

	// uint ti_flag2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_flag2Offset_", declaredType="uint")
	public UDATA ti_flag2() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_flag2Offset_));
	}

	// uint ti_flag2
	public UDATAPointer ti_flag2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_flag2Offset_));
	}

	// uint ti_fpuct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_fpuctOffset_", declaredType="uint")
	public UDATA ti_fpuct() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_fpuctOffset_));
	}

	// uint ti_fpuct
	public UDATAPointer ti_fpuctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_fpuctOffset_));
	}

	// sradid_t ti_home_sradid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_home_sradidOffset_", declaredType="sradid_t")
	public I16 ti_home_sradid() throws CorruptDataException {
		return new I16(getShortAtOffset(thrdentry64._ti_home_sradidOffset_));
	}

	// sradid_t ti_home_sradid
	public I16Pointer ti_home_sradidEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(thrdentry64._ti_home_sradidOffset_));
	}

	// U64 ti_local_dispct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_local_dispctOffset_", declaredType="U64")
	public UDATA ti_local_dispct() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_local_dispctOffset_));
	}

	// U64 ti_local_dispct
	public UDATAPointer ti_local_dispctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_local_dispctOffset_));
	}

	// uint ti_nice
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_niceOffset_", declaredType="uint")
	public UDATA ti_nice() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_niceOffset_));
	}

	// uint ti_nice
	public UDATAPointer ti_niceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_niceOffset_));
	}

	// sigset64_t ti_oldmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_oldmaskOffset_", declaredType="sigset64_t")
	public sigset64_tPointer ti_oldmask() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(thrdentry64._ti_oldmaskOffset_));
	}

	// sigset64_t ti_oldmask
	public PointerPointer ti_oldmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thrdentry64._ti_oldmaskOffset_));
	}

	// U8 ti_pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_padOffset_", declaredType="U8")
	public U8 ti_pad() throws CorruptDataException {
		return new U8(getByteAtOffset(thrdentry64._ti_padOffset_));
	}

	// U8 ti_pad
	public U8Pointer ti_padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(thrdentry64._ti_padOffset_));
	}

	// uint ti_pad0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_pad0Offset_", declaredType="uint")
	public UDATA ti_pad0() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_pad0Offset_));
	}

	// uint ti_pad0
	public UDATAPointer ti_pad0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_pad0Offset_));
	}

	// pid32_t ti_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_pidOffset_", declaredType="pid32_t")
	public IDATA ti_pid() throws CorruptDataException {
		return new I32(getIntAtOffset(thrdentry64._ti_pidOffset_));
	}

	// pid32_t ti_pid
	public IDATAPointer ti_pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_pidOffset_));
	}

	// uint ti_policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_policyOffset_", declaredType="uint")
	public UDATA ti_policy() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_policyOffset_));
	}

	// uint ti_policy
	public UDATAPointer ti_policyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_policyOffset_));
	}

	// uint ti_pri
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_priOffset_", declaredType="uint")
	public UDATA ti_pri() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_priOffset_));
	}

	// uint ti_pri
	public UDATAPointer ti_priEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_priOffset_));
	}

	// trusage64 ti_ru
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_ruOffset_", declaredType="trusage64")
	public trusage64Pointer ti_ru() throws CorruptDataException {
		return trusage64Pointer.cast(nonNullFieldEA(thrdentry64._ti_ruOffset_));
	}

	// trusage64 ti_ru
	public PointerPointer ti_ruEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thrdentry64._ti_ruOffset_));
	}

	// uint ti_scount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_scountOffset_", declaredType="uint")
	public UDATA ti_scount() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_scountOffset_));
	}

	// uint ti_scount
	public UDATAPointer ti_scountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_scountOffset_));
	}

	// U64 ti_scp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_scpOffset_", declaredType="U64")
	public UDATA ti_scp() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_scpOffset_));
	}

	// U64 ti_scp
	public UDATAPointer ti_scpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_scpOffset_));
	}

	// sigset64_t ti_sig
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_sigOffset_", declaredType="sigset64_t")
	public sigset64_tPointer ti_sig() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(thrdentry64._ti_sigOffset_));
	}

	// sigset64_t ti_sig
	public PointerPointer ti_sigEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thrdentry64._ti_sigOffset_));
	}

	// sigset64_t ti_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_sigmaskOffset_", declaredType="sigset64_t")
	public sigset64_tPointer ti_sigmask() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(thrdentry64._ti_sigmaskOffset_));
	}

	// sigset64_t ti_sigmask
	public PointerPointer ti_sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thrdentry64._ti_sigmaskOffset_));
	}

	// U64 ti_sigsp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_sigspOffset_", declaredType="U64")
	public UDATA ti_sigsp() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_sigspOffset_));
	}

	// U64 ti_sigsp
	public UDATAPointer ti_sigspEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_sigspOffset_));
	}

	// U64 ti_sigssz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_sigsszOffset_", declaredType="U64")
	public UDATA ti_sigssz() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_sigsszOffset_));
	}

	// U64 ti_sigssz
	public UDATAPointer ti_sigsszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_sigsszOffset_));
	}

	// uint ti_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_sizeOffset_", declaredType="uint")
	public UDATA ti_size() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_sizeOffset_));
	}

	// uint ti_size
	public UDATAPointer ti_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_sizeOffset_));
	}

	// timestruc64_t ti_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_startOffset_", declaredType="timestruc64_t")
	public timestruc64_tPointer ti_start() throws CorruptDataException {
		return timestruc64_tPointer.cast(nonNullFieldEA(thrdentry64._ti_startOffset_));
	}

	// timestruc64_t ti_start
	public PointerPointer ti_startEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(thrdentry64._ti_startOffset_));
	}

	// uint ti_state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_stateOffset_", declaredType="uint")
	public UDATA ti_state() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_stateOffset_));
	}

	// uint ti_state
	public UDATAPointer ti_stateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_stateOffset_));
	}

	// U64 ti_stkb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_stkbOffset_", declaredType="U64")
	public UDATA ti_stkb() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_stkbOffset_));
	}

	// U64 ti_stkb
	public UDATAPointer ti_stkbEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_stkbOffset_));
	}

	// uint ti_ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_ticksOffset_", declaredType="uint")
	public UDATA ti_ticks() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_ticksOffset_));
	}

	// uint ti_ticks
	public UDATAPointer ti_ticksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_ticksOffset_));
	}

	// tid64_t ti_tid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_tidOffset_", declaredType="tid64_t")
	public UDATA ti_tid() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_tidOffset_));
	}

	// tid64_t ti_tid
	public UDATAPointer ti_tidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_tidOffset_));
	}

	// U64 ti_ucontext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_ucontextOffset_", declaredType="U64")
	public UDATA ti_ucontext() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_ucontextOffset_));
	}

	// U64 ti_ucontext
	public UDATAPointer ti_ucontextEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_ucontextOffset_));
	}

	// U64 ti_userdata
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_userdataOffset_", declaredType="U64")
	public UDATA ti_userdata() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_userdataOffset_));
	}

	// U64 ti_userdata
	public UDATAPointer ti_userdataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_userdataOffset_));
	}

	// U64 ti_ustk
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_ustkOffset_", declaredType="U64")
	public UDATA ti_ustk() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_ustkOffset_));
	}

	// U64 ti_ustk
	public UDATAPointer ti_ustkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_ustkOffset_));
	}

	// uint ti_watch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_watchOffset_", declaredType="uint")
	public UDATA ti_watch() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_watchOffset_));
	}

	// uint ti_watch
	public UDATAPointer ti_watchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_watchOffset_));
	}

	// U64 ti_wchan
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_wchanOffset_", declaredType="U64")
	public UDATA ti_wchan() throws CorruptDataException {
		return new U64(getLongAtOffset(thrdentry64._ti_wchanOffset_));
	}

	// U64 ti_wchan
	public UDATAPointer ti_wchanEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_wchanOffset_));
	}

	// uint ti_wtype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ti_wtypeOffset_", declaredType="uint")
	public UDATA ti_wtype() throws CorruptDataException {
		return new U32(getIntAtOffset(thrdentry64._ti_wtypeOffset_));
	}

	// uint ti_wtype
	public UDATAPointer ti_wtypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(thrdentry64._ti_wtypeOffset_));
	}

}
