/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9VMRuntimeFlags
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9VMRuntimeFlags {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9RuntimeFlagAOTStripped;
	public static final long J9RuntimeFlagAggressive;
	public static final long J9RuntimeFlagAggressiveVerification;
	public static final long J9RuntimeFlagAlwaysCopyJNICritical;
	public static final long J9RuntimeFlagArgencodingLatin;
	public static final long J9RuntimeFlagArgencodingUnicode;
	public static final long J9RuntimeFlagArgencodingUtf8;
	public static final long J9RuntimeFlagCleanUp;
	public static final long J9RuntimeFlagDFPBD;
	public static final long J9RuntimeFlagDisableVMShutdown;
	public static final long J9RuntimeFlagExitStarted;
	public static final long J9RuntimeFlagExtendedMethodBlock;
	public static final long J9RuntimeFlagInitialized;
	public static final long J9RuntimeFlagJITActive;
	public static final long J9RuntimeFlagJavaBaseModuleCreated;
	public static final long J9RuntimeFlagNoPriorities;
	public static final long J9RuntimeFlagOmitStackTraces;
	public static final long J9RuntimeFlagPPC32On64;
	public static final long J9RuntimeFlagPaintStack;
	public static final long J9RuntimeFlagReportStackUse;
	public static final long J9RuntimeFlagShowVersion;
	public static final long J9RuntimeFlagShutdown;
	public static final long J9RuntimeFlagShutdownStarted;
	public static final long J9RuntimeFlagSniffAndWhack;
	public static final long J9RuntimeFlagUnused0x10000000;
	public static final long J9RuntimeFlagUnused0x80;
	public static final long J9RuntimeFlagVerify;
	public static final long J9RuntimeFlagXfuture;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9RuntimeFlagAOTStripped = 0;
		J9RuntimeFlagAggressive = 0;
		J9RuntimeFlagAggressiveVerification = 0;
		J9RuntimeFlagAlwaysCopyJNICritical = 0;
		J9RuntimeFlagArgencodingLatin = 0;
		J9RuntimeFlagArgencodingUnicode = 0;
		J9RuntimeFlagArgencodingUtf8 = 0;
		J9RuntimeFlagCleanUp = 0;
		J9RuntimeFlagDFPBD = 0;
		J9RuntimeFlagDisableVMShutdown = 0;
		J9RuntimeFlagExitStarted = 0;
		J9RuntimeFlagExtendedMethodBlock = 0;
		J9RuntimeFlagInitialized = 0;
		J9RuntimeFlagJITActive = 0;
		J9RuntimeFlagJavaBaseModuleCreated = 0;
		J9RuntimeFlagNoPriorities = 0;
		J9RuntimeFlagOmitStackTraces = 0;
		J9RuntimeFlagPPC32On64 = 0;
		J9RuntimeFlagPaintStack = 0;
		J9RuntimeFlagReportStackUse = 0;
		J9RuntimeFlagShowVersion = 0;
		J9RuntimeFlagShutdown = 0;
		J9RuntimeFlagShutdownStarted = 0;
		J9RuntimeFlagSniffAndWhack = 0;
		J9RuntimeFlagUnused0x10000000 = 0;
		J9RuntimeFlagUnused0x80 = 0;
		J9RuntimeFlagVerify = 0;
		J9RuntimeFlagXfuture = 0;
	}

}
