/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_Scavenger
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_Scavenger {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __activeSubSpaceOffset_;
	public static final int __backOutDoneIndexOffset_;
	public static final int __cacheLineAlignmentOffset_;
	public static final int __cachedEntryCountOffset_;
	public static final int __cachedSemiSpaceResizableFlagOffset_;
	public static final int __cachesPerThreadOffset_;
	public static final int __collectionStatisticsOffset_;
	public static final int __concurrentPhaseOffset_;
	public static final int __concurrentPhaseStatsOffset_;
	public static final int __concurrentScavengerSwitchCountOffset_;
	public static final int __countSinceForcingGlobalGCOffset_;
	public static final int __currentPhaseConcurrentOffset_;
	public static final int __cycleStateOffset_;
	public static final int __cycleTimes$cycleEndOffset_;
	public static final int __cycleTimes$cycleStartOffset_;
	public static final int __cycleTimes$incrementEndOffset_;
	public static final int __cycleTimes$incrementStartOffset_;
	public static final int __delegateOffset_;
	public static final int __dispatcherOffset_;
	public static final int __doneIndexOffset_;
	public static final int __evacuateMemorySubSpaceOffset_;
	public static final int __evacuateSpaceBaseOffset_;
	public static final int __evacuateSpaceTopOffset_;
	public static final int __expandFailedOffset_;
	public static final int __expandTenureOnFailedAllocateOffset_;
	public static final int __extensionsOffset_;
	public static final int __failedTenureLargestObjectOffset_;
	public static final int __failedTenureThresholdReachedOffset_;
	public static final int __freeCacheMonitorOffset_;
	public static final int __heapBaseOffset_;
	public static final int __heapTopOffset_;
	public static final int __isRememberedSetInOverflowAtTheBeginningOffset_;
	public static final int __mainGCThreadOffset_;
	public static final int __minSemiSpaceFailureSizeOffset_;
	public static final int __minTenureFailureSizeOffset_;
	public static final int __objectAlignmentInBytesOffset_;
	public static final int __omrVMOffset_;
	public static final int __recommendedThreadsOffset_;
	public static final int __regionManagerOffset_;
	public static final int __rescanThreadsForRememberedObjectsOffset_;
	public static final int __scanCacheMonitorOffset_;
	public static final int __scavengeCacheFreeListOffset_;
	public static final int __scavengeCacheScanListOffset_;
	public static final int __shouldYieldOffset_;
	public static final int __survivorMemorySubSpaceOffset_;
	public static final int __survivorSpaceBaseOffset_;
	public static final int __survivorSpaceTopOffset_;
	public static final int __tenureMaskOffset_;
	public static final int __tenureMemorySubSpaceOffset_;
	public static final int __waitingCountOffset_;
	public static final int __waitingCountAliasThresholdOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__activeSubSpaceOffset_ = 0;
		__backOutDoneIndexOffset_ = 0;
		__cacheLineAlignmentOffset_ = 0;
		__cachedEntryCountOffset_ = 0;
		__cachedSemiSpaceResizableFlagOffset_ = 0;
		__cachesPerThreadOffset_ = 0;
		__collectionStatisticsOffset_ = 0;
		__concurrentPhaseOffset_ = 0;
		__concurrentPhaseStatsOffset_ = 0;
		__concurrentScavengerSwitchCountOffset_ = 0;
		__countSinceForcingGlobalGCOffset_ = 0;
		__currentPhaseConcurrentOffset_ = 0;
		__cycleStateOffset_ = 0;
		__cycleTimes$cycleEndOffset_ = 0;
		__cycleTimes$cycleStartOffset_ = 0;
		__cycleTimes$incrementEndOffset_ = 0;
		__cycleTimes$incrementStartOffset_ = 0;
		__delegateOffset_ = 0;
		__dispatcherOffset_ = 0;
		__doneIndexOffset_ = 0;
		__evacuateMemorySubSpaceOffset_ = 0;
		__evacuateSpaceBaseOffset_ = 0;
		__evacuateSpaceTopOffset_ = 0;
		__expandFailedOffset_ = 0;
		__expandTenureOnFailedAllocateOffset_ = 0;
		__extensionsOffset_ = 0;
		__failedTenureLargestObjectOffset_ = 0;
		__failedTenureThresholdReachedOffset_ = 0;
		__freeCacheMonitorOffset_ = 0;
		__heapBaseOffset_ = 0;
		__heapTopOffset_ = 0;
		__isRememberedSetInOverflowAtTheBeginningOffset_ = 0;
		__mainGCThreadOffset_ = 0;
		__minSemiSpaceFailureSizeOffset_ = 0;
		__minTenureFailureSizeOffset_ = 0;
		__objectAlignmentInBytesOffset_ = 0;
		__omrVMOffset_ = 0;
		__recommendedThreadsOffset_ = 0;
		__regionManagerOffset_ = 0;
		__rescanThreadsForRememberedObjectsOffset_ = 0;
		__scanCacheMonitorOffset_ = 0;
		__scavengeCacheFreeListOffset_ = 0;
		__scavengeCacheScanListOffset_ = 0;
		__shouldYieldOffset_ = 0;
		__survivorMemorySubSpaceOffset_ = 0;
		__survivorSpaceBaseOffset_ = 0;
		__survivorSpaceTopOffset_ = 0;
		__tenureMaskOffset_ = 0;
		__tenureMemorySubSpaceOffset_ = 0;
		__waitingCountOffset_ = 0;
		__waitingCountAliasThresholdOffset_ = 0;
	}

}
